/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.codec;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.qpid.transport.Binary;
import org.apache.qpid.transport.codec.AbstractDecoder;

public final class BBDecoder
extends AbstractDecoder {
    private ByteBuffer in;

    public void init(ByteBuffer in) {
        this.in = in;
        this.in.order(ByteOrder.BIG_ENDIAN);
    }

    public void releaseBuffer() {
        this.in = null;
    }

    protected byte doGet() {
        return this.in.get();
    }

    protected void doGet(byte[] bytes) {
        this.in.get(bytes);
    }

    protected Binary get(int size) {
        if (this.in.hasArray()) {
            byte[] bytes = this.in.array();
            Binary bin = new Binary(bytes, this.in.arrayOffset() + this.in.position(), size);
            this.in.position(this.in.position() + size);
            return bin;
        }
        return super.get(size);
    }

    public boolean hasRemaining() {
        return this.in.hasRemaining();
    }

    public short readUint8() {
        return (short)(0xFF & this.in.get());
    }

    public int readUint16() {
        return 0xFFFF & this.in.getShort();
    }

    public long readUint32() {
        return 0xFFFFFFFFL & (long)this.in.getInt();
    }

    public long readUint64() {
        return this.in.getLong();
    }

    public byte[] readBin128() {
        byte[] result = new byte[16];
        this.get(result);
        return result;
    }

    public byte[] readBytes(int howManyBytes) {
        byte[] result = new byte[howManyBytes];
        this.get(result);
        return result;
    }

    public double readDouble() {
        return this.in.getDouble();
    }

    public float readFloat() {
        return this.in.getFloat();
    }

    public short readInt16() {
        return this.in.getShort();
    }

    public int readInt32() {
        return this.in.getInt();
    }

    public byte readInt8() {
        return this.in.get();
    }

    public byte[] readReaminingBytes() {
        byte[] result = new byte[this.in.limit() - this.in.position()];
        this.get(result);
        return result;
    }

    public long readInt64() {
        return this.in.getLong();
    }
}

