/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import lombok.Generated;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DMLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.OracleStatementParser;
import org.apache.shardingsphere.sql.parser.oracle.visitor.statement.impl.OracleStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.constant.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.ColumnAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.InsertValuesSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.assignment.SetAssignmentSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonTableExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.LiteralExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubqueryExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionsSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.SubqueryProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ColumnOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.HavingSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.InsertMultiTableElementSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.ModelSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.SQLUtil;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.BooleanLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleDeleteStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleInsertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleMergeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleUpdateStatement;

public final class OracleDMLStatementSQLVisitor
extends OracleStatementSQLVisitor
implements DMLSQLVisitor,
SQLStatementVisitor {
    public OracleDMLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitInsert(OracleStatementParser.InsertContext ctx) {
        return null == ctx.insertSingleTable() ? (ASTNode)this.visit((ParseTree)ctx.insertMultiTable()) : (ASTNode)this.visit((ParseTree)ctx.insertSingleTable());
    }

    @Override
    public ASTNode visitInsertSingleTable(OracleStatementParser.InsertSingleTableContext ctx) {
        OracleInsertStatement result = (OracleInsertStatement)this.visit((ParseTree)ctx.insertIntoClause());
        if (null != ctx.insertValuesClause()) {
            result.getValues().addAll(this.createInsertValuesSegments(ctx.insertValuesClause().assignmentValues()));
        }
        if (null != ctx.selectSubquery()) {
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
            result.setSelectSubquery(subquerySegment);
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    private Collection<InsertValuesSegment> createInsertValuesSegments(OracleStatementParser.AssignmentValuesContext ctx) {
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        result.add((InsertValuesSegment)this.visit((ParseTree)ctx));
        return result;
    }

    @Override
    public ASTNode visitInsertMultiTable(OracleStatementParser.InsertMultiTableContext ctx) {
        OracleInsertStatement result = new OracleInsertStatement();
        if (null != ctx.conditionalInsertClause()) {
            result.setInsertMultiTableElementSegment((InsertMultiTableElementSegment)this.visit((ParseTree)ctx.conditionalInsertClause()));
        } else {
            result.setInsertMultiTableElementSegment(this.createInsertMultiTableElementSegment(ctx.multiTableElement()));
        }
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
        result.setSelectSubquery(subquerySegment);
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    private InsertMultiTableElementSegment createInsertMultiTableElementSegment(List<OracleStatementParser.MultiTableElementContext> ctx) {
        LinkedList<OracleInsertStatement> insertStatements = new LinkedList<OracleInsertStatement>();
        for (OracleStatementParser.MultiTableElementContext each : ctx) {
            insertStatements.add((OracleInsertStatement)this.visit((ParseTree)each));
        }
        InsertMultiTableElementSegment result = new InsertMultiTableElementSegment(ctx.get(0).getStart().getStartIndex(), ctx.get(ctx.size() - 1).getStop().getStopIndex());
        result.getInsertStatements().addAll(insertStatements);
        return result;
    }

    @Override
    public ASTNode visitInsertValuesClause(OracleStatementParser.InsertValuesClauseContext ctx) {
        OracleInsertStatement result = new OracleInsertStatement();
        result.getValues().addAll(this.createInsertValuesSegments(ctx.assignmentValues()));
        return result;
    }

    @Override
    public ASTNode visitInsertIntoClause(OracleStatementParser.InsertIntoClauseContext ctx) {
        OracleInsertStatement result = new OracleInsertStatement();
        if (null != ctx.dmlTableExprClause().dmlTableClause()) {
            result.setTable((SimpleTableSegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlTableClause()));
        } else if (null != ctx.dmlTableExprClause().dmlSubqueryClause()) {
            result.setInsertSelect((SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlSubqueryClause()));
        } else {
            result.setInsertSelect((SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().tableCollectionExpr()));
        }
        if (null != ctx.columnNames()) {
            OracleStatementParser.ColumnNamesContext columnNames = ctx.columnNames();
            CollectionValue columnSegments = (CollectionValue)this.visit((ParseTree)columnNames);
            result.setInsertColumns(new InsertColumnsSegment(columnNames.start.getStartIndex(), columnNames.stop.getStopIndex(), columnSegments.getValue()));
        } else {
            result.setInsertColumns(new InsertColumnsSegment(ctx.stop.getStopIndex() + 1, ctx.stop.getStopIndex() + 1, Collections.emptyList()));
        }
        return result;
    }

    @Override
    public ASTNode visitDmlTableClause(OracleStatementParser.DmlTableClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitDmlSubqueryClause(OracleStatementParser.DmlSubqueryClauseContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
    }

    @Override
    public ASTNode visitTableCollectionExpr(OracleStatementParser.TableCollectionExprContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.collectionExpr().selectSubquery());
        return new SubquerySegment(ctx.collectionExpr().selectSubquery().start.getStartIndex(), ctx.collectionExpr().selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
    }

    @Override
    public ASTNode visitConditionalInsertClause(OracleStatementParser.ConditionalInsertClauseContext ctx) {
        LinkedList<OracleInsertStatement> insertStatements = new LinkedList<OracleInsertStatement>();
        for (OracleStatementParser.ConditionalInsertWhenPartContext each : ctx.conditionalInsertWhenPart()) {
            insertStatements.addAll(this.createInsertStatementsFromConditionalInsertWhen(each));
        }
        if (null != ctx.conditionalInsertElsePart()) {
            insertStatements.addAll(this.createInsertStatementsFromConditionalInsertElse(ctx.conditionalInsertElsePart()));
        }
        InsertMultiTableElementSegment result = new InsertMultiTableElementSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        result.getInsertStatements().addAll(insertStatements);
        return result;
    }

    private Collection<OracleInsertStatement> createInsertStatementsFromConditionalInsertWhen(OracleStatementParser.ConditionalInsertWhenPartContext ctx) {
        LinkedList<OracleInsertStatement> result = new LinkedList<OracleInsertStatement>();
        for (OracleStatementParser.MultiTableElementContext each : ctx.multiTableElement()) {
            result.add((OracleInsertStatement)this.visit((ParseTree)each));
        }
        return result;
    }

    private Collection<OracleInsertStatement> createInsertStatementsFromConditionalInsertElse(OracleStatementParser.ConditionalInsertElsePartContext ctx) {
        LinkedList<OracleInsertStatement> result = new LinkedList<OracleInsertStatement>();
        for (OracleStatementParser.MultiTableElementContext each : ctx.multiTableElement()) {
            result.add((OracleInsertStatement)this.visit((ParseTree)each));
        }
        return result;
    }

    @Override
    public ASTNode visitMultiTableElement(OracleStatementParser.MultiTableElementContext ctx) {
        OracleInsertStatement result = (OracleInsertStatement)this.visit((ParseTree)ctx.insertIntoClause());
        if (null != ctx.insertValuesClause()) {
            result.getValues().addAll(this.createInsertValuesSegments(ctx.insertValuesClause().assignmentValues()));
        }
        return result;
    }

    @Override
    public ASTNode visitUpdate(OracleStatementParser.UpdateContext ctx) {
        OracleUpdateStatement result = new OracleUpdateStatement();
        result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.updateSpecification()));
        if (null != ctx.alias()) {
            result.getTableSegment().setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        result.setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.updateSetClause()));
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitUpdateSpecification(OracleStatementParser.UpdateSpecificationContext ctx) {
        if (null != ctx.dmlTableExprClause().dmlTableClause()) {
            return (ASTNode)this.visit((ParseTree)ctx.dmlTableExprClause().dmlTableClause());
        }
        if (null != ctx.dmlTableExprClause().dmlSubqueryClause()) {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlSubqueryClause());
            return new SubqueryTableSegment(subquerySegment);
        }
        SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().tableCollectionExpr());
        return new SubqueryTableSegment(subquerySegment);
    }

    @Override
    public ASTNode visitUpdateSetClause(OracleStatementParser.UpdateSetClauseContext ctx) {
        LinkedList<AssignmentSegment> assignments = new LinkedList<AssignmentSegment>();
        if (null != ctx.updateSetColumnList()) {
            for (OracleStatementParser.UpdateSetColumnClauseContext each : ctx.updateSetColumnList().updateSetColumnClause()) {
                assignments.add((AssignmentSegment)this.visit((ParseTree)each));
            }
        } else {
            assignments.add((AssignmentSegment)this.visit((ParseTree)ctx.updateSetValueClause()));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitUpdateSetColumnClause(OracleStatementParser.UpdateSetColumnClauseContext ctx) {
        return 1 == ctx.columnName().size() ? this.createAssignmentSegmentFromSingleColumnAssignment(ctx) : this.createAssignmentSegmentFromMultiColumnAssignment(ctx);
    }

    private AssignmentSegment createAssignmentSegmentFromSingleColumnAssignment(OracleStatementParser.UpdateSetColumnClauseContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName(0));
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        if (null != ctx.expr()) {
            ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
        }
        if (null != ctx.selectSubquery()) {
            SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery())));
            SubqueryExpressionSegment value = new SubqueryExpressionSegment(subquerySegment);
            ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
            result.getColumns().add(column);
            return result;
        }
        CommonExpressionSegment value = new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.DEFAULT().getText());
        ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
        result.getColumns().add(column);
        return result;
    }

    private AssignmentSegment createAssignmentSegmentFromMultiColumnAssignment(OracleStatementParser.UpdateSetColumnClauseContext ctx) {
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.ColumnNameContext each : ctx.columnName()) {
            columnSegments.add((ColumnSegment)this.visit((ParseTree)each));
        }
        SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery())));
        SubqueryExpressionSegment value = new SubqueryExpressionSegment(subquerySegment);
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
    }

    @Override
    public ASTNode visitUpdateSetValueClause(OracleStatementParser.UpdateSetValueClauseContext ctx) {
        ColumnSegment column = new ColumnSegment(ctx.alias().start.getStartIndex(), ctx.alias().stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.alias().identifier()));
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        if (null != ctx.expr()) {
            ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
            result.getColumns().add(column);
            return result;
        }
        SubquerySegment subquerySegment = new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery())));
        SubqueryExpressionSegment value = new SubqueryExpressionSegment(subquerySegment);
        ColumnAssignmentSegment result = new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, (ExpressionSegment)value);
        result.getColumns().add(column);
        return result;
    }

    @Override
    public ASTNode visitAssignmentValues(OracleStatementParser.AssignmentValuesContext ctx) {
        LinkedList<ExpressionSegment> segments = new LinkedList<ExpressionSegment>();
        for (OracleStatementParser.AssignmentValueContext each : ctx.assignmentValue()) {
            segments.add((ExpressionSegment)this.visit((ParseTree)each));
        }
        return new InsertValuesSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), segments);
    }

    @Override
    public ASTNode visitAssignmentValue(OracleStatementParser.AssignmentValueContext ctx) {
        OracleStatementParser.ExprContext expr = ctx.expr();
        return null == expr ? new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText()) : (ASTNode)this.visit((ParseTree)expr);
    }

    @Override
    public ASTNode visitDelete(OracleStatementParser.DeleteContext ctx) {
        OracleDeleteStatement result = new OracleDeleteStatement();
        result.setTableSegment((TableSegment)this.visit((ParseTree)ctx.deleteSpecification()));
        if (null != ctx.alias()) {
            result.getTableSegment().setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        return result;
    }

    @Override
    public ASTNode visitDeleteSpecification(OracleStatementParser.DeleteSpecificationContext ctx) {
        if (null != ctx.dmlTableExprClause().dmlTableClause()) {
            return (ASTNode)this.visit((ParseTree)ctx.dmlTableExprClause().dmlTableClause());
        }
        if (null != ctx.dmlTableExprClause().dmlSubqueryClause()) {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().dmlSubqueryClause());
            return new SubqueryTableSegment(subquerySegment);
        }
        SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.dmlTableExprClause().tableCollectionExpr());
        return new SubqueryTableSegment(subquerySegment);
    }

    @Override
    public ASTNode visitSelect(OracleStatementParser.SelectContext ctx) {
        OracleSelectStatement result = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        result.setParameterCount(this.getCurrentParameterIndex());
        result.getParameterMarkerSegments().addAll(this.getParameterMarkerSegments());
        if (null != ctx.forUpdateClause()) {
            result.setLock((LockSegment)this.visit((ParseTree)ctx.forUpdateClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitSelectSubquery(OracleStatementParser.SelectSubqueryContext ctx) {
        OracleSelectStatement result = null != ctx.queryBlock() ? (OracleSelectStatement)this.visit((ParseTree)ctx.queryBlock()) : (null != ctx.selectUnionClause() ? (OracleSelectStatement)this.visit((ParseTree)ctx.selectUnionClause()) : (OracleSelectStatement)this.visit((ParseTree)ctx.parenthesisSelectSubquery()));
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitQueryBlock(OracleStatementParser.QueryBlockContext ctx) {
        OracleSelectStatement result = new OracleSelectStatement();
        result.setProjections((ProjectionsSegment)this.visit((ParseTree)ctx.selectList()));
        if (null != ctx.withClause()) {
            result.setWithSegment((WithSegment)this.visit((ParseTree)ctx.withClause()));
        }
        if (null != ctx.duplicateSpecification()) {
            result.getProjections().setDistinctRow(this.isDistinct(ctx));
        }
        if (null != ctx.selectFromClause()) {
            TableSegment tableSegment = (TableSegment)this.visit((ParseTree)ctx.selectFromClause());
            result.setFrom(tableSegment);
        }
        if (null != ctx.whereClause()) {
            result.setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.groupByClause()) {
            result.setGroupBy((GroupBySegment)this.visit((ParseTree)ctx.groupByClause()));
            if (null != ctx.groupByClause().havingClause()) {
                result.setHaving((HavingSegment)this.visit((ParseTree)ctx.groupByClause().havingClause()));
            }
        }
        if (null != ctx.modelClause()) {
            result.setModelSegment((ModelSegment)this.visit((ParseTree)ctx.modelClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitHavingClause(OracleStatementParser.HavingClauseContext ctx) {
        ExpressionSegment expr = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
        return new HavingSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), expr);
    }

    @Override
    public ASTNode visitModelClause(OracleStatementParser.ModelClauseContext ctx) {
        ModelSegment result = new ModelSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex());
        if (null != ctx.referenceModel()) {
            for (OracleStatementParser.ReferenceModelContext referenceModelContext : ctx.referenceModel()) {
                result.getReferenceModelSelect().add((SubquerySegment)this.visit((ParseTree)referenceModelContext));
            }
        }
        if (null != ctx.mainModel().modelRulesClause().orderByClause()) {
            for (OracleStatementParser.OrderByClauseContext orderByClauseContext : ctx.mainModel().modelRulesClause().orderByClause()) {
                result.getOrderBySegments().add((OrderBySegment)this.visit((ParseTree)orderByClauseContext));
            }
        }
        for (OracleStatementParser.CellAssignmentContext cellAssignmentContext : ctx.mainModel().modelRulesClause().cellAssignment()) {
            result.getCellAssignmentColumns().add((ColumnSegment)this.visit((ParseTree)cellAssignmentContext.measureColumn().columnName()));
            if (null != cellAssignmentContext.singleColumnForLoop()) {
                result.getCellAssignmentColumns().addAll(this.extractColumnValuesFromSingleColumnForLoop(cellAssignmentContext.singleColumnForLoop()));
                result.getCellAsssignmentSelect().addAll(this.extractSelectSubqueryValuesFromSingleColumnForLoop(cellAssignmentContext.singleColumnForLoop()));
            }
            if (null == cellAssignmentContext.multiColumnForLoop()) continue;
            result.getCellAssignmentColumns().addAll(this.extractColumnValuesFromMultiColumnForLoop(cellAssignmentContext.multiColumnForLoop()));
            result.getCellAsssignmentSelect().add(this.extractSelectSubqueryValueFromMultiColumnForLoop(cellAssignmentContext.multiColumnForLoop()));
        }
        return result;
    }

    private Collection<ColumnSegment> extractColumnValuesFromSingleColumnForLoop(List<OracleStatementParser.SingleColumnForLoopContext> ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.SingleColumnForLoopContext each : ctx) {
            result.add((ColumnSegment)this.visit((ParseTree)each.dimensionColumn().columnName()));
        }
        return result;
    }

    private Collection<SubquerySegment> extractSelectSubqueryValuesFromSingleColumnForLoop(List<OracleStatementParser.SingleColumnForLoopContext> ctx) {
        LinkedList<SubquerySegment> result = new LinkedList<SubquerySegment>();
        for (OracleStatementParser.SingleColumnForLoopContext each : ctx) {
            if (null == each.selectSubquery()) continue;
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)each.selectSubquery());
            SubquerySegment subquerySegment = new SubquerySegment(each.selectSubquery().start.getStartIndex(), each.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
            result.add(subquerySegment);
        }
        return result;
    }

    private Collection<ColumnSegment> extractColumnValuesFromMultiColumnForLoop(OracleStatementParser.MultiColumnForLoopContext ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.DimensionColumnContext each : ctx.dimensionColumn()) {
            result.add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    private SubquerySegment extractSelectSubqueryValueFromMultiColumnForLoop(OracleStatementParser.MultiColumnForLoopContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
    }

    @Override
    public ASTNode visitReferenceModel(OracleStatementParser.ReferenceModelContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
    }

    @Override
    public ASTNode visitSelectUnionClause(OracleStatementParser.SelectUnionClauseContext ctx) {
        OracleSelectStatement result = null != ctx.queryBlock() ? (OracleSelectStatement)this.visit((ParseTree)ctx.queryBlock()) : (OracleSelectStatement)this.visit((ParseTree)ctx.parenthesisSelectSubquery());
        if (null != ctx.orderByClause()) {
            result.setOrderBy((OrderBySegment)this.visit((ParseTree)ctx.orderByClause()));
        }
        for (OracleStatementParser.SelectSubqueryContext each : ctx.selectSubquery()) {
            this.visit((ParseTree)each);
        }
        return result;
    }

    @Override
    public ASTNode visitParenthesisSelectSubquery(OracleStatementParser.ParenthesisSelectSubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    @Override
    public ASTNode visitWithClause(OracleStatementParser.WithClauseContext ctx) {
        LinkedList<CommonTableExpressionSegment> commonTableExpressions = new LinkedList<CommonTableExpressionSegment>();
        if (null != ctx.subqueryFactoringClause()) {
            for (OracleStatementParser.SubqueryFactoringClauseContext each : ctx.subqueryFactoringClause()) {
                SubquerySegment subquery = new SubquerySegment(each.selectSubquery().start.getStartIndex(), each.selectSubquery().stop.getStopIndex(), (SelectStatement)((OracleSelectStatement)this.visit((ParseTree)each)));
                IdentifierValue identifier = (IdentifierValue)this.visit((ParseTree)each.queryName().name().identifier());
                CommonTableExpressionSegment commonTableExpression = new CommonTableExpressionSegment(each.start.getStartIndex(), each.stop.getStopIndex(), identifier, subquery);
                if (null != each.searchClause()) {
                    OracleStatementParser.ColumnNameContext columnName = each.searchClause().orderingColumn().columnName();
                    commonTableExpression.getColumns().add((ColumnSegment)this.visit((ParseTree)columnName));
                }
                commonTableExpressions.add(commonTableExpression);
            }
        }
        return new WithSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), commonTableExpressions);
    }

    @Override
    public ASTNode visitSubqueryFactoringClause(OracleStatementParser.SubqueryFactoringClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    private boolean isDistinct(OracleStatementParser.QueryBlockContext ctx) {
        return ((BooleanLiteralValue)this.visit((ParseTree)ctx.duplicateSpecification())).getValue();
    }

    @Override
    public ASTNode visitDuplicateSpecification(OracleStatementParser.DuplicateSpecificationContext ctx) {
        if (null != ctx.DISTINCT() || null != ctx.UNIQUE()) {
            return new BooleanLiteralValue(true);
        }
        return new BooleanLiteralValue(false);
    }

    @Override
    public ASTNode visitSelectList(OracleStatementParser.SelectListContext ctx) {
        ProjectionsSegment result = new ProjectionsSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        LinkedList<Object> projections = new LinkedList<Object>();
        if (null != ctx.unqualifiedShorthand()) {
            projections.add(new ShorthandProjectionSegment(ctx.unqualifiedShorthand().getStart().getStartIndex(), ctx.unqualifiedShorthand().getStop().getStopIndex()));
            result.getProjections().addAll(projections);
            return result;
        }
        for (OracleStatementParser.SelectProjectionContext each : ctx.selectProjection()) {
            projections.add((ProjectionSegment)this.visit((ParseTree)each));
        }
        result.getProjections().addAll(projections);
        return result;
    }

    @Override
    public ASTNode visitSelectProjection(OracleStatementParser.SelectProjectionContext ctx) {
        if (null != ctx.queryName()) {
            OracleStatementParser.QueryNameContext queryName = ctx.queryName();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(queryName.getStart().getStartIndex(), ctx.DOT_ASTERISK_().getSymbol().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(queryName.getText());
            result.setOwner(new OwnerSegment(queryName.getStart().getStartIndex(), queryName.getStop().getStopIndex(), identifier));
            return result;
        }
        if (null != ctx.tableName()) {
            OracleStatementParser.TableNameContext tableName = ctx.tableName();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(tableName.getStart().getStartIndex(), ctx.DOT_ASTERISK_().getSymbol().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(tableName.getText());
            result.setOwner(new OwnerSegment(tableName.getStart().getStartIndex(), tableName.getStop().getStopIndex(), identifier));
            return result;
        }
        if (null != ctx.alias()) {
            OracleStatementParser.AliasContext aliasContext = ctx.alias();
            ShorthandProjectionSegment result = new ShorthandProjectionSegment(aliasContext.getStart().getStartIndex(), ctx.DOT_ASTERISK_().getSymbol().getStopIndex());
            IdentifierValue identifier = new IdentifierValue(aliasContext.getText());
            result.setOwner(new OwnerSegment(aliasContext.getStart().getStartIndex(), aliasContext.getStop().getStopIndex(), identifier));
            return result;
        }
        return this.createProjection(ctx.selectProjectionExprClause());
    }

    @Override
    public ASTNode visitAlias(OracleStatementParser.AliasContext ctx) {
        if (null != ctx.identifier()) {
            return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.identifier()));
        }
        return new AliasSegment(ctx.start.getStartIndex(), ctx.stop.getStopIndex(), new IdentifierValue(ctx.STRING_().getText()));
    }

    private ASTNode createProjection(OracleStatementParser.SelectProjectionExprClauseContext ctx) {
        AliasSegment alias = null == ctx.alias() ? null : (AliasSegment)this.visit((ParseTree)ctx.alias());
        ASTNode projection = (ASTNode)this.visit((ParseTree)ctx.expr());
        if (projection instanceof AggregationProjectionSegment) {
            ((AggregationProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof ExpressionProjectionSegment) {
            ((ExpressionProjectionSegment)projection).setAlias(alias);
            return projection;
        }
        if (projection instanceof FunctionSegment) {
            FunctionSegment segment = (FunctionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText(), (ExpressionSegment)segment);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof CommonExpressionSegment) {
            CommonExpressionSegment segment = (CommonExpressionSegment)projection;
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(segment.getStartIndex(), segment.getStopIndex(), segment.getText());
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof ColumnSegment) {
            ColumnProjectionSegment result = new ColumnProjectionSegment((ColumnSegment)projection);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof SubqueryExpressionSegment) {
            SubqueryExpressionSegment subqueryExpressionSegment = (SubqueryExpressionSegment)projection;
            String text = ctx.start.getInputStream().getText(new Interval(subqueryExpressionSegment.getStartIndex(), subqueryExpressionSegment.getStopIndex()));
            SubqueryProjectionSegment result = new SubqueryProjectionSegment(((SubqueryExpressionSegment)projection).getSubquery(), text);
            result.setAlias(alias);
            return result;
        }
        if (projection instanceof BinaryOperationExpression) {
            int startIndex = ((BinaryOperationExpression)projection).getStartIndex();
            int stopIndex = null != alias ? alias.getStopIndex() : ((BinaryOperationExpression)projection).getStopIndex();
            ExpressionProjectionSegment result = new ExpressionProjectionSegment(startIndex, stopIndex, ((BinaryOperationExpression)projection).getText());
            result.setAlias(alias);
            return result;
        }
        LiteralExpressionSegment column = (LiteralExpressionSegment)projection;
        ExpressionProjectionSegment result = null == alias ? new ExpressionProjectionSegment(column.getStartIndex(), column.getStopIndex(), String.valueOf(column.getLiterals())) : new ExpressionProjectionSegment(column.getStartIndex(), ctx.alias().stop.getStopIndex(), String.valueOf(column.getLiterals()));
        result.setAlias(alias);
        return result;
    }

    @Override
    public ASTNode visitSelectFromClause(OracleStatementParser.SelectFromClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.fromClauseList());
    }

    @Override
    public ASTNode visitFromClauseList(OracleStatementParser.FromClauseListContext ctx) {
        TableSegment result = (TableSegment)this.visit((ParseTree)ctx.fromClauseOption(0));
        if (ctx.fromClauseOption().size() > 1) {
            for (int i = 1; i < ctx.fromClauseOption().size(); ++i) {
                result = this.generateJoinTableSourceFromFromClauseOption(ctx.fromClauseOption(i), result);
            }
        }
        return result;
    }

    private JoinTableSegment generateJoinTableSourceFromFromClauseOption(OracleStatementParser.FromClauseOptionContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        result.setLeft(tableSegment);
        result.setRight((TableSegment)this.visit((ParseTree)ctx));
        return result;
    }

    @Override
    public ASTNode visitFromClauseOption(OracleStatementParser.FromClauseOptionContext ctx) {
        if (null != ctx.joinClause()) {
            return (ASTNode)this.visit((ParseTree)ctx.joinClause());
        }
        return (ASTNode)this.visit((ParseTree)ctx.selectTableReference());
    }

    @Override
    public ASTNode visitJoinClause(OracleStatementParser.JoinClauseContext ctx) {
        TableSegment left = (TableSegment)this.visit((ParseTree)ctx.selectTableReference());
        for (OracleStatementParser.SelectJoinOptionContext each : ctx.selectJoinOption()) {
            left = this.visitJoinedTable(each, left);
        }
        TableSegment result = left;
        return result;
    }

    private JoinTableSegment visitJoinedTable(OracleStatementParser.SelectJoinOptionContext ctx, TableSegment tableSegment) {
        JoinTableSegment result = new JoinTableSegment();
        result.setLeft(tableSegment);
        result.setStartIndex(tableSegment.getStartIndex());
        result.setStopIndex(ctx.stop.getStopIndex());
        if (null != ctx.innerCrossJoinClause()) {
            TableSegment right = (TableSegment)this.visit((ParseTree)ctx.innerCrossJoinClause().selectTableReference());
            result.setRight(right);
            if (null != ctx.innerCrossJoinClause().selectJoinSpecification()) {
                result = this.visitSelectJoinSpecification(ctx.innerCrossJoinClause().selectJoinSpecification(), result);
            }
        } else if (null != ctx.outerJoinClause()) {
            TableSegment right = (TableSegment)this.visit((ParseTree)ctx.outerJoinClause().selectTableReference());
            result.setRight(right);
            if (null != ctx.outerJoinClause().selectJoinSpecification()) {
                result = this.visitSelectJoinSpecification(ctx.outerJoinClause().selectJoinSpecification(), result);
            }
        } else {
            TableSegment right = (TableSegment)this.visit((ParseTree)ctx.crossOuterApplyClause());
            result.setRight(right);
        }
        return result;
    }

    private JoinTableSegment visitSelectJoinSpecification(OracleStatementParser.SelectJoinSpecificationContext ctx, JoinTableSegment joinTableSource) {
        if (null != ctx.expr()) {
            ExpressionSegment condition = (ExpressionSegment)this.visit((ParseTree)ctx.expr());
            joinTableSource.setCondition(condition);
        }
        if (null != ctx.USING()) {
            joinTableSource.setUsing(ctx.columnNames().columnName().stream().map(each -> (ColumnSegment)this.visit((ParseTree)each)).collect(Collectors.toList()));
        }
        return joinTableSource;
    }

    @Override
    public ASTNode visitCrossOuterApplyClause(OracleStatementParser.CrossOuterApplyClauseContext ctx) {
        TableSegment result;
        if (null != ctx.selectTableReference()) {
            result = (TableSegment)this.visit((ParseTree)ctx.selectTableReference());
        } else {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.collectionExpr());
            result = new SubqueryTableSegment(subquerySegment);
        }
        return result;
    }

    @Override
    public ASTNode visitCollectionExpr(OracleStatementParser.CollectionExprContext ctx) {
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.selectSubquery());
        return new SubquerySegment(ctx.selectSubquery().start.getStartIndex(), ctx.selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
    }

    @Override
    public ASTNode visitSelectTableReference(OracleStatementParser.SelectTableReferenceContext ctx) {
        TableSegment result = null != ctx.containersClause() ? (TableSegment)this.visit((ParseTree)ctx.containersClause()) : (null != ctx.shardsClause() ? (TableSegment)this.visit((ParseTree)ctx.shardsClause()) : (TableSegment)this.visit((ParseTree)ctx.queryTableExprClause()));
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitContainersClause(OracleStatementParser.ContainersClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitShardsClause(OracleStatementParser.ShardsClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.tableName());
    }

    @Override
    public ASTNode visitQueryTableExprClause(OracleStatementParser.QueryTableExprClauseContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.queryTableExpr());
    }

    @Override
    public ASTNode visitQueryTableExpr(OracleStatementParser.QueryTableExprContext ctx) {
        SimpleTableSegment result;
        if (null != ctx.queryTableExprSampleClause()) {
            result = (SimpleTableSegment)this.visit((ParseTree)ctx.queryTableExprSampleClause().queryTableExprTableClause().tableName());
        } else if (null != ctx.lateralClause()) {
            OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.lateralClause().selectSubquery());
            SubquerySegment subquerySegment = new SubquerySegment(ctx.lateralClause().selectSubquery().start.getStartIndex(), ctx.lateralClause().selectSubquery().stop.getStopIndex(), (SelectStatement)subquery);
            result = new SubqueryTableSegment(subquerySegment);
        } else {
            SubquerySegment subquerySegment = (SubquerySegment)this.visit((ParseTree)ctx.tableCollectionExpr());
            result = new SubqueryTableSegment(subquerySegment);
        }
        return result;
    }

    @Override
    public ASTNode visitWhereClause(OracleStatementParser.WhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }

    @Override
    public ASTNode visitGroupByClause(OracleStatementParser.GroupByClauseContext ctx) {
        LinkedList<OrderByItemSegment> items = new LinkedList<OrderByItemSegment>();
        for (OracleStatementParser.GroupByItemContext each : ctx.groupByItem()) {
            items.addAll(this.generateOrderByItemsFromGroupByItem(each));
        }
        return new GroupBySegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), items);
    }

    private Collection<OrderByItemSegment> generateOrderByItemsFromGroupByItem(OracleStatementParser.GroupByItemContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.expr()) {
            OrderByItemSegment item = (OrderByItemSegment)this.extractValueFromGroupByItemExpression(ctx.expr());
            result.add(item);
        } else if (null != ctx.rollupCubeClause()) {
            result.addAll(this.generateOrderByItemSegmentsFromRollupCubeClause(ctx.rollupCubeClause()));
        } else {
            result.addAll(this.generateOrderByItemSegmentsFromGroupingSetsClause(ctx.groupingSetsClause()));
        }
        return result;
    }

    private ASTNode extractValueFromGroupByItemExpression(OracleStatementParser.ExprContext ctx) {
        ASTNode expression = (ASTNode)this.visit((ParseTree)ctx);
        if (expression instanceof ColumnSegment) {
            ColumnSegment column = (ColumnSegment)expression;
            return new ColumnOrderByItemSegment(column, OrderDirection.ASC);
        }
        if (expression instanceof LiteralExpressionSegment) {
            LiteralExpressionSegment literalExpression = (LiteralExpressionSegment)expression;
            return new IndexOrderByItemSegment(literalExpression.getStartIndex(), literalExpression.getStopIndex(), SQLUtil.getExactlyNumber((String)literalExpression.getLiterals().toString(), (int)10).intValue(), OrderDirection.ASC);
        }
        return new ExpressionOrderByItemSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), this.getOriginalText(ctx), OrderDirection.ASC, (ExpressionSegment)expression);
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromRollupCubeClause(OracleStatementParser.RollupCubeClauseContext ctx) {
        return new LinkedList<OrderByItemSegment>(this.generateOrderByItemSegmentsFromGroupingExprList(ctx.groupingExprList()));
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromGroupingSetsClause(OracleStatementParser.GroupingSetsClauseContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.rollupCubeClause()) {
            for (OracleStatementParser.RollupCubeClauseContext rollupCubeClauseContext : ctx.rollupCubeClause()) {
                result.addAll(this.generateOrderByItemSegmentsFromRollupCubeClause(rollupCubeClauseContext));
            }
        }
        if (null != ctx.groupingExprList()) {
            for (OracleStatementParser.GroupingExprListContext groupingExprListContext : ctx.groupingExprList()) {
                result.addAll(this.generateOrderByItemSegmentsFromGroupingExprList(groupingExprListContext));
            }
        }
        return result;
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromGroupingExprList(OracleStatementParser.GroupingExprListContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        for (OracleStatementParser.ExpressionListContext each : ctx.expressionList()) {
            result.addAll(this.generateOrderByItemSegmentsFromExpressionList(each));
        }
        return result;
    }

    private Collection<OrderByItemSegment> generateOrderByItemSegmentsFromExpressionList(OracleStatementParser.ExpressionListContext ctx) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        if (null != ctx.expr()) {
            for (OracleStatementParser.ExprContext each : ctx.expr()) {
                result.add((OrderByItemSegment)this.extractValueFromGroupByItemExpression(each));
            }
        }
        if (null != ctx.exprs()) {
            for (OracleStatementParser.ExprContext each : ctx.exprs().expr()) {
                result.add((OrderByItemSegment)this.extractValueFromGroupByItemExpression(each));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitSubquery(OracleStatementParser.SubqueryContext ctx) {
        return (ASTNode)this.visit((ParseTree)ctx.selectSubquery());
    }

    @Override
    public ASTNode visitForUpdateClause(OracleStatementParser.ForUpdateClauseContext ctx) {
        LockSegment result = new LockSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex());
        if (null != ctx.forUpdateClauseList()) {
            result.getTables().addAll(this.generateTablesFromforUpdateClauseOption(ctx.forUpdateClauseList()));
            result.getColumns().addAll(this.generateColumnsFromforUpdateClauseOption(ctx.forUpdateClauseList()));
        }
        return result;
    }

    private List<SimpleTableSegment> generateTablesFromforUpdateClauseOption(OracleStatementParser.ForUpdateClauseListContext ctx) {
        LinkedList<SimpleTableSegment> result = new LinkedList<SimpleTableSegment>();
        for (OracleStatementParser.ForUpdateClauseOptionContext each : ctx.forUpdateClauseOption()) {
            if (null == each.tableName()) continue;
            result.add((SimpleTableSegment)this.visit((ParseTree)each.tableName()));
        }
        return result;
    }

    private List<ColumnSegment> generateColumnsFromforUpdateClauseOption(OracleStatementParser.ForUpdateClauseListContext ctx) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (OracleStatementParser.ForUpdateClauseOptionContext each : ctx.forUpdateClauseOption()) {
            if (null == each.columnName()) continue;
            result.add((ColumnSegment)this.visit((ParseTree)each.columnName()));
        }
        return result;
    }

    @Override
    public ASTNode visitMerge(OracleStatementParser.MergeContext ctx) {
        OracleMergeStatement result = new OracleMergeStatement();
        result.setTarget((TableSegment)((SimpleTableSegment)this.visit((ParseTree)ctx.intoClause())));
        result.setSource((TableSegment)this.visit((ParseTree)ctx.usingClause()));
        result.setExpr((ExpressionSegment)this.visit((ParseTree)ctx.usingClause().expr()));
        if (null != ctx.mergeUpdateClause()) {
            result.getUpdate().setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.mergeUpdateClause().mergeSetAssignmentsClause()));
            if (null != ctx.mergeUpdateClause().whereClause()) {
                result.getUpdate().setWhere((WhereSegment)this.visit((ParseTree)ctx.mergeUpdateClause().whereClause()));
            }
            if (null != ctx.mergeUpdateClause().deleteWhereClause()) {
                result.getDelete().setWhere((WhereSegment)this.visit((ParseTree)ctx.mergeUpdateClause().deleteWhereClause()));
            }
        }
        return result;
    }

    @Override
    public ASTNode visitIntoClause(OracleStatementParser.IntoClauseContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.viewName());
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitUsingClause(OracleStatementParser.UsingClauseContext ctx) {
        if (null != ctx.tableName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.tableName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        if (null != ctx.viewName()) {
            SimpleTableSegment result = (SimpleTableSegment)this.visit((ParseTree)ctx.viewName());
            if (null != ctx.alias()) {
                result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
            }
            return result;
        }
        OracleSelectStatement subquery = (OracleSelectStatement)this.visit((ParseTree)ctx.subquery());
        SubquerySegment subquerySegment = new SubquerySegment(ctx.subquery().start.getStartIndex(), ctx.subquery().stop.getStopIndex(), (SelectStatement)subquery);
        SubqueryTableSegment result = new SubqueryTableSegment(subquerySegment);
        if (null != ctx.alias()) {
            result.setAlias((AliasSegment)this.visit((ParseTree)ctx.alias()));
        }
        return result;
    }

    @Override
    public ASTNode visitMergeUpdateClause(OracleStatementParser.MergeUpdateClauseContext ctx) {
        OracleMergeStatement result = new OracleMergeStatement();
        result.getUpdate().setSetAssignment((SetAssignmentSegment)this.visit((ParseTree)ctx.mergeSetAssignmentsClause()));
        if (null != ctx.whereClause()) {
            result.getUpdate().setWhere((WhereSegment)this.visit((ParseTree)ctx.whereClause()));
        }
        if (null != ctx.deleteWhereClause()) {
            result.getDelete().setWhere((WhereSegment)this.visit((ParseTree)ctx.deleteWhereClause()));
        }
        return result;
    }

    @Override
    public ASTNode visitMergeSetAssignmentsClause(OracleStatementParser.MergeSetAssignmentsClauseContext ctx) {
        LinkedList<AssignmentSegment> assignments = new LinkedList<AssignmentSegment>();
        for (OracleStatementParser.MergeAssignmentContext each : ctx.mergeAssignment()) {
            assignments.add((AssignmentSegment)this.visit((ParseTree)each));
        }
        return new SetAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), assignments);
    }

    @Override
    public ASTNode visitMergeAssignment(OracleStatementParser.MergeAssignmentContext ctx) {
        ColumnSegment column = (ColumnSegment)this.visitColumnName(ctx.columnName());
        ExpressionSegment value = (ExpressionSegment)this.visit((ParseTree)ctx.mergeAssignmentValue());
        LinkedList<ColumnSegment> columnSegments = new LinkedList<ColumnSegment>();
        columnSegments.add(column);
        return new ColumnAssignmentSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), columnSegments, value);
    }

    @Override
    public ASTNode visitMergeAssignmentValue(OracleStatementParser.MergeAssignmentValueContext ctx) {
        OracleStatementParser.ExprContext expr = ctx.expr();
        return null == expr ? new CommonExpressionSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), ctx.getText()) : (ASTNode)this.visit((ParseTree)expr);
    }

    @Override
    public ASTNode visitDeleteWhereClause(OracleStatementParser.DeleteWhereClauseContext ctx) {
        ASTNode segment = (ASTNode)this.visit((ParseTree)ctx.whereClause().expr());
        return new WhereSegment(ctx.getStart().getStartIndex(), ctx.getStop().getStopIndex(), (ExpressionSegment)segment);
    }

    @Generated
    public OracleDMLStatementSQLVisitor() {
    }
}

