/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl;

import java.util.LinkedList;
import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.visitor.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.operation.SQLStatementVisitor;
import org.apache.shardingsphere.sql.parser.api.visitor.type.DMLSQLVisitor;
import org.apache.shardingsphere.sql.parser.autogen.PostgreSQLStatementParser;
import org.apache.shardingsphere.sql.parser.postgresql.visitor.statement.impl.PostgreSQLStatementSQLVisitor;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.complex.CommonExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLCallStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLCheckpointStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLCopyStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLDoStatement;

public final class PostgreSQLDMLStatementSQLVisitor
extends PostgreSQLStatementSQLVisitor
implements DMLSQLVisitor,
SQLStatementVisitor {
    public PostgreSQLDMLStatementSQLVisitor(Properties props) {
        super(props);
    }

    @Override
    public ASTNode visitCall(PostgreSQLStatementParser.CallContext ctx) {
        PostgreSQLCallStatement result = new PostgreSQLCallStatement();
        result.setProcedureName(((IdentifierValue)this.visit((ParseTree)ctx.identifier())).getValue());
        if (null != ctx.callArguments()) {
            LinkedList<ExpressionSegment> parameters = new LinkedList<ExpressionSegment>();
            for (PostgreSQLStatementParser.CallArgumentContext each : ctx.callArguments().callArgument()) {
                parameters.add((ExpressionSegment)this.visit((ParseTree)each));
            }
            result.getParameters().addAll(parameters);
        }
        return result;
    }

    @Override
    public ASTNode visitCallArgument(PostgreSQLStatementParser.CallArgumentContext ctx) {
        if (null != ctx.positionalNotation()) {
            return (ASTNode)this.visit((ParseTree)ctx.positionalNotation().aExpr());
        }
        String text = ctx.namedNotation().start.getInputStream().getText(new Interval(ctx.namedNotation().start.getStartIndex(), ctx.namedNotation().stop.getStopIndex()));
        return new CommonExpressionSegment(ctx.namedNotation().getStart().getStartIndex(), ctx.namedNotation().getStop().getStopIndex(), text);
    }

    @Override
    public ASTNode visitDoStatement(PostgreSQLStatementParser.DoStatementContext ctx) {
        return new PostgreSQLDoStatement();
    }

    @Override
    public ASTNode visitCopy(PostgreSQLStatementParser.CopyContext ctx) {
        PostgreSQLCopyStatement result = new PostgreSQLCopyStatement();
        if (null != ctx.qualifiedName()) {
            result.setTableSegment((SimpleTableSegment)this.visit((ParseTree)ctx.qualifiedName()));
        }
        return result;
    }

    @Override
    public ASTNode visitCheckpoint(PostgreSQLStatementParser.CheckpointContext ctx) {
        return new PostgreSQLCheckpointStatement();
    }

    @Generated
    public PostgreSQLDMLStatementSQLVisitor() {
    }
}

