/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, element) - Returns the (1-based) index of the first element of the array as long.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(3, 2, 1), 1);\n       3\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011!I\u0005\u0001#b\u0001\n\u0013Q\u0005\"\u00020\u0001\t\u0003z\u0006\"\u00024\u0001\t\u0003:\u0007\"\u00028\u0001\t\u0003z\u0007\"\u0002<\u0001\t\u0003:\b\"\u0002?\u0001\t\u0003j\bbBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[A\u0011\"a\r\u0001#\u0003%\t!!\u000e\t\u0013\u0005-\u0003!%A\u0005\u0002\u0005U\u0002\"CA'\u0001\u0005\u0005I\u0011IA(\u0011%\ty\u0006AA\u0001\n\u0003\t\t\u0007C\u0005\u0002j\u0001\t\t\u0011\"\u0001\u0002l!I\u0011\u0011\u000f\u0001\u0002\u0002\u0013\u0005\u00131\u000f\u0005\n\u0003\u0003\u0003\u0011\u0011!C\u0001\u0003\u0007C\u0011\"!$\u0001\u0003\u0003%\t%a$\b\u0013\u0005Mf$!A\t\u0002\u0005Uf\u0001C\u000f\u001f\u0003\u0003E\t!a.\t\r\u0011;B\u0011AAc\u0011%\t9mFA\u0001\n\u000b\nI\rC\u0005\u0002L^\t\t\u0011\"!\u0002N\"I\u00111[\f\u0002\u0002\u0013\u0005\u0015Q\u001b\u0005\n\u0003O<\u0012\u0011!C\u0005\u0003S\u0014Q\"\u0011:sCf\u0004vn]5uS>t'BA\u0010!\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0005\u0012\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\r\"\u0013aA:rY*\u0011QEJ\u0001\u0006gB\f'o\u001b\u0006\u0003O!\na!\u00199bG\",'\"A\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001a\u0003gM\u001d\u0011\u00055rS\"\u0001\u0010\n\u0005=r\"\u0001\u0005\"j]\u0006\u0014\u00180\u0012=qe\u0016\u001c8/[8o!\ti\u0013'\u0003\u00023=\t1\u0012*\u001c9mS\u000eLGoQ1ti&s\u0007/\u001e;UsB,7\u000f\u0005\u00025o5\tQGC\u00017\u0003\u0015\u00198-\u00197b\u0013\tATGA\u0004Qe>$Wo\u0019;\u0011\u0005QR\u0014BA\u001e6\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0011aWM\u001a;\u0016\u0003y\u0002\"!L \n\u0005\u0001s\"AC#yaJ,7o]5p]\u0006)A.\u001a4uA\u0005)!/[4ii\u00061!/[4ii\u0002\na\u0001P5oSRtDc\u0001$H\u0011B\u0011Q\u0006\u0001\u0005\u0006y\u0015\u0001\rA\u0010\u0005\u0006\u0005\u0016\u0001\rAP\u0001\t_J$WM]5oOV\t1\nE\u0002M)^s!!\u0014*\u000f\u00059\u000bV\"A(\u000b\u0005AS\u0013A\u0002\u001fs_>$h(C\u00017\u0013\t\u0019V'A\u0004qC\u000e\\\u0017mZ3\n\u0005U3&\u0001C(sI\u0016\u0014\u0018N\\4\u000b\u0005M+\u0004C\u0001\u001bY\u0013\tIVGA\u0002B]fD#AB.\u0011\u0005Qb\u0016BA/6\u0005%!(/\u00198tS\u0016tG/\u0001\u0005eCR\fG+\u001f9f+\u0005\u0001\u0007CA1e\u001b\u0005\u0011'BA2#\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\u0005ECR\fG+\u001f9f\u0003)Ig\u000e];u)f\u0004Xm]\u000b\u0002QB\u0019A*[6\n\u0005)4&aA*fcB\u0011\u0011\r\\\u0005\u0003[\n\u0014\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002'\rDWmY6J]B,H\u000fR1uCRK\b/Z:\u0015\u0003A\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u0011\u0002\u0011\u0005t\u0017\r\\=tSNL!!\u001e:\u0003\u001fQK\b/Z\"iK\u000e\\'+Z:vYR\fAB\\;mYN\u000bg-Z#wC2$2a\u0016={\u0011\u0015I(\u00021\u0001X\u0003\r\t'O\u001d\u0005\u0006w*\u0001\raV\u0001\u0006m\u0006dW/Z\u0001\u000baJ,G\u000f^=OC6,W#\u0001@\u0011\u0007}\f9A\u0004\u0003\u0002\u0002\u0005\r\u0001C\u0001(6\u0013\r\t)!N\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00111\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015Q'A\u0005e_\u001e+gnQ8eKR1\u0011\u0011CA\u000f\u0003O\u0001B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/q\u0012aB2pI\u0016<WM\\\u0005\u0005\u00037\t)B\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\ty\u0002\u0004a\u0001\u0003C\t1a\u0019;y!\u0011\t\u0019\"a\t\n\t\u0005\u0015\u0012Q\u0003\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\tI\u0003\u0004a\u0001\u0003#\t!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0006\r\u0006=\u0012\u0011\u0007\u0005\by5\u0001\n\u00111\u0001?\u0011\u001d\u0011U\u0002%AA\u0002y\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00028)\u001aa(!\u000f,\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00126\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0013\nyDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003#\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0003mC:<'BAA.\u0003\u0011Q\u0017M^1\n\t\u0005%\u0011QK\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003G\u00022\u0001NA3\u0013\r\t9'\u000e\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004/\u00065\u0004\"CA8%\u0005\u0005\t\u0019AA2\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u000f\t\u0006\u0003o\nihV\u0007\u0003\u0003sR1!a\u001f6\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u007f\nIH\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAC\u0003\u0017\u00032\u0001NAD\u0013\r\tI)\u000e\u0002\b\u0005>|G.Z1o\u0011!\ty\u0007FA\u0001\u0002\u00049\u0016AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0006\u0006E\u0005\u0002CA8+\u0005\u0005\t\u0019A,)'\u0001\t)*a'\u0002\u001e\u0006\u0005\u00161UAT\u0003S\u000bi+a,\u0011\u00075\n9*C\u0002\u0002\u001az\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002 \u00069'\u0002\t\u0011!A}3UKT\"`Q\u0005\u0014(/Y=-A\u0015dW-\\3oi&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0003&M\u0017cCN,G-\u000b\u0011j]\u0012,\u0007\u0010I8gAQDW\r\t4jeN$\b%\u001a7f[\u0016tG\u000fI8gAQDW\rI1se\u0006L\b%Y:!Y>twM\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002&\u0006!%\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK1se\u0006L\bf\r\u0017!e1\u0002\u0013'\u000b\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\r\u0006!A\u0005)qM]8va\u0006\u0012\u00111V\u0001\fCJ\u0014\u0018-_0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u00022\u0006)!G\f\u001b/a\u0005i\u0011I\u001d:bsB{7/\u001b;j_:\u0004\"!L\f\u0014\t]\tI,\u000f\t\b\u0003w\u000b\tM\u0010 G\u001b\t\tiLC\u0002\u0002@V\nqA];oi&lW-\u0003\u0003\u0002D\u0006u&!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011\u0011QW\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011K\u0001\u0006CB\u0004H.\u001f\u000b\u0006\r\u0006=\u0017\u0011\u001b\u0005\u0006yi\u0001\rA\u0010\u0005\u0006\u0005j\u0001\rAP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9.a9\u0011\u000bQ\nI.!8\n\u0007\u0005mWG\u0001\u0004PaRLwN\u001c\t\u0006i\u0005}gHP\u0005\u0004\u0003C,$A\u0002+va2,'\u0007\u0003\u0005\u0002fn\t\t\u00111\u0001G\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002lB!\u00111KAw\u0013\u0011\ty/!\u0016\u0003\r=\u0013'.Z2u\u0001")
public class ArrayPosition
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPosition arrayPosition) {
        return ArrayPosition$.MODULE$.unapply(arrayPosition);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPosition> tupled() {
        return ArrayPosition$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPosition>> curried() {
        return ArrayPosition$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayPosition arrayPosition = this;
        synchronized (arrayPosition) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object object;
        Object object2 = new Object();
        try {
            ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayPosition.$anonfun$nullSafeEval$4(this, value, object2, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            object = BoxesRunTime.boxToLong((long)0L);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public String prettyName() {
        return "array_position";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String pos = ctx.freshName("arrayPosition");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.right().dataType(), i);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |int ").append(pos).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(ctx.genEqual(this.right().dataType(), (String)value, getValue)).append(") {\n         |    ").append(pos).append(" = ").append(i).append(" + 1;\n         |    break;\n         |  }\n         |}\n         |").append(ev.value()).append(" = (long) ").append(pos).append(";\n       ").toString())).stripMargin();
        });
    }

    public ArrayPosition copy(Expression left, Expression right) {
        return new ArrayPosition(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPosition";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPosition)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPosition arrayPosition = (ArrayPosition)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPosition.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPosition.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPosition.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$4(ArrayPosition $this, Object value$2, Object nonLocalReturnKey4$1, int i, Object v) {
        if (v != null && $this.ordering().equiv(v, value$2)) {
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey4$1, (long)(i + 1));
        }
    }

    public ArrayPosition(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

