/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Converts `expr` to hexadecimal.", examples="\n    Examples:\n      > SELECT _FUNC_(17);\n       11\n      > SELECT _FUNC_('Spark SQL');\n       537061726B2053514C\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055w!B\u000f\u001f\u0011\u0003Yc!B\u0017\u001f\u0011\u0003q\u0003\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%\ta\u000f\u0005\u0007\u0005\u0006\u0001\u000b\u0011\u0002\u001f\t\u000f\r\u000b!\u0019!C\u0001w!1A)\u0001Q\u0001\nqBQ!R\u0001\u0005\u0002\u0019CQ!R\u0001\u0005\u0002ECQaV\u0001\u0005\u0002aCqAW\u0001\u0002\u0002\u0013\u00055\fC\u0005\u00026\u0006\t\t\u0011\"!\u00028\"I\u00111Y\u0001\u0002\u0002\u0013%\u0011Q\u0019\u0004\u0005[y\u0001U\f\u0003\u0005h\u001b\tU\r\u0011\"\u0001i\u0011!aWB!E!\u0002\u0013I\u0007\"\u0002\u001d\u000e\t\u0003i\u0007\"B8\u000e\t\u0003\u0002\bbBA\u0003\u001b\u0011\u0005\u0013q\u0001\u0005\b\u0003\u001fiA\u0011KA\t\u0011\u001d\tY\"\u0004C)\u0003;A\u0011\"!\u000f\u000e\u0003\u0003%\t!a\u000f\t\u0013\u0005}R\"%A\u0005\u0002\u0005\u0005\u0003\"CA,\u001b\u0005\u0005I\u0011IA-\u0011%\tY'DA\u0001\n\u0003\ti\u0007C\u0005\u0002v5\t\t\u0011\"\u0001\u0002x!I\u0011QP\u0007\u0002\u0002\u0013\u0005\u0013q\u0010\u0005\n\u0003\u001bk\u0011\u0011!C\u0001\u0003\u001fC\u0011\"!'\u000e\u0003\u0003%\t%a'\u0002\u0007!+\u0007P\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001!\ta\u0013!D\u0001\u001f\u0005\rAU\r_\n\u0004\u0003=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00021m%\u0011q'\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\n\u0011\u0002[3y\t&<\u0017\u000e^:\u0016\u0003q\u00022\u0001M\u001f@\u0013\tq\u0014GA\u0003BeJ\f\u0017\u0010\u0005\u00021\u0001&\u0011\u0011)\r\u0002\u0005\u0005f$X-\u0001\u0006iKb$\u0015nZ5ug\u0002\n1\"\u001e8iKb$\u0015nZ5ug\u0006aQO\u001c5fq\u0012Kw-\u001b;tA\u0005\u0019\u0001.\u001a=\u0015\u0005\u001d{\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0015!\u0018\u0010]3t\u0015\taE%\u0001\u0004v]N\fg-Z\u0005\u0003\u001d&\u0013!\"\u0016+GqM#(/\u001b8h\u0011\u0015\u0001v\u00011\u0001=\u0003\u0015\u0011\u0017\u0010^3t)\t9%\u000bC\u0003T\u0011\u0001\u0007A+A\u0002ok6\u0004\"\u0001M+\n\u0005Y\u000b$\u0001\u0002'p]\u001e\fQ!\u001e8iKb$\"\u0001P-\t\u000bAK\u0001\u0019\u0001\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007q\u000b\u0019\f\u0005\u0002-\u001bM)QBX1ekA\u0011AfX\u0005\u0003Az\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003Y\tL!a\u0019\u0010\u0003-%k\u0007\u000f\\5dSR\u001c\u0015m\u001d;J]B,H\u000fV=qKN\u0004\"\u0001M3\n\u0005\u0019\f$a\u0002)s_\u0012,8\r^\u0001\u0006G\"LG\u000eZ\u000b\u0002SB\u0011AF[\u0005\u0003Wz\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eAQ\u0011AL\u001c\u0005\u0006OB\u0001\r![\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cX#A9\u0011\u0007ITXP\u0004\u0002tq:\u0011Ao^\u0007\u0002k*\u0011aOK\u0001\u0007yI|w\u000e\u001e \n\u0003IJ!!_\u0019\u0002\u000fA\f7m[1hK&\u00111\u0010 \u0002\u0004'\u0016\f(BA=2!\rq\u0018\u0011A\u0007\u0002\u007f*\u0011!JI\u0005\u0004\u0003\u0007y(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0003!!\u0017\r^1UsB,WCAA\u0005!\rq\u00181B\u0005\u0004\u0003\u001by(\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\t\u0005M\u0011\u0011\u0004\t\u0004a\u0005U\u0011bAA\fc\t\u0019\u0011I\\=\t\rM\u001b\u0002\u0019AA\n\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002 \u0005-\u0012Q\u0007\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0010\u0002\u000f\r|G-Z4f]&!\u0011\u0011FA\u0012\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0017)\u0001\u0007\u0011qF\u0001\u0004GRD\b\u0003BA\u0011\u0003cIA!a\r\u0002$\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u001c)\u0001\u0007\u0011qD\u0001\u0003KZ\fAaY8qsR\u0019A,!\u0010\t\u000f\u001d,\u0002\u0013!a\u0001S\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\"U\rI\u0017QI\u0016\u0003\u0003\u000f\u0002B!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011K\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002V\u0005-#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005!A.\u00198h\u0015\t\t)'\u0001\u0003kCZ\f\u0017\u0002BA5\u0003?\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA8!\r\u0001\u0014\u0011O\u0005\u0004\u0003g\n$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\n\u0003sB\u0011\"a\u001f\u001a\u0003\u0003\u0005\r!a\u001c\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\t\u0005\u0004\u0002\u0004\u0006%\u00151C\u0007\u0003\u0003\u000bS1!a\"2\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\u000b)I\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAI\u0003/\u00032\u0001MAJ\u0013\r\t)*\r\u0002\b\u0005>|G.Z1o\u0011%\tYhGA\u0001\u0002\u0004\t\u0019\"\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\u000bi\nC\u0005\u0002|q\t\t\u00111\u0001\u0002\u0014!ZQ\"!)\u0002(\u0006%\u0016QVAX!\ra\u00131U\u0005\u0004\u0003Ks\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003W\u000baf\u0018$V\u001d\u000e{\u0006&\u001a=qe&\u0002S\u0006I\"p]Z,'\u000f^:!A\u0016D\bO\u001d1!i>\u0004\u0003.\u001a=bI\u0016\u001c\u0017.\\1m]\u0005AQ\r_1na2,7/\t\u0002\u00022\u0006!(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK\u00198SmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013'\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!kM:\u0004GN\u00198eY\u0012%\u0007M\u001b4kE\"4I\u0003\u0011!\u0011\u00159'\u00021\u0001j\u0003\u001d)h.\u00199qYf$B!!/\u0002@B!\u0001'a/j\u0013\r\ti,\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\u00057\"!AA\u0002q\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u001d\u0007\u0003BA/\u0003\u0013LA!a3\u0002`\t1qJ\u00196fGR\u0004")
public class Hex
extends UnaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Hex hex) {
        return Hex$.MODULE$.unapply(hex);
    }

    public static byte[] unhex(byte[] byArray) {
        return Hex$.MODULE$.unhex(byArray);
    }

    public static UTF8String hex(long l) {
        return Hex$.MODULE$.hex(l);
    }

    public static UTF8String hex(byte[] byArray) {
        return Hex$.MODULE$.hex(byArray);
    }

    public static byte[] unhexDigits() {
        return Hex$.MODULE$.unhexDigits();
    }

    public static byte[] hexDigits() {
        return Hex$.MODULE$.hexDigits();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, BinaryType$.MODULE$, StringType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object num) {
        UTF8String uTF8String;
        DataType dataType = this.child().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex(BoxesRunTime.unboxToLong((Object)num));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex((byte[])num);
        } else if (StringType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex(((UTF8String)num).getBytes());
        } else {
            throw new MatchError((Object)dataType);
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String hex = new StringOps(Predef$.MODULE$.augmentString(Hex$.MODULE$.getClass().getName())).stripSuffix("$");
            DataType dataType = this.child().dataType();
            String string = StringType$.MODULE$.equals(dataType) ? new StringBuilder(18).append(hex).append(".hex(").append((String)c).append(".getBytes());").toString() : new StringBuilder(7).append(hex).append(".hex(").append((String)c).append(");").toString();
            return new StringBuilder(3).append(ev.value()).append(" = ").append((Object)string).toString();
        });
    }

    public Hex copy(Expression child) {
        return new Hex(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Hex";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hex hex = (Hex)x$1;
        Expression expression = this.child();
        Expression expression2 = hex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hex.canEqual(this)) return false;
        return true;
    }

    public Hex(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

