/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Generator;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.JsonTuple$;
import org.apache.spark.sql.catalyst.expressions.SharedFactory$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(jsonStr, p1, p2, ..., pn) - Returns a tuple like the function get_json_object, but it takes multiple names. All the input parameters and output column types are string.", examples="\n    Examples:\n      > SELECT _FUNC_('{\"a\":1, \"b\":2}', 'a', 'b');\n       1\t2\n  ", group="json_funcs")
@ScalaSignature(bytes="\u0006\u0001\tea\u0001B\u0010!\u00016B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t%\u0002\u0011\t\u0012)A\u0005\r\")1\u000b\u0001C\u0001)\")q\u000b\u0001C!1\"AA\f\u0001EC\u0002\u0013%Q\f\u0003\u0005h\u0001!\u0015\r\u0011\"\u0003i\u0011!Q\u0007\u0001#b\u0001\n\u0013)\u0005\u0002\u00037\u0001\u0011\u000b\u0007I\u0011B7\t\u0011u\u0004\u0001R1A\u0005\nyDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0018\u0001!\t%!\u0007\t\u000f\u0005m\u0001\u0001\"\u0011\u0002\u001e!9\u00111\u0006\u0001\u0005B\u00055\u0002bBA\u001d\u0001\u0011%\u00111\b\u0005\b\u00037\u0002A\u0011BA/\u0011%\t\t\bAA\u0001\n\u0003\t\u0019\bC\u0005\u0002x\u0001\t\n\u0011\"\u0001\u0002z!I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011\u0013\u0005\t\u0003C\u0003\u0011\u0011!C\u0001}\"I\u00111\u0015\u0001\u0002\u0002\u0013\u0005\u0011Q\u0015\u0005\n\u0003c\u0003\u0011\u0011!C!\u0003gC\u0011\"!1\u0001\u0003\u0003%\t!a1\t\u0013\u0005\u001d\u0007!!A\u0005B\u0005%w!CAtA\u0005\u0005\t\u0012AAu\r!y\u0002%!A\t\u0002\u0005-\bBB*\u001a\t\u0003\tI\u0010C\u0005\u0002|f\t\t\u0011\"\u0012\u0002~\"I\u0011q`\r\u0002\u0002\u0013\u0005%\u0011\u0001\u0005\n\u0005\u000bI\u0012\u0011!CA\u0005\u000fA\u0011Ba\u0004\u001a\u0003\u0003%IA!\u0005\u0003\u0013)\u001bxN\u001c+va2,'BA\u0011#\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\r\"\u0013\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001q#'N\u001eB!\ty\u0003'D\u0001!\u0013\t\t\u0004E\u0001\u0006FqB\u0014Xm]:j_:\u0004\"aL\u001a\n\u0005Q\u0002#!C$f]\u0016\u0014\u0018\r^8s!\t1\u0014(D\u00018\u0015\tA\u0004%A\u0004d_\u0012,w-\u001a8\n\u0005i:$aD\"pI\u0016<WM\u001c$bY2\u0014\u0017mY6\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011AHQ\u0005\u0003\u0007v\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0002\rB\u0019qi\u0014\u0018\u000f\u0005!keBA%M\u001b\u0005Q%BA&-\u0003\u0019a$o\\8u}%\ta(\u0003\u0002O{\u00059\u0001/Y2lC\u001e,\u0017B\u0001)R\u0005\r\u0019V-\u001d\u0006\u0003\u001dv\n\u0011b\u00195jY\u0012\u0014XM\u001c\u0011\u0002\rqJg.\u001b;?)\t)f\u000b\u0005\u00020\u0001!)Ai\u0001a\u0001\r\u0006Aa.\u001e7mC\ndW-F\u0001Z!\ta$,\u0003\u0002\\{\t9!i\\8mK\u0006t\u0017a\u00028vY2\u0014vn^\u000b\u0002=B\u0019qiT0\u0011\u0005\u0001\fW\"\u0001\u0012\n\u0005\t\u0014#aC%oi\u0016\u0014h.\u00197S_^D#!\u00023\u0011\u0005q*\u0017B\u00014>\u0005%!(/\u00198tS\u0016tG/\u0001\u0005kg>tW\t\u001f9s+\u0005q\u0003F\u0001\u0004e\u0003A1\u0017.\u001a7e\u000bb\u0004(/Z:tS>t7\u000f\u000b\u0002\bI\u0006\u0011bm\u001c7eC\ndWMR5fY\u0012t\u0015-\\3t+\u0005q\u0007cA$pc&\u0011\u0001/\u0015\u0002\u000b\u0013:$W\r_3e'\u0016\f\bc\u0001\u001fsi&\u00111/\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005ULhB\u0001<x!\tIU(\u0003\u0002y{\u00051\u0001K]3eK\u001aL!A_>\u0003\rM#(/\u001b8h\u0015\tAX\b\u000b\u0002\tI\u0006q1m\u001c8ti\u0006tGOR5fY\u0012\u001cX#A@\u0011\u0007q\n\t!C\u0002\u0002\u0004u\u00121!\u00138uQ\tIA-A\u0007fY\u0016lWM\u001c;TG\",W.Y\u000b\u0003\u0003\u0017\u0001B!!\u0004\u0002\u00145\u0011\u0011q\u0002\u0006\u0004\u0003#!\u0013!\u0002;za\u0016\u001c\u0018\u0002BA\u000b\u0003\u001f\u0011!b\u0015;sk\u000e$H+\u001f9f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0002i\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\u0011\u0011q\u0004\t\u0005\u0003C\t9#\u0004\u0002\u0002$)\u0019\u0011Q\u0005\u0012\u0002\u0011\u0005t\u0017\r\\=tSNLA!!\u000b\u0002$\tyA+\u001f9f\u0007\",7m\u001b*fgVdG/\u0001\u0003fm\u0006dG\u0003BA\u0018\u0003k\u0001BaRA\u0019?&\u0019\u00111G)\u0003\u001fQ\u0013\u0018M^3sg\u0006\u0014G.Z(oG\u0016D\u0001\"a\u000e\u000e!\u0003\u0005\raX\u0001\u0006S:\u0004X\u000f^\u0001\ta\u0006\u00148/\u001a*poR)a,!\u0010\u0002Z!9\u0011q\b\bA\u0002\u0005\u0005\u0013A\u00029beN,'\u000f\u0005\u0003\u0002D\u0005USBAA#\u0015\u0011\t9%!\u0013\u0002\t\r|'/\u001a\u0006\u0005\u0003\u0017\ni%A\u0004kC\u000e\\7o\u001c8\u000b\t\u0005=\u0013\u0011K\u0001\nM\u0006\u001cH/\u001a:y[2T!!a\u0015\u0002\u0007\r|W.\u0003\u0003\u0002X\u0005\u0015#A\u0003&t_:\u0004\u0016M]:fe\"1\u0011q\u0007\bA\u0002}\u000bAcY8qs\u000e+(O]3oiN#(/^2ukJ,GCBA0\u0003K\ny\u0007E\u0002=\u0003CJ1!a\u0019>\u0005\u0011)f.\u001b;\t\u000f\u0005\u001dt\u00021\u0001\u0002j\u0005Iq-\u001a8fe\u0006$xN\u001d\t\u0005\u0003\u0007\nY'\u0003\u0003\u0002n\u0005\u0015#!\u0004&t_:<UM\\3sCR|'\u000fC\u0004\u0002@=\u0001\r!!\u0011\u0002\t\r|\u0007/\u001f\u000b\u0004+\u0006U\u0004b\u0002#\u0011!\u0003\u0005\rAR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tYHK\u0002G\u0003{Z#!a \u0011\t\u0005\u0005\u00151R\u0007\u0003\u0003\u0007SA!!\"\u0002\b\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0013k\u0014AC1o]>$\u0018\r^5p]&!\u0011QRAB\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005M\u0005\u0003BAK\u0003?k!!a&\u000b\t\u0005e\u00151T\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001e\u0006!!.\u0019<b\u0013\rQ\u0018qS\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t9+!,\u0011\u0007q\nI+C\u0002\u0002,v\u00121!\u00118z\u0011!\ty\u000bFA\u0001\u0002\u0004y\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u00026B1\u0011qWA_\u0003Ok!!!/\u000b\u0007\u0005mV(\u0001\u0006d_2dWm\u0019;j_:LA!a0\u0002:\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\rI\u0016Q\u0019\u0005\n\u0003_3\u0012\u0011!a\u0001\u0003O\u000ba!Z9vC2\u001cHcA-\u0002L\"I\u0011qV\f\u0002\u0002\u0003\u0007\u0011q\u0015\u0015\u0010\u0001\u0005=\u0017Q[Al\u00037\fi.!9\u0002dB\u0019q&!5\n\u0007\u0005M\u0007EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005e\u0017!a\u0018`\rVs5i\u0018\u0015kg>t7\u000b\u001e:-AA\fD\u0006\t93Y\u0001rcF\f\u0017!a:L\u0003%\f\u0011SKR,(O\\:!C\u0002\"X\u000f\u001d7fA1L7.\u001a\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI4fi~S7o\u001c8`_\nTWm\u0019;-A\t,H\u000fI5uAQ\f7.Z:![VdG/\u001b9mK\u0002r\u0017-\\3t]\u0001\nE\u000e\u001c\u0011uQ\u0016\u0004\u0013N\u001c9vi\u0002\u0002\u0018M]1nKR,'o\u001d\u0011b]\u0012\u0004s.\u001e;qkR\u00043m\u001c7v[:\u0004C/\u001f9fg\u0002\n'/\u001a\u0011tiJLgn\u001a\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a8\u0002\u001f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u001f\u0012bEi\nD\u0006\t\u0012cEi\u0012Tp\n\u0017!O\u0005<C\u0006I\u0014cO%Z$\u0002\t\u0011!A\u0001\u0002\u0003%M\u00053\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAAs\u0003)Q7o\u001c8`MVt7m]\u0001\n\u0015N|g\u000eV;qY\u0016\u0004\"aL\r\u0014\te\ti/\u0011\t\u0007\u0003_\f)PR+\u000e\u0005\u0005E(bAAz{\u00059!/\u001e8uS6,\u0017\u0002BA|\u0003c\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\tI/\u0001\u0005u_N#(/\u001b8h)\t\t\u0019*A\u0003baBd\u0017\u0010F\u0002V\u0005\u0007AQ\u0001\u0012\u000fA\u0002\u0019\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003\n\t-\u0001c\u0001\u001fs\r\"A!QB\u000f\u0002\u0002\u0003\u0007Q+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0003\t\u0005\u0003+\u0013)\"\u0003\u0003\u0003\u0018\u0005]%AB(cU\u0016\u001cG\u000f")
public class JsonTuple
extends Expression
implements Generator,
CodegenFallback,
scala.Serializable {
    private transient Seq<InternalRow> nullRow;
    private transient Expression jsonExpr;
    private transient Seq<Expression> fieldExpressions;
    private transient IndexedSeq<Option<String>> foldableFieldNames;
    private transient int constantFields;
    private final Seq<Expression> children;
    private volatile transient byte bitmap$trans$0;

    public static Option<Seq<Expression>> unapply(JsonTuple jsonTuple) {
        return JsonTuple$.MODULE$.unapply(jsonTuple);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<JsonTuple, A> function1) {
        return JsonTuple$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, JsonTuple> compose(Function1<A, Seq<Expression>> function1) {
        return JsonTuple$.MODULE$.compose(function1);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public DataType dataType() {
        return Generator.dataType$(this);
    }

    @Override
    public boolean foldable() {
        return Generator.foldable$(this);
    }

    @Override
    public TraversableOnce<InternalRow> terminate() {
        return Generator.terminate$(this);
    }

    @Override
    public boolean supportCodegen() {
        return Generator.supportCodegen$(this);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private Seq<InternalRow> nullRow$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                GenericInternalRow genericInternalRow = new GenericInternalRow((Object[])Array$.MODULE$.ofDim(this.fieldExpressions().length(), ClassTag$.MODULE$.Any()));
                this.nullRow = Nil$.MODULE$.$colon$colon((Object)genericInternalRow);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.nullRow;
    }

    private Seq<InternalRow> nullRow() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.nullRow$lzycompute() : this.nullRow;
    }

    private Expression jsonExpr$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.jsonExpr = (Expression)this.children().head();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.jsonExpr;
    }

    private Expression jsonExpr() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.jsonExpr$lzycompute() : this.jsonExpr;
    }

    private Seq<Expression> fieldExpressions$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.fieldExpressions = (Seq)this.children().tail();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.fieldExpressions;
    }

    private Seq<Expression> fieldExpressions() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.fieldExpressions$lzycompute() : this.fieldExpressions;
    }

    private IndexedSeq<Option<String>> foldableFieldNames$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.foldableFieldNames = ((TraversableOnce)this.fieldExpressions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Expression expression = x0$1;
                    Option option = expression.foldable() ? Option$.MODULE$.apply(expression.eval(expression.eval$default$1())).map((Function1 & Serializable & scala.Serializable)x$6 -> ((UTF8String)x$6).toString()) : null;
                    return option;
                }, Seq$.MODULE$.canBuildFrom())).toIndexedSeq();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.foldableFieldNames;
    }

    private IndexedSeq<Option<String>> foldableFieldNames() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.foldableFieldNames$lzycompute() : this.foldableFieldNames;
    }

    private int constantFields$lzycompute() {
        JsonTuple jsonTuple = this;
        synchronized (jsonTuple) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.constantFields = this.foldableFieldNames().count((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)JsonTuple.$anonfun$constantFields$1(x$7)));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.constantFields;
    }

    private int constantFields() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.constantFields$lzycompute() : this.constantFields;
    }

    @Override
    public StructType elementSchema() {
        return StructType$.MODULE$.apply((Seq<StructField>)((Seq)((TraversableLike)this.fieldExpressions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int idx = tuple2._2$mcI$sp();
            StructField structField = new StructField(new StringBuilder(1).append("c").append(idx).toString(), StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            return structField;
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    public String prettyName() {
        return "json_tuple";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().length() < 2 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(32).append(this.prettyName()).append(" requires at least two arguments").toString()) : (this.children().forall((Function1 & Serializable & scala.Serializable)child -> BoxesRunTime.boxToBoolean((boolean)StringType$.MODULE$.acceptsType(child.dataType()))) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(40).append(this.prettyName()).append(" requires that all arguments are strings").toString()));
    }

    @Override
    public TraversableOnce<InternalRow> eval(InternalRow input) {
        TraversableOnce traversableOnce;
        UTF8String json = (UTF8String)this.jsonExpr().eval(input);
        if (json == null) {
            return this.nullRow();
        }
        try {
            traversableOnce = (TraversableOnce)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> CreateJacksonParser$.MODULE$.utf8String(SharedFactory$.MODULE$.jsonFactory(), json), (Function1 & Serializable & scala.Serializable)parser -> this.parseRow((JsonParser)parser, input));
        }
        catch (JsonProcessingException jsonProcessingException) {
            traversableOnce = this.nullRow();
        }
        return traversableOnce;
    }

    private Seq<InternalRow> parseRow(JsonParser parser, InternalRow input) {
        JsonToken jsonToken = parser.nextToken();
        JsonToken jsonToken2 = JsonToken.START_OBJECT;
        if (jsonToken == null ? jsonToken2 != null : !jsonToken.equals(jsonToken2)) {
            return this.nullRow();
        }
        Seq fieldNames = this.constantFields() == this.fieldExpressions().length() ? (Seq)this.foldableFieldNames().map((Function1 & Serializable & scala.Serializable)x$8 -> (String)x$8.orNull(Predef$.MODULE$.$conforms()), IndexedSeq$.MODULE$.canBuildFrom()) : (this.constantFields() == 0 ? (Seq)this.fieldExpressions().map((Function1 & Serializable & scala.Serializable)x$9 -> ((UTF8String)x$9.eval(input)).toString(), Seq$.MODULE$.canBuildFrom()) : (Seq)((TraversableLike)this.foldableFieldNames().zip(this.fieldExpressions(), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Option option = (Option)tuple2._1();
                Expression expr = (Expression)tuple2._2();
                if (option == null) {
                    return ((UTF8String)expr.eval(input)).toString();
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Option fieldName = (Option)tuple2._1();
            return (String)fieldName.orNull(Predef$.MODULE$.$conforms());
        }, IndexedSeq$.MODULE$.canBuildFrom()));
        Object[] row = (Object[])Array$.MODULE$.ofDim(fieldNames.length(), ClassTag$.MODULE$.Any());
        while (true) {
            String jsonField;
            int idx;
            JsonToken jsonToken3 = parser.nextToken();
            JsonToken jsonToken4 = JsonToken.END_OBJECT;
            if (!(jsonToken3 == null ? jsonToken4 != null : !jsonToken3.equals(jsonToken4))) break;
            JsonToken jsonToken5 = parser.getCurrentToken();
            JsonToken jsonToken6 = JsonToken.FIELD_NAME;
            if (!(jsonToken5 != null ? !jsonToken5.equals(jsonToken6) : jsonToken6 != null) && (idx = fieldNames.indexOf((Object)(jsonField = parser.getCurrentName()))) >= 0) {
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                JsonToken jsonToken7 = parser.nextToken();
                JsonToken jsonToken8 = JsonToken.VALUE_NULL;
                if (jsonToken7 == null ? jsonToken8 != null : !jsonToken7.equals(jsonToken8)) {
                    Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SharedFactory$.MODULE$.jsonFactory().createGenerator((OutputStream)output, JsonEncoding.UTF8), (Function1 & Serializable & scala.Serializable)generator -> {
                        this.copyCurrentStructure(generator, parser);
                        return BoxedUnit.UNIT;
                    });
                    UTF8String jsonValue = UTF8String.fromBytes((byte[])output.toByteArray());
                    do {
                        row[idx] = jsonValue;
                    } while ((idx = fieldNames.indexOf((Object)jsonField, idx + 1)) >= 0);
                }
            }
            parser.skipChildren();
        }
        GenericInternalRow genericInternalRow = new GenericInternalRow(row);
        return Nil$.MODULE$.$colon$colon((Object)genericInternalRow);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyCurrentStructure(JsonGenerator generator, JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.hasTextCharacters()) {
                generator.writeRaw(parser.getTextCharacters(), parser.getTextOffset(), parser.getTextLength());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl) {
            generator.writeRaw(parser.getText());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (JsonToken.VALUE_NULL.equals(jsonToken2)) {
            throw new IllegalStateException("Do not attempt to copy a null field");
        }
        generator.copyCurrentStructure(parser);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JsonTuple copy(Seq<Expression> children2) {
        return new JsonTuple(children2);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    @Override
    public String productPrefix() {
        return "JsonTuple";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.children();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JsonTuple;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JsonTuple)) return false;
        boolean bl = true;
        if (!bl) return false;
        JsonTuple jsonTuple = (JsonTuple)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = jsonTuple.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!jsonTuple.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$constantFields$1(Option x$7) {
        return x$7 != null;
    }

    public JsonTuple(Seq<Expression> children2) {
        this.children = children2;
        Generator.$init$(this);
        CodegenFallback.$init$(this);
    }
}

