/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.StringRepeat$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, n) - Returns the string which repeats the given string value n times.", examples="\n    Examples:\n      > SELECT _FUNC_('123', 2);\n       123123\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011>\u0011\u0015Q\u0005\u0001\"\u0011>\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u0015\t\u0007\u0001\"\u0011c\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u0015!\b\u0001\"\u0011v\u0011%\t9\u0001AA\u0001\n\u0003\tI\u0001C\u0005\u0002\u0010\u0001\t\n\u0011\"\u0001\u0002\u0012!I\u0011q\u0005\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u0003\u0005\n\u0003S\u0001\u0011\u0011!C!\u0003WA\u0011\"a\u000f\u0001\u0003\u0003%\t!!\u0010\t\u0013\u0005\u0015\u0003!!A\u0005\u0002\u0005\u001d\u0003\"CA'\u0001\u0005\u0005I\u0011IA(\u0011%\ti\u0006AA\u0001\n\u0003\ty\u0006C\u0005\u0002j\u0001\t\t\u0011\"\u0011\u0002l\u001dI\u0011\u0011\u0012\u0010\u0002\u0002#\u0005\u00111\u0012\u0004\t;y\t\t\u0011#\u0001\u0002\u000e\"1Ai\u0006C\u0001\u00037C\u0011\"!(\u0018\u0003\u0003%)%a(\t\u0013\u0005\u0005v#!A\u0005\u0002\u0006\r\u0006\"CAU/\u0005\u0005I\u0011QAV\u0011%\tilFA\u0001\n\u0013\tyL\u0001\u0007TiJLgn\u001a*fa\u0016\fGO\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001'\u0015\u0001A\u0006M\u001a:!\tic&D\u0001\u001f\u0013\tycD\u0001\tCS:\f'/_#yaJ,7o]5p]B\u0011Q&M\u0005\u0003ey\u0011a#S7qY&\u001c\u0017\u000e^\"bgRLe\u000e];u)f\u0004Xm\u001d\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\b!J|G-^2u!\t!$(\u0003\u0002<k\ta1+\u001a:jC2L'0\u00192mK\u0006\u00191\u000f\u001e:\u0016\u0003y\u0002\"!L \n\u0005\u0001s\"AC#yaJ,7o]5p]\u0006!1\u000f\u001e:!\u0003\u0015!\u0018.\\3t\u0003\u0019!\u0018.\\3tA\u00051A(\u001b8jiz\"2AR$I!\ti\u0003\u0001C\u0003=\u000b\u0001\u0007a\bC\u0003C\u000b\u0001\u0007a(\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u00035\u0003\"AT)\u000e\u0003=S!\u0001\u0015\u0012\u0002\u000bQL\b/Z:\n\u0005I{%\u0001\u0003#bi\u0006$\u0016\u0010]3\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001V!\r1f,\u0014\b\u0003/rs!\u0001W.\u000e\u0003eS!A\u0017\u0016\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0014BA/6\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u00181\u0003\u0007M+\u0017O\u0003\u0002^k\u0005aa.\u001e7m'\u00064W-\u0012<bYR\u00191M\u001a5\u0011\u0005Q\"\u0017BA36\u0005\r\te.\u001f\u0005\u0006O*\u0001\raY\u0001\u0007gR\u0014\u0018N\\4\t\u000b%T\u0001\u0019A2\u0002\u00039\f!\u0002\u001d:fiRLh*Y7f+\u0005a\u0007CA7r\u001d\tqw\u000e\u0005\u0002Yk%\u0011\u0001/N\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002qk\u0005IAm\\$f]\u000e{G-\u001a\u000b\u0005mr\f\u0019\u0001\u0005\u0002xu6\t\u0001P\u0003\u0002z=\u000591m\u001c3fO\u0016t\u0017BA>y\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B?\r\u0001\u0004q\u0018aA2uqB\u0011qo`\u0005\u0004\u0003\u0003A(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u000ba\u0001\u0019\u0001<\u0002\u0005\u00154\u0018\u0001B2paf$RARA\u0006\u0003\u001bAq\u0001P\u0007\u0011\u0002\u0003\u0007a\bC\u0004C\u001bA\u0005\t\u0019\u0001 \u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0003\u0016\u0004}\u0005U1FAA\f!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005R'\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002\u001c\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!!\f\u0011\t\u0005=\u0012\u0011H\u0007\u0003\u0003cQA!a\r\u00026\u0005!A.\u00198h\u0015\t\t9$\u0001\u0003kCZ\f\u0017b\u0001:\u00022\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\b\t\u0004i\u0005\u0005\u0013bAA\"k\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u00191-!\u0013\t\u0013\u0005-##!AA\u0002\u0005}\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002RA)\u00111KA-G6\u0011\u0011Q\u000b\u0006\u0004\u0003/*\u0014AC2pY2,7\r^5p]&!\u00111LA+\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005\u0014q\r\t\u0004i\u0005\r\u0014bAA3k\t9!i\\8mK\u0006t\u0007\u0002CA&)\u0005\u0005\t\u0019A2\u0002\r\u0015\fX/\u00197t)\u0011\t\t'!\u001c\t\u0011\u0005-S#!AA\u0002\rDs\u0002AA9\u0003o\nI(! \u0002\u0000\u0005\r\u0015Q\u0011\t\u0004[\u0005M\u0014bAA;=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA>\u0003E{f)\u0016(D?\"\u001aHO\u001d\u0017!]&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043\u000f\u001e:j]\u001e\u0004s\u000f[5dQ\u0002\u0012X\r]3biN\u0004C\u000f[3!O&4XM\u001c\u0011tiJLgn\u001a\u0011wC2,X\r\t8!i&lWm\u001d\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!!\u0002\u0001*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%\r\u001a4O1\u0002#'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cI\u001a\u0014GM\u001a\u000bA\u0001\nQa]5oG\u0016\f#!a\"\u0002\u000bErSG\f\u0019\u0002\u0019M#(/\u001b8h%\u0016\u0004X-\u0019;\u0011\u00055:2\u0003B\f\u0002\u0010f\u0002r!!%\u0002\u0018zrd)\u0004\u0002\u0002\u0014*\u0019\u0011QS\u001b\u0002\u000fI,h\u000e^5nK&!\u0011\u0011TAJ\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003\u0017\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003[\tQ!\u00199qYf$RARAS\u0003OCQ\u0001\u0010\u000eA\u0002yBQA\u0011\u000eA\u0002y\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002.\u0006e\u0006#\u0002\u001b\u00020\u0006M\u0016bAAYk\t1q\n\u001d;j_:\u0004R\u0001NA[}yJ1!a.6\u0005\u0019!V\u000f\u001d7fe!A\u00111X\u000e\u0002\u0002\u0003\u0007a)A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0019\t\u0005\u0003_\t\u0019-\u0003\u0003\u0002F\u0006E\"AB(cU\u0016\u001cG\u000f")
public class StringRepeat
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression str;
    private final Expression times;

    public static Option<Tuple2<Expression, Expression>> unapply(StringRepeat stringRepeat) {
        return StringRepeat$.MODULE$.unapply(stringRepeat);
    }

    public static Function1<Tuple2<Expression, Expression>, StringRepeat> tupled() {
        return StringRepeat$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, StringRepeat>> curried() {
        return StringRepeat$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression times() {
        return this.times;
    }

    @Override
    public Expression left() {
        return this.str();
    }

    @Override
    public Expression right() {
        return this.times();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    public Seq<DataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{StringType$.MODULE$, IntegerType$.MODULE$}));
    }

    @Override
    public Object nullSafeEval(Object string, Object n) {
        return ((UTF8String)string).repeat(Predef$.MODULE$.Integer2int((Integer)n));
    }

    @Override
    public String prettyName() {
        return "repeat";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(l, r) -> new StringBuilder(11).append("(").append((String)l).append(").repeat(").append((String)r).append(")").toString());
    }

    public StringRepeat copy(Expression str, Expression times) {
        return new StringRepeat(str, times);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.times();
    }

    @Override
    public String productPrefix() {
        return "StringRepeat";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.str();
                break;
            }
            case 1: {
                expression = this.times();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringRepeat;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringRepeat)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringRepeat stringRepeat = (StringRepeat)x$1;
        Expression expression = this.str();
        Expression expression2 = stringRepeat.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.times();
        Expression expression4 = stringRepeat.times();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!stringRepeat.canEqual(this)) return false;
        return true;
    }

    public StringRepeat(Expression str, Expression times) {
        this.str = str;
        this.times = times;
        ExpectsInputTypes.$init$(this);
    }
}

