/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.time.LocalDate;
import org.apache.spark.sql.catalyst.expressions.DayWeek;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.WeekDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(date) - Returns the day of the week for date/timestamp (0 = Monday, 1 = Tuesday, ..., 6 = Sunday).", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30');\n       3\n  ", group="datetime_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\u000b\u0017\u0001\u000eB\u0001\"\r\u0001\u0003\u0016\u0004%\tA\r\u0005\tm\u0001\u0011\t\u0012)A\u0005g!)q\u0007\u0001C\u0001q!)1\b\u0001C)y!)!\t\u0001C)\u0007\"9\u0011\u000bAA\u0001\n\u0003\u0011\u0006b\u0002+\u0001#\u0003%\t!\u0016\u0005\bA\u0002\t\t\u0011\"\u0011b\u0011\u001dQ\u0007!!A\u0005\u0002-Dqa\u001c\u0001\u0002\u0002\u0013\u0005\u0001\u000fC\u0004t\u0001\u0005\u0005I\u0011\t;\t\u000fm\u0004\u0011\u0011!C\u0001y\"I\u00111\u0001\u0001\u0002\u0002\u0013\u0005\u0013QA\u0004\n\u0003S1\u0012\u0011!E\u0001\u0003W1\u0001\"\u0006\f\u0002\u0002#\u0005\u0011Q\u0006\u0005\u0007o=!\t!a\u000f\t\u0013\u0005ur\"!A\u0005F\u0005}\u0002\"CA!\u001f\u0005\u0005I\u0011QA\"\u0011%\t9eDA\u0001\n\u0003\u000bI\u0005C\u0005\u0002V=\t\t\u0011\"\u0003\u0002X\t9q+Z3l\t\u0006L(BA\f\u0019\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005eQ\u0012\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005ma\u0012aA:rY*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u00199bG\",'\"A\u0011\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001!\u0003F\f\t\u0003K\u0019j\u0011AF\u0005\u0003OY\u0011q\u0001R1z/\u0016,7\u000e\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#FA\u0004Qe>$Wo\u0019;\u0011\u0005%z\u0013B\u0001\u0019+\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005\u0019\u0004CA\u00135\u0013\t)dC\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002:uA\u0011Q\u0005\u0001\u0005\u0006c\r\u0001\raM\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0003{\u0001\u0003\"!\u000b \n\u0005}R#aA!os\")\u0011\t\u0002a\u0001{\u0005!A-\u0019;f\u0003%!wnR3o\u0007>$W\rF\u0002E\u0015>\u0003\"!\u0012%\u000e\u0003\u0019S!a\u0012\f\u0002\u000f\r|G-Z4f]&\u0011\u0011J\u0012\u0002\t\u000bb\u0004(oQ8eK\")1*\u0002a\u0001\u0019\u0006\u00191\r\u001e=\u0011\u0005\u0015k\u0015B\u0001(G\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ\u0001U\u0003A\u0002\u0011\u000b!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u0003sMCq!\r\u0004\u0011\u0002\u0003\u00071'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003YS#aM,,\u0003a\u0003\"!\u00170\u000e\u0003iS!a\u0017/\u0002\u0013Ut7\r[3dW\u0016$'BA/+\u0003)\tgN\\8uCRLwN\\\u0005\u0003?j\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\t!\r\u0005\u0002dQ6\tAM\u0003\u0002fM\u0006!A.\u00198h\u0015\u00059\u0017\u0001\u00026bm\u0006L!!\u001b3\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005a\u0007CA\u0015n\u0013\tq'FA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0002>c\"9!OCA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/F\u0001v!\r1\u00180P\u0007\u0002o*\u0011\u0001PK\u0001\u000bG>dG.Z2uS>t\u0017B\u0001>x\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007u\f\t\u0001\u0005\u0002*}&\u0011qP\u000b\u0002\b\u0005>|G.Z1o\u0011\u001d\u0011H\"!AA\u0002u\na!Z9vC2\u001cHcA?\u0002\b!9!/DA\u0001\u0002\u0004i\u0004f\u0005\u0001\u0002\f\u0005E\u00111CA\f\u00033\ti\"a\b\u0002$\u0005\u0015\u0002cA\u0013\u0002\u000e%\u0019\u0011q\u0002\f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QC\u0001j?\u001a+fjQ0)I\u0006$X-\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011eCf\u0004sN\u001a\u0011uQ\u0016\u0004s/Z3lA\u0019|'\u000f\t3bi\u0016|C/[7fgR\fW\u000e\u001d\u0011)a\u0001j\u0004%T8oI\u0006LH\u0006I\u0019!{\u0001\"V/Z:eCfd\u0003E\f\u0018/Y\u00012\u0004%\u0010\u0011Tk:$\u0017-_\u0015/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA\u000e\u0003}R\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006f\n\u001a1aej\u0003gN\u00174a\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa\u001a:pkB\f#!!\t\u0002\u001d\u0011\fG/\u001a;j[\u0016|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011qE\u0001\u0006e9\"d\u0006M\u0001\b/\u0016,7\u000eR1z!\t)sb\u0005\u0003\u0010\u0003_q\u0003CBA\u0019\u0003o\u0019\u0014(\u0004\u0002\u00024)\u0019\u0011Q\u0007\u0016\u0002\u000fI,h\u000e^5nK&!\u0011\u0011HA\u001a\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g.\r\u000b\u0003\u0003W\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002E\u0006)\u0011\r\u001d9msR\u0019\u0011(!\u0012\t\u000bE\u0012\u0002\u0019A\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111JA)!\u0011I\u0013QJ\u001a\n\u0007\u0005=#F\u0001\u0004PaRLwN\u001c\u0005\t\u0003'\u001a\u0012\u0011!a\u0001s\u0005\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00033\u00022aYA.\u0013\r\ti\u0006\u001a\u0002\u0007\u001f\nTWm\u0019;")
public class WeekDay
extends DayWeek
implements Serializable {
    private final Expression child;

    public static Option<Expression> unapply(WeekDay weekDay) {
        return WeekDay$.MODULE$.unapply(weekDay);
    }

    public static <A> Function1<Expression, A> andThen(Function1<WeekDay, A> function1) {
        return WeekDay$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, WeekDay> compose(Function1<A, Expression> function1) {
        return WeekDay$.MODULE$.compose(function1);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Object nullSafeEval(Object date) {
        LocalDate localDate = LocalDate.ofEpochDay(BoxesRunTime.unboxToInt((Object)date));
        return BoxesRunTime.boxToInteger((int)localDate.getDayOfWeek().ordinal());
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & java.io.Serializable & Serializable)days -> new StringBuilder(78).append("\n         ").append(ev.value()).append(" = java.time.LocalDate.ofEpochDay(").append((String)days).append(").getDayOfWeek().ordinal();\n      ").toString());
    }

    public WeekDay copy(Expression child) {
        return new WeekDay(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "WeekDay";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof WeekDay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof WeekDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        WeekDay weekDay = (WeekDay)x$1;
        Expression expression = this.child();
        Expression expression2 = weekDay.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!weekDay.canEqual(this)) return false;
        return true;
    }

    public WeekDay(Expression child) {
        this.child = child;
    }
}

