/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.aggregate.Percentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.util.collection.OpenHashMap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="\n      _FUNC_(col, percentage [, frequency]) - Returns the exact percentile value of numeric column\n       `col` at the given percentage. The value of percentage must be between 0.0 and 1.0. The\n       value of frequency should be positive integral\n\n      _FUNC_(col, array(percentage1 [, percentage2]...) [, frequency]) - Returns the exact\n      percentile value array of numeric column `col` at the given percentage(s). Each value\n      of the percentage array must be between 0.0 and 1.0. The value of frequency should be\n      positive integral\n\n      ", examples="\n    Examples:\n      > SELECT _FUNC_(col, 0.3) FROM VALUES (0), (10) AS tab(col);\n       3.0\n      > SELECT _FUNC_(col, array(0.25, 0.75)) FROM VALUES (0), (10) AS tab(col);\n       [2.5,7.5]\n  ", group="agg_funcs", since="2.1.0")
@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001\u0002\u001e<\u0001*C\u0001B\u001b\u0001\u0003\u0016\u0004%\ta\u001b\u0005\t_\u0002\u0011\t\u0012)A\u0005Y\"A\u0001\u000f\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005r\u0001\tE\t\u0015!\u0003m\u0011!\u0011\bA!f\u0001\n\u0003Y\u0007\u0002C:\u0001\u0005#\u0005\u000b\u0011\u00027\t\u0011Q\u0004!Q3A\u0005\u0002UD\u0001\"\u001f\u0001\u0003\u0012\u0003\u0006IA\u001e\u0005\tu\u0002\u0011)\u001a!C\u0001k\"A1\u0010\u0001B\tB\u0003%a\u000fC\u0003}\u0001\u0011\u0005Q\u0010\u0003\u0004}\u0001\u0011\u0005\u0011\u0011\u0002\u0005\u0007y\u0002!\t!a\u0004\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u00111\u0007\u0001\u0005B\u0005U\u0002bBA\u001e\u0001\u0011\u0005\u0013Q\b\u0005\u000b\u0003\u0007\u0002\u0001R1A\u0005\n\u0005\u0015\u0003BCA+\u0001!\u0015\r\u0011\"\u0003\u0002X!9\u0011q\r\u0001\u0005B\u0005%\u0004bBA?\u0001\u0011\u0005\u0013Q\t\u0005\u000b\u0003\u007f\u0002\u0001R1A\u0005B\u0005\u0005\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0005\b\u00037\u0003A\u0011IAO\u0011\u001d\tY\u000b\u0001C\u0005\u0003[Cq!!/\u0001\t\u0003\nY\fC\u0004\u0002>\u0002!\t%a0\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\"9\u00111\u001c\u0001\u0005B\u0005u\u0007bBAq\u0001\u0011%\u00111\u001d\u0005\b\u0003S\u0004A\u0011BAv\u0011\u001d\t\t\u0010\u0001C\u0005\u0003gDqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\u001c\u0001!\tE!\b\t\u000f\t-\u0002\u0001\"\u0011\u0003.!I!1\u0007\u0001\u0002\u0002\u0013\u0005!Q\u0007\u0005\n\u0005\u0003\u0002\u0011\u0013!C\u0001\u0005\u0007B\u0011B!\u0017\u0001#\u0003%\tAa\u0011\t\u0013\tm\u0003!%A\u0005\u0002\t\r\u0003\"\u0003B/\u0001E\u0005I\u0011\u0001B0\u0011%\u0011\u0019\u0007AI\u0001\n\u0003\u0011y\u0006C\u0005\u0003f\u0001\t\t\u0011\"\u0011\u0003h!A!q\u000f\u0001\u0002\u0002\u0013\u0005Q\u000fC\u0005\u0003z\u0001\t\t\u0011\"\u0001\u0003|!I!\u0011\u0011\u0001\u0002\u0002\u0013\u0005#1\u0011\u0005\n\u0005\u001f\u0003\u0011\u0011!C\u0001\u0005#C\u0011B!&\u0001\u0003\u0003%\tEa&\b\u0013\tm6(!A\t\u0002\tuf\u0001\u0003\u001e<\u0003\u0003E\tAa0\t\rq\u0004D\u0011\u0001Bg\u0011%\u0011y\rMA\u0001\n\u000b\u0012\t\u000eC\u0005\u0003TB\n\t\u0011\"!\u0003V\"I!\u0011\u001d\u0019\u0012\u0002\u0013\u0005!q\f\u0005\n\u0005G\u0004\u0014\u0013!C\u0001\u0005?B\u0011B!:1\u0003\u0003%\tIa:\t\u0013\te\b'%A\u0005\u0002\t}\u0003\"\u0003B~aE\u0005I\u0011\u0001B0\u0011%\u0011i\u0010MA\u0001\n\u0013\u0011yP\u0001\u0006QKJ\u001cWM\u001c;jY\u0016T!\u0001P\u001f\u0002\u0013\u0005<wM]3hCR,'B\u0001 @\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u0001\u000b\u0015\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005\t\u001b\u0015aA:rY*\u0011A)R\u0001\u0006gB\f'o\u001b\u0006\u0003\r\u001e\u000ba!\u00199bG\",'\"\u0001%\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001Y\u0005\rZ4\u0011\u00071ku*D\u0001<\u0013\tq5H\u0001\rUsB,G-S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004B\u0001U+X;6\t\u0011K\u0003\u0002S'\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005Q\u001b\u0015\u0001B;uS2L!AV)\u0003\u0017=\u0003XM\u001c%bg\"l\u0015\r\u001d\t\u00031nk\u0011!\u0017\u0006\u00025\u0006)1oY1mC&\u0011A,\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\u0005as\u0016BA0Z\u0005\u0011auN\\4\u0011\u0005\u0005\u0014W\"A\u001f\n\u0005\rl$AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005a+\u0017B\u00014Z\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u00175\n\u0005%L&\u0001D*fe&\fG.\u001b>bE2,\u0017!B2iS2$W#\u00017\u0011\u0005\u0005l\u0017B\u00018>\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002)A,'oY3oi\u0006<W-\u0012=qe\u0016\u001c8/[8o\u0003U\u0001XM]2f]R\fw-Z#yaJ,7o]5p]\u0002\n1C\u001a:fcV,gnY=FqB\u0014Xm]:j_:\fAC\u001a:fcV,gnY=FqB\u0014Xm]:j_:\u0004\u0013AF7vi\u0006\u0014G.Z!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0016\u0003Y\u0004\"\u0001W<\n\u0005aL&aA%oi\u00069R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000fI\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0002+%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3uA\u00051A(\u001b8jiz\"\"B`@\u0002\u0002\u0005\r\u0011QAA\u0004!\ta\u0005\u0001C\u0003k\u0017\u0001\u0007A\u000eC\u0003q\u0017\u0001\u0007A\u000eC\u0003s\u0017\u0001\u0007A\u000eC\u0004u\u0017A\u0005\t\u0019\u0001<\t\u000fi\\\u0001\u0013!a\u0001mR)a0a\u0003\u0002\u000e!)!\u000e\u0004a\u0001Y\")\u0001\u000f\u0004a\u0001YR9a0!\u0005\u0002\u0014\u0005U\u0001\"\u00026\u000e\u0001\u0004a\u0007\"\u00029\u000e\u0001\u0004a\u0007BBA\f\u001b\u0001\u0007A.A\u0005ge\u0016\fX/\u001a8ds\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005u\u0001\u0003BA\u0010\u0003[qA!!\t\u0002*A\u0019\u00111E-\u000e\u0005\u0005\u0015\"bAA\u0014\u0013\u00061AH]8pizJ1!a\u000bZ\u0003\u0019\u0001&/\u001a3fM&!\u0011qFA\u0019\u0005\u0019\u0019FO]5oO*\u0019\u00111F-\u0002;]LG\u000f\u001b(fo6+H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR$2A`A\u001c\u0011\u0019\tId\u0004a\u0001m\u0006Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0019a0a\u0010\t\r\u0005\u0005\u0003\u00031\u0001w\u0003]qWm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G/A\u000bsKR,(O\u001c)fe\u000e,g\u000e^5mK\u0006\u0013(/Y=\u0016\u0005\u0005\u001d\u0003c\u0001-\u0002J%\u0019\u00111J-\u0003\u000f\t{w\u000e\\3b]\"\u001a\u0011#a\u0014\u0011\u0007a\u000b\t&C\u0002\u0002Te\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0017A,'oY3oi\u0006<Wm]\u000b\u0003\u00033\u0002R\u0001WA.\u0003?J1!!\u0018Z\u0005\u0015\t%O]1z!\rA\u0016\u0011M\u0005\u0004\u0003GJ&A\u0002#pk\ndW\rK\u0002\u0013\u0003\u001f\n\u0001b\u00195jY\u0012\u0014XM\\\u000b\u0003\u0003W\u0002R!!\u001c\u0002x1tA!a\u001c\u0002t9!\u00111EA9\u0013\u0005Q\u0016bAA;3\u00069\u0001/Y2lC\u001e,\u0017\u0002BA=\u0003w\u00121aU3r\u0015\r\t)(W\u0001\t]VdG.\u00192mK\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u0004B!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n\u0006\u000bQ\u0001^=qKNLA!!$\u0002\b\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\"!a%\u0011\r\u00055\u0014qOAK!\u0011\t))a&\n\t\u0005e\u0015q\u0011\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\"!a(\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GS1!!*@\u0003!\tg.\u00197zg&\u001c\u0018\u0002BAU\u0003G\u0013q\u0002V=qK\u000eCWmY6SKN,H\u000e^\u0001\u000ei>$u.\u001e2mKZ\u000bG.^3\u0015\t\u0005}\u0013q\u0016\u0005\b\u0003cC\u0002\u0019AAZ\u0003\u0005!\u0007c\u0001-\u00026&\u0019\u0011qW-\u0003\u0007\u0005s\u00170A\fde\u0016\fG/Z!hOJ,w-\u0019;j_:\u0014UO\u001a4feR\tq*\u0001\u0004va\u0012\fG/\u001a\u000b\u0006\u001f\u0006\u0005\u0017Q\u0019\u0005\u0007\u0003\u0007T\u0002\u0019A(\u0002\r\t,hMZ3s\u0011\u001d\t9M\u0007a\u0001\u0003\u0013\fQ!\u001b8qkR\u0004B!a3\u0002N6\tq(C\u0002\u0002P~\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006)Q.\u001a:hKR)q*!6\u0002X\"1\u00111Y\u000eA\u0002=Ca!!7\u001c\u0001\u0004y\u0015!B8uQ\u0016\u0014\u0018\u0001B3wC2$B!a-\u0002`\"1\u00111\u0019\u000fA\u0002=\u000babZ3u!\u0016\u00148-\u001a8uS2,7\u000f\u0006\u0003\u0002f\u0006\u001d\bCBA7\u0003o\ny\u0006\u0003\u0004\u0002Dv\u0001\raT\u0001\u000fO\u0016tWM]1uK>+H\u000f];u)\u0011\t\u0019,!<\t\u000f\u0005=h\u00041\u0001\u0002f\u00069!/Z:vYR\u001c\u0018!D4fiB+'oY3oi&dW\r\u0006\u0004\u0002`\u0005U(\u0011\u0001\u0005\b\u0003o|\u0002\u0019AA}\u0003-\twm\u001a:f\u0007>,h\u000e^:\u0011\r\u00055\u0014qOA~!\u0015A\u0016Q`,^\u0013\r\ty0\u0017\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\t\rq\u00041\u0001\u0002`\u0005A\u0001o\\:ji&|g.A\tcS:\f'/_*fCJ\u001c\u0007nQ8v]R$\u0012B\u001eB\u0005\u0005\u001f\u0011\u0019Ba\u0006\t\u000f\t-\u0001\u00051\u0001\u0003\u000e\u0005Y1m\\;oiN\f%O]1z!\u0011A\u00161L/\t\r\tE\u0001\u00051\u0001w\u0003\u0015\u0019H/\u0019:u\u0011\u0019\u0011)\u0002\ta\u0001m\u0006\u0019QM\u001c3\t\r\te\u0001\u00051\u0001^\u0003\u00151\u0018\r\\;f\u0003%\u0019XM]5bY&TX\r\u0006\u0003\u0003 \t\u001d\u0002#\u0002-\u0002\\\t\u0005\u0002c\u0001-\u0003$%\u0019!QE-\u0003\t\tKH/\u001a\u0005\u0007\u0005S\t\u0003\u0019A(\u0002\u0007=\u0014'.A\u0006eKN,'/[1mSj,GcA(\u00030!9!\u0011\u0007\u0012A\u0002\t}\u0011!\u00022zi\u0016\u001c\u0018\u0001B2paf$2B B\u001c\u0005s\u0011YD!\u0010\u0003@!9!n\tI\u0001\u0002\u0004a\u0007b\u00029$!\u0003\u0005\r\u0001\u001c\u0005\be\u000e\u0002\n\u00111\u0001m\u0011\u001d!8\u0005%AA\u0002YDqA_\u0012\u0011\u0002\u0003\u0007a/\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u0015#f\u00017\u0003H-\u0012!\u0011\n\t\u0005\u0005\u0017\u0012)&\u0004\u0002\u0003N)!!q\nB)\u0003%)hn\u00195fG.,GMC\u0002\u0003Te\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119F!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TC\u0001B1U\r1(qI\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011!\u0011\u000e\t\u0005\u0005W\u0012)(\u0004\u0002\u0003n)!!q\u000eB9\u0003\u0011a\u0017M\\4\u000b\u0005\tM\u0014\u0001\u00026bm\u0006LA!a\f\u0003n\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAZ\u0005{B\u0001Ba ,\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0005C\u0002BD\u0005\u0017\u000b\u0019,\u0004\u0002\u0003\n*\u0011!+W\u0005\u0005\u0005\u001b\u0013II\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA$\u0005'C\u0011Ba .\u0003\u0003\u0005\r!a-\u0002\r\u0015\fX/\u00197t)\u0011\t9E!'\t\u0013\t}d&!AA\u0002\u0005M\u0006f\u0005\u0001\u0003\u001e\n\r&Q\u0015BU\u0005W\u0013yK!-\u00036\n]\u0006cA1\u0003 &\u0019!\u0011U\u001f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!qU\u0001\u0005Z)\u0001\u0003\u0005\t\u0011!A}3UKT\"`Q\r|G\u000e\f\u0011qKJ\u001cWM\u001c;bO\u0016\u00043\f\f\u0011ge\u0016\fX/\u001a8dsvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u001a=bGR\u0004\u0003/\u001a:dK:$\u0018\u000e\\3!m\u0006dW/\u001a\u0011pM\u0002rW/\\3sS\u000e\u00043m\u001c7v[:T\u0001\u0005\t\u0011!A\u0001\u0002\u0003mY8mA\u0002\nG\u000f\t;iK\u0002:\u0017N^3oAA,'oY3oi\u0006<WM\f\u0011UQ\u0016\u0004c/\u00197vK\u0002zg\r\t9fe\u000e,g\u000e^1hK\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9\u0002C\u000b[3\u000bA\u0001\u0002\u0003\u0005\t\u0011!m\u0006dW/\u001a\u0011pM\u00022'/Z9vK:\u001c\u0017\u0010I:i_VdG\r\t2fAA|7/\u001b;jm\u0016\u0004\u0013N\u001c;fOJ\fGN\u0003\u0006!A\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2pY2\u0002\u0013M\u001d:bs\"\u0002XM]2f]R\fw-Z\u0019!72\u0002\u0003/\u001a:dK:$\u0018mZ33;:rc&\u000b\u0011\\Y\u00012'/Z9vK:\u001c\u00170X\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!Kb\f7\r\u001e\u0006!A\u0001\u0002\u0003\u0005\t9fe\u000e,g\u000e^5mK\u00022\u0018\r\\;fA\u0005\u0014(/Y=!_\u001a\u0004c.^7fe&\u001c\u0007eY8mk6t\u0007\u0005Y2pY\u0002\u0004\u0013\r\u001e\u0011uQ\u0016\u0004s-\u001b<f]\u0002\u0002XM]2f]R\fw-\u001a\u0015tS9\u0002S)Y2iAY\fG.^3\u000bA\u0001\u0002\u0003\u0005\t\u0011pM\u0002\"\b.\u001a\u0011qKJ\u001cWM\u001c;bO\u0016\u0004\u0013M\u001d:bs\u0002jWo\u001d;!E\u0016\u0004#-\u001a;xK\u0016t\u0007\u0005\r\u00181A\u0005tG\rI\u0019/a9\u0002C\u000b[3!m\u0006dW/\u001a\u0011pM\u00022'/Z9vK:\u001c\u0017\u0010I:i_VdG\r\t2f\u0015\u0001\u0002\u0003\u0005\t\u0011!a>\u001c\u0018\u000e^5wK\u0002Jg\u000e^3he\u0006d'B\u0003\u0011!A\u0001\u0002\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\u0011i+AAB\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!a9\u001a\u0014\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003\u0006M\u0015-A!\n\u0004'\u000b\u0011B'\u0002\"\u0018M\u0019\u0015d_2L3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a/a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7-A\u0005\u0014(/Y=)a9\u0012T\u0007\f\u00111]]*\u0014&\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b\u0019*Y\u0001B\u0013\u0007M\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\e9*Df\u000e\u00186;*\u0001\u0003%A\u0003he>,\b/\t\u0002\u00034\u0006I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0005s\u000bQA\r\u00182]A\n!\u0002U3sG\u0016tG/\u001b7f!\ta\u0005g\u0005\u00031\u0005\u0003<\u0007C\u0003Bb\u0005\u0013dG\u000e\u001c<w}6\u0011!Q\u0019\u0006\u0004\u0005\u000fL\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u0017\u0014)MA\tBEN$(/Y2u\rVt7\r^5p]V\"\"A!0\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"A!\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0017y\u00149N!7\u0003\\\nu'q\u001c\u0005\u0006UN\u0002\r\u0001\u001c\u0005\u0006aN\u0002\r\u0001\u001c\u0005\u0006eN\u0002\r\u0001\u001c\u0005\biN\u0002\n\u00111\u0001w\u0011\u001dQ8\u0007%AA\u0002Y\fq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%k\u00059QO\\1qa2LH\u0003\u0002Bu\u0005k\u0004R\u0001\u0017Bv\u0005_L1A!<Z\u0005\u0019y\u0005\u000f^5p]BA\u0001L!=mY24h/C\u0002\u0003tf\u0013a\u0001V;qY\u0016,\u0004\u0002\u0003B|m\u0005\u0005\t\u0019\u0001@\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0007\u0003\u0001BAa\u001b\u0004\u0004%!1Q\u0001B7\u0005\u0019y%M[3di\u0002")
public class Percentile
extends TypedImperativeAggregate<OpenHashMap<Object, Object>>
implements ImplicitCastInputTypes,
scala.Serializable {
    private transient boolean returnPercentileArray;
    private transient double[] percentages;
    private DataType dataType;
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression frequencyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$5() {
        return Percentile$.MODULE$.$lessinit$greater$default$5();
    }

    public static int $lessinit$greater$default$4() {
        return Percentile$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(Percentile percentile) {
        return Percentile$.MODULE$.unapply(percentile);
    }

    public static int apply$default$5() {
        return Percentile$.MODULE$.apply$default$5();
    }

    public static int apply$default$4() {
        return Percentile$.MODULE$.apply$default$4();
    }

    public static Function1<Tuple5<Expression, Expression, Expression, Object, Object>, Percentile> tupled() {
        return Percentile$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Object, Function1<Object, Percentile>>>>> curried() {
        return Percentile$.MODULE$.curried();
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression frequencyExpression() {
        return this.frequencyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "percentile";
    }

    @Override
    public Percentile withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$5();
        return this.copy(x$2, x$3, x$4, x$1, x$5);
    }

    @Override
    public Percentile withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        int x$5 = this.copy$default$4();
        return this.copy(x$2, x$3, x$4, x$5, x$1);
    }

    private boolean returnPercentileArray$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.returnPercentileArray = this.percentageExpression().dataType() instanceof ArrayType;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.returnPercentileArray;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                double[] dArray;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object == null) {
                    dArray = null;
                } else if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    dArray = new double[]{d};
                } else if (object instanceof ArrayData) {
                    ArrayData arrayData = (ArrayData)object;
                    dArray = arrayData.toDoubleArray();
                } else {
                    throw new MatchError(object);
                }
                this.percentages = dArray;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.percentages;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.child();
        Expression expression2 = this.percentageExpression();
        Expression expression3 = this.frequencyExpression();
        return Nil$.MODULE$.$colon$colon((Object)expression3).$colon$colon((Object)expression2).$colon$colon((Object)expression);
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private DataType dataType$lzycompute() {
        Percentile percentile = this;
        synchronized (percentile) {
            if (!this.bitmap$0) {
                DataType dataType = this.percentageExpression().dataType();
                DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
                this.dataType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.dataType;
    }

    @Override
    public DataType dataType() {
        return !this.bitmap$0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        DataType dataType = this.percentageExpression().dataType();
        DataType dataType2 = dataType instanceof ArrayType ? new ArrayType(DoubleType$.MODULE$, false) : DoubleType$.MODULE$;
        DoubleType$ percentageExpType = dataType2;
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, percentageExpType, IntegralType$.MODULE$}));
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes.checkInputDataTypes$(this);
        return defaultCheck.isFailure() ? defaultCheck : (!this.percentageExpression().foldable() ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(54).append("The percentage(s) must be a constant literal, ").append("but got ").append(this.percentageExpression()).toString()) : (this.percentages() == null ? new TypeCheckResult.TypeCheckFailure("Percentage value must not be null") : (new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)percentage -> percentage < 0.0 || percentage > 1.0) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(51).append("Percentage(s) must be between 0.0 and 1.0, ").append("but got ").append(this.percentageExpression()).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)));
    }

    private double toDoubleValue(Object d) {
        double d2;
        Object object = d;
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            d2 = decimal.toDouble();
        } else if (object instanceof Number) {
            Number number = (Number)object;
            d2 = number.doubleValue();
        } else {
            throw new MatchError(object);
        }
        return d2;
    }

    @Override
    public OpenHashMap<Object, Object> createAggregationBuffer() {
        return new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
    }

    @Override
    public OpenHashMap<Object, Object> update(OpenHashMap<Object, Object> buffer, InternalRow input) {
        Object object;
        Object key = this.child().eval(input);
        Object frqValue = this.frequencyExpression().eval(input);
        if (key != null && frqValue != null) {
            long frqLong = ((Number)frqValue).longValue();
            if (frqLong > 0L) {
                object = BoxesRunTime.boxToLong((long)buffer.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> frqLong, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$4 -> x$4 + frqLong));
            } else {
                if (frqLong < 0L) {
                    throw new SparkException(new StringBuilder(25).append("Negative values found in ").append(this.frequencyExpression().sql()).toString());
                }
                object = BoxedUnit.UNIT;
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        return buffer;
    }

    @Override
    public OpenHashMap<Object, Object> merge(OpenHashMap<Object, Object> buffer, OpenHashMap<Object, Object> other) {
        other.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToLong((long)Percentile.$anonfun$merge$1(buffer, x0$1)));
        return buffer;
    }

    @Override
    public Object eval(OpenHashMap<Object, Object> buffer) {
        return this.generateOutput(this.getPercentiles(buffer));
    }

    private Seq<Object> getPercentiles(OpenHashMap<Object, Object> buffer) {
        if (buffer.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        Seq sortedCounts = (Seq)buffer.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$6 -> x$6._1(), ((NumericType)this.child().dataType()).ordering());
        Seq accumlatedCounts = (Seq)((TraversableLike)sortedCounts.scanLeft((Object)new Tuple2(((Tuple2)sortedCounts.head())._1(), (Object)BoxesRunTime.boxToLong((long)0L)), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            long count1;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    Tuple2 tuple23 = (Tuple2)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple23 == null) break block2;
                    count1 = tuple23._2$mcJ$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object key2 = tuple2._1();
            long count2 = tuple2._2$mcJ$sp();
            Tuple2 tuple24 = new Tuple2(key2, (Object)BoxesRunTime.boxToLong((long)(count1 + count2)));
            return tuple24;
        }, Seq$.MODULE$.canBuildFrom())).tail();
        long maxPosition = ((Tuple2)accumlatedCounts.last())._2$mcJ$sp() - 1L;
        return (Seq)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.percentages())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)percentile -> this.getPercentile((Seq<Tuple2<Object, Object>>)accumlatedCounts, (double)maxPosition * percentile), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private Object generateOutput(Seq<Object> results) {
        return results.isEmpty() ? null : (this.returnPercentileArray() ? new GenericArrayData(results) : results.head());
    }

    private double getPercentile(Seq<Tuple2<Object, Object>> aggreCounts, double position) {
        long lower = (long)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(position));
        long higher = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(position));
        long[] countsArray = (long[])((TraversableOnce)aggreCounts.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7._2$mcJ$sp()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Long());
        int lowerIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), lower + 1L);
        int higherIndex = this.binarySearchCount(countsArray, 0, aggreCounts.size(), higher + 1L);
        Object lowerKey = ((Tuple2)aggreCounts.apply(lowerIndex))._1();
        if (higher == lower) {
            return this.toDoubleValue(lowerKey);
        }
        Object higherKey = ((Tuple2)aggreCounts.apply(higherIndex))._1();
        if (BoxesRunTime.equals((Object)higherKey, (Object)lowerKey)) {
            return this.toDoubleValue(lowerKey);
        }
        return ((double)higher - position) * this.toDoubleValue(lowerKey) + (position - (double)lower) * this.toDoubleValue(higherKey);
    }

    private int binarySearchCount(long[] countsArray, int start, int end, long value) {
        int n = Arrays.binarySearch(countsArray, 0, end, value);
        switch (n) {
            default: 
        }
        return n < 0 ? -(n + 1) : n;
    }

    @Override
    public byte[] serialize(OpenHashMap<Object, Object> obj) {
        byte[] byArray;
        byte[] buffer = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bos);
        try {
            UnsafeProjection projection = UnsafeProjection$.MODULE$.create((DataType[])((Object[])new DataType[]{this.child().dataType(), LongType$.MODULE$}));
            obj.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Percentile.$anonfun$serialize$1(projection, out, buffer, x0$1);
                return BoxedUnit.UNIT;
            });
            out.writeInt(-1);
            out.flush();
            byArray = bos.toByteArray();
        }
        finally {
            out.close();
            bos.close();
        }
        return byArray;
    }

    @Override
    public OpenHashMap<Object, Object> deserialize(byte[] bytes) {
        OpenHashMap.mcJ.sp sp2;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream ins = new DataInputStream(bis);
        try {
            OpenHashMap.mcJ.sp counts = new OpenHashMap.mcJ.sp(ClassTag$.MODULE$.AnyRef(), ClassTag$.MODULE$.Long());
            int sizeOfNextRow = ins.readInt();
            while (sizeOfNextRow >= 0) {
                byte[] bs = new byte[sizeOfNextRow];
                ins.readFully(bs);
                UnsafeRow row = new UnsafeRow(2);
                row.pointTo(bs, sizeOfNextRow);
                Object key = row.get(0, this.child().dataType());
                long count = BoxesRunTime.unboxToLong((Object)row.get(1, LongType$.MODULE$));
                counts.update$mcJ$sp(key, count);
                sizeOfNextRow = ins.readInt();
            }
            sp2 = counts;
        }
        finally {
            ins.close();
            bis.close();
        }
        return sp2;
    }

    public Percentile copy(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new Percentile(child, percentageExpression, frequencyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.frequencyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "Percentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 2: {
                object = this.frequencyExpression();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Percentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Percentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        Percentile percentile = (Percentile)x$1;
        Expression expression = this.child();
        Expression expression2 = percentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = percentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.frequencyExpression();
        Expression expression6 = percentile.frequencyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != percentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != percentile.inputAggBufferOffset()) return false;
        if (!percentile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ long $anonfun$merge$1(OpenHashMap buffer$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        long l = buffer$1.changeValue$mcJ$sp(key, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> count, (Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)x$5 -> x$5 + count);
        return l;
    }

    public static final /* synthetic */ void $anonfun$serialize$1(UnsafeProjection projection$1, DataOutputStream out$1, byte[] buffer$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        long count = tuple2._2$mcJ$sp();
        InternalRow row = InternalRow$.MODULE$.apply((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key, BoxesRunTime.boxToLong((long)count)}));
        UnsafeRow unsafeRow = projection$1.apply(row);
        out$1.writeInt(unsafeRow.getSizeInBytes());
        unsafeRow.writeToStream(out$1, buffer$2);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequencyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.frequencyExpression = frequencyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes.$init$(this);
    }

    public Percentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)1L)), 0, 0);
    }

    public Percentile(Expression child, Expression percentageExpression, Expression frequency) {
        this(child, percentageExpression, frequency, 0, 0);
    }
}

