/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.ArrayDeque;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericMutableRow;
import org.apache.spark.sql.catalyst.expressions.WindowFunction;
import org.apache.spark.sql.execution.BoundOrdering;
import org.apache.spark.sql.execution.WindowFunctionFrame;
import org.apache.spark.util.collection.CompactBuffer;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001)4Q!\u0001\u0002\u0003\u00051\u0011!d\u00157jI&twmV5oI><h)\u001e8di&|gN\u0012:b[\u0016T!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u00111cV5oI><h)\u001e8di&|gN\u0012:b[\u0016D\u0001B\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\b_J$\u0017N\\1m\u0007\u0001\u0001\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u00111!\u00138u\u0011!Y\u0002A!A!\u0002\u0013a\u0012!\u00034v]\u000e$\u0018n\u001c8t!\r)RdH\u0005\u0003=Y\u0011Q!\u0011:sCf\u0004\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003I\u0011\t\u0001bY1uC2L8\u000f^\u0005\u0003M\u0005\u0012abV5oI><h)\u001e8di&|g\u000e\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0003\u0019a'm\\;oIB\u0011aBK\u0005\u0003W\t\u0011QBQ8v]\u0012|%\u000fZ3sS:<\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0015\u0002\rU\u0014w.\u001e8e\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q)\u0011GM\u001a5kA\u0011a\u0002\u0001\u0005\u0006%9\u0002\r\u0001\u0006\u0005\u000679\u0002\r\u0001\b\u0005\u0006Q9\u0002\r!\u000b\u0005\u0006[9\u0002\r!\u000b\u0005\u0007o\u0001\u0001\u000b\u0015\u0002\u001d\u0002\u000b%t\u0007/\u001e;\u0011\u0007er\u0004)D\u0001;\u0015\tYD(\u0001\u0006d_2dWm\u0019;j_:T!!\u0010\u0004\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fi\u0012QbQ8na\u0006\u001cGOQ;gM\u0016\u0014\bCA!C\u001b\u0005\u0019\u0013BA\"$\u0005-Ie\u000e^3s]\u0006d'k\\<\t\r\u0015\u0003\u0001\u0015)\u0003\u0015\u00039Ig\u000e];u\u0011&<\u0007.\u00138eKbDaa\u0012\u0001!B\u0013!\u0012!D5oaV$Hj\\<J]\u0012,\u0007\u0010\u0003\u0004J\u0001\u0001\u0006IAS\u0001\u0007EV4g-\u001a:\u0011\u0007-{\u0015+D\u0001M\u0015\tiTJC\u0001O\u0003\u0011Q\u0017M^1\n\u0005Ac%AC!se\u0006LH)Z9vKB\u0019Q#\b*\u0011\u0005U\u0019\u0016B\u0001+\u0017\u0005\u0019\te.\u001f*fM\"1a\u000b\u0001Q!\nQ\t1b\\;uaV$\u0018J\u001c3fq\")\u0001\f\u0001C!3\u00069\u0001O]3qCJ,GC\u0001.^!\t)2,\u0003\u0002]-\t!QK\\5u\u0011\u0015qv\u000b1\u00019\u0003\u0011\u0011xn^:\t\u000b\u0001\u0004A\u0011I1\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0005i\u0013\u0007\"B2`\u0001\u0004!\u0017A\u0002;be\u001e,G\u000f\u0005\u0002!K&\u0011a-\t\u0002\u0012\u000f\u0016tWM]5d\u001bV$\u0018M\u00197f%><\b\"\u00025\u0001\t\u0003J\u0017\u0001B2paf,\u0012!\r")
public final class SlidingWindowFunctionFrame
extends WindowFunctionFrame {
    private final int ordinal;
    private final BoundOrdering lbound;
    private final BoundOrdering ubound;
    private CompactBuffer<InternalRow> input;
    private int inputHighIndex;
    private int inputLowIndex;
    private final ArrayDeque<Object[]> buffer;
    private int outputIndex;

    @Override
    public void prepare(CompactBuffer<InternalRow> rows) {
        this.input = rows;
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
        this.outputIndex = 0;
        this.buffer.clear();
    }

    @Override
    public void write(GenericMutableRow target) {
        boolean bufferUpdated;
        boolean bl = bufferUpdated = this.outputIndex == 0;
        while (this.inputHighIndex < this.input.size() && this.ubound.compare((Seq<InternalRow>)this.input, this.inputHighIndex, this.outputIndex) <= 0) {
            this.buffer.offer(this.prepare((InternalRow)this.input.apply(this.inputHighIndex)));
            ++this.inputHighIndex;
            bufferUpdated = true;
        }
        while (this.inputLowIndex < this.inputHighIndex && this.lbound.compare((Seq<InternalRow>)this.input, this.inputLowIndex, this.outputIndex) < 0) {
            this.buffer.pop();
            ++this.inputLowIndex;
            bufferUpdated = true;
        }
        if (bufferUpdated) {
            this.evaluatePrepared(this.buffer.iterator());
            this.fill(target, this.outputIndex);
        }
        ++this.outputIndex;
    }

    @Override
    public SlidingWindowFunctionFrame copy() {
        return new SlidingWindowFunctionFrame(this.ordinal, this.copyFunctions(), this.lbound, this.ubound);
    }

    public SlidingWindowFunctionFrame(int ordinal, WindowFunction[] functions2, BoundOrdering lbound, BoundOrdering ubound) {
        this.ordinal = ordinal;
        this.lbound = lbound;
        this.ubound = ubound;
        super(ordinal, functions2);
        this.input = null;
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
        this.buffer = new ArrayDeque();
        this.outputIndex = 0;
    }
}

