/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.net.URI;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcRelationProvider;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider;
import org.apache.spark.sql.execution.streaming.sources.TextSocketSourceProvider;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DataSource$
implements Logging,
Serializable {
    public static final DataSource$ MODULE$;
    private final Map<String, String> backwardCompatibilityMap;
    private final Set<String> spark2RemovedClasses;
    private final String GLOB_PATHS_KEY;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DataSource$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private Map<String, String> backwardCompatibilityMap() {
        return this.backwardCompatibilityMap;
    }

    private Set<String> spark2RemovedClasses() {
        return this.spark2RemovedClasses;
    }

    /*
     * Unable to fully structure code
     */
    public Class<?> lookupDataSource(String provider, SQLConf conf) {
        block20: {
            block19: {
                var4_3 = (String)this.backwardCompatibilityMap().getOrElse((Object)provider, (Function0)new Serializable(provider){
                    public static final long serialVersionUID = 0L;
                    private final String provider$1;

                    public final String apply() {
                        return this.provider$1;
                    }
                    {
                        this.provider$1 = provider$1;
                    }
                });
                if (!var4_3.equalsIgnoreCase("orc")) break block19;
                v0 = conf.getConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
                var5_4 = "native";
                if (v0 != null ? v0.equals(var5_4) == false : var5_4 != null) break block19;
                var6_5 = OrcFileFormat.class.getCanonicalName();
                break block20;
            }
            if (!var4_3.equalsIgnoreCase("orc")) ** GOTO lbl-1000
            v1 = conf.getConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
            var7_6 = "hive";
            if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) {
                var6_5 = "org.apache.spark.sql.hive.orc.OrcFileFormat";
            } else lbl-1000:
            // 2 sources

            {
                var6_5 = "com.databricks.spark.avro".equals(var4_3) != false && conf.replaceDatabricksSparkAvroEnabled() != false ? "org.apache.spark.sql.avro.AvroFileFormat" : var4_3;
            }
        }
        provider1 = var6_5;
        provider2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".DefaultSource"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}));
        loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        serviceLoader = ServiceLoader.load(DataSourceRegister.class, loader);
        try {
            block27: {
                block26: {
                    block25: {
                        block21: {
                            block22: {
                                block24: {
                                    block23: {
                                        block18: {
                                            var16_11 = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(serviceLoader).asScala()).filter((Function1)new Serializable(provider1){
                                                public static final long serialVersionUID = 0L;
                                                private final String provider1$1;

                                                public final boolean apply(DataSourceRegister x$20) {
                                                    return x$20.shortName().equalsIgnoreCase(this.provider1$1);
                                                }
                                                {
                                                    this.provider1$1 = provider1$1;
                                                }
                                            })).toList();
                                            if (!Nil$.MODULE$.equals(var16_11)) break block21;
                                            try {
                                                var20_12 = Try$.MODULE$.apply((Function0)new Serializable(provider1, loader){
                                                    public static final long serialVersionUID = 0L;
                                                    private final String provider1$1;
                                                    private final ClassLoader loader$1;

                                                    public final Class<Object> apply() {
                                                        return this.loader$1.loadClass(this.provider1$1);
                                                    }
                                                    {
                                                        this.provider1$1 = provider1$1;
                                                        this.loader$1 = loader$1;
                                                    }
                                                }).orElse((Function0)new Serializable(provider2, loader){
                                                    public static final long serialVersionUID = 0L;
                                                    public final String provider2$1;
                                                    public final ClassLoader loader$1;

                                                    public final Try<Class<Object>> apply() {
                                                        return Try$.MODULE$.apply((Function0)new Serializable(this){
                                                            public static final long serialVersionUID = 0L;
                                                            private final /* synthetic */ anonfun.20 $outer;

                                                            public final Class<Object> apply() {
                                                                return this.$outer.loader$1.loadClass(this.$outer.provider2$1);
                                                            }
                                                            {
                                                                if ($outer == null) {
                                                                    throw null;
                                                                }
                                                                this.$outer = $outer;
                                                            }
                                                        });
                                                    }
                                                    {
                                                        this.provider2$1 = provider2$1;
                                                        this.loader$1 = loader$1;
                                                    }
                                                });
                                                if (!(var20_12 instanceof Success)) break block18;
                                                var21_13 = (Success)var20_12;
                                                var17_16 = var23_15 = (dataSource = (Class<?>)var21_13.value());
                                            }
                                            catch (NoClassDefFoundError var18_28) {
                                                className = var18_28.getMessage().replaceAll("/", ".");
                                                if (this.spark2RemovedClasses().contains((Object)className)) {
                                                    throw new ClassNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " was removed in Spark 2.0. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className}))).append((Object)"Please check if your library is compatible with Spark 2.0").toString(), var18_28);
                                                }
                                                throw var18_28;
                                            }
                                        }
                                        if (!(var20_12 instanceof Failure)) break block22;
                                        var24_17 = (Failure)var20_12;
                                        error = var24_17.exception();
                                        if (provider1.startsWith("org.apache.spark.sql.hive.orc")) {
                                            throw new AnalysisException("Hive built-in ORC data source must be used with Hive support enabled. Please use the native ORC data source by setting 'spark.sql.orc.impl' to 'native'", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                        }
                                        v2 = provider1.toLowerCase(Locale.ROOT);
                                        var26_19 = "avro";
                                        if (!(v2 == null ? var26_19 != null : v2.equals(var26_19) == false)) break block23;
                                        v3 = provider1;
                                        var27_20 = "com.databricks.spark.avro";
                                        if (!(v3 == null ? var27_20 != null : v3.equals(var27_20) == false)) break block23;
                                        v4 = provider1;
                                        var28_21 = "org.apache.spark.sql.avro";
                                        if (v4 != null ? v4.equals(var28_21) == false : var28_21 != null) break block24;
                                    }
                                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find data source: ", ". Avro is built-in but external data "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}))).append((Object)"source module since Spark 2.4. Please deploy the application as per ").append((Object)"the deployment section of \"Apache Avro Data Source Guide\".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                }
                                v5 = provider1.toLowerCase(Locale.ROOT);
                                var29_22 = "kafka";
                                if (!(v5 != null ? v5.equals(var29_22) == false : var29_22 != null)) {
                                    throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find data source: ", ". Please deploy the application as "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}))).append((Object)"per the deployment section of ").append((Object)"\"Structured Streaming + Kafka Integration Guide\".").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                                }
                                throw new ClassNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find data source: ", ". Please find packages at "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}))).append((Object)"http://spark.apache.org/third-party-projects.html").toString(), error);
                            }
                            throw new MatchError((Object)var20_12);
                        }
                        if (!(var16_11 instanceof .colon.colon)) break block25;
                        var30_23 = (.colon.colon)var16_11;
                        head = (DataSourceRegister)var30_23.head();
                        var32_25 = var30_23.tl$1();
                        if (!Nil$.MODULE$.equals(var32_25)) break block25;
                        var17_16 = head.getClass();
                        break block26;
                    }
                    sourceNames = (List)var16_11.map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final String apply(DataSourceRegister x$21) {
                            return x$21.getClass().getName();
                        }
                    }, List$.MODULE$.canBuildFrom());
                    internalSources = (List)var16_11.filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(DataSourceRegister x$22) {
                            return x$22.getClass().getName().startsWith("org.apache.spark");
                        }
                    });
                    if (internalSources.size() != 1) break block27;
                    this.logWarning((Function0<String>)new Serializable(provider1, sourceNames, internalSources){
                        public static final long serialVersionUID = 0L;
                        private final String provider1$1;
                        private final List sourceNames$1;
                        private final List internalSources$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple sources found for ", " (", "), "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.provider1$1, this.sourceNames$1.mkString(", ")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"defaulting to the internal datasource (", ")."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.internalSources$1.head().getClass().getName()}))).toString();
                        }
                        {
                            this.provider1$1 = provider1$1;
                            this.sourceNames$1 = sourceNames$1;
                            this.internalSources$1 = internalSources$1;
                        }
                    });
                    var17_16 = internalSources.head().getClass();
                }
                return var17_16;
            }
            throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Multiple sources found for ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{provider1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", "), please specify the fully qualified class name."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourceNames.mkString(", ")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        catch (Throwable var11_30) {
            var12_31 = var11_30;
            if (var12_31 instanceof ServiceConfigurationError && (var13_32 = (ServiceConfigurationError)var12_31).getCause() instanceof NoClassDefFoundError) {
                className = var13_32.getCause().getMessage().replaceAll("/", ".");
                if (this.spark2RemovedClasses().contains((Object)className)) {
                    throw new ClassNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected an incompatible DataSourceRegister. "})).s((Seq)Nil$.MODULE$)).append((Object)"Please remove the incompatible library from classpath or upgrade it. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var13_32.getMessage()}))).toString(), var13_32);
                }
                throw var13_32;
            }
            throw var11_30;
        }
    }

    public CatalogStorageFormat buildStorageFormatFromOptions(Map<String, String> options) {
        Option path = CaseInsensitiveMap$.MODULE$.apply(options).get("path");
        Map optionsWithoutPath = options.filterKeys((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$23) {
                String string = x$23.toLowerCase(Locale.ROOT);
                String string2 = "path";
                return string != null ? !string.equals(string2) : string2 != null;
            }
        });
        Option x$45 = path.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final URI apply(String str2) {
                return CatalogUtils$.MODULE$.stringToURI(str2);
            }
        });
        Map x$46 = optionsWithoutPath;
        Option x$47 = CatalogStorageFormat$.MODULE$.empty().copy$default$2();
        Option x$48 = CatalogStorageFormat$.MODULE$.empty().copy$default$3();
        Option x$49 = CatalogStorageFormat$.MODULE$.empty().copy$default$4();
        boolean x$50 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        return CatalogStorageFormat$.MODULE$.empty().copy(x$45, x$47, x$48, x$49, x$50, x$46);
    }

    public void org$apache$spark$sql$execution$datasources$DataSource$$validateSchema(StructType schema2) {
        if (this.org$apache$spark$sql$execution$datasources$DataSource$$hasEmptySchema$1(schema2)) {
            throw new AnalysisException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |Datasource does not support writing empty or nested empty schemas.\n           |Please make sure the data schema has at least one or more column(s).\n         "})).s((Seq)Nil$.MODULE$))).stripMargin(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public String GLOB_PATHS_KEY() {
        return this.GLOB_PATHS_KEY;
    }

    public DataSource apply(SparkSession sparkSession, String className, Seq<String> paths, Option<StructType> userSpecifiedSchema, Seq<String> partitionColumns, Option<BucketSpec> bucketSpec, Map<String, String> options, Option<CatalogTable> catalogTable) {
        return new DataSource(sparkSession, className, paths, userSpecifiedSchema, partitionColumns, bucketSpec, options, catalogTable);
    }

    public Option<Tuple8<SparkSession, String, Seq<String>, Option<StructType>, Seq<String>, Option<BucketSpec>, Map<String, String>, Option<CatalogTable>>> unapply(DataSource x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.sparkSession(), (Object)x$0.className(), x$0.paths(), x$0.userSpecifiedSchema(), x$0.partitionColumns(), x$0.bucketSpec(), x$0.options(), x$0.catalogTable()));
    }

    public Seq<String> apply$default$3() {
        return Nil$.MODULE$;
    }

    public Option<StructType> apply$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> apply$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option<BucketSpec> apply$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> apply$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> apply$default$8() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public Option<StructType> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$5() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Option<BucketSpec> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final boolean org$apache$spark$sql$execution$datasources$DataSource$$hasEmptySchema$1(StructType schema2) {
        return schema2.size() == 0 || schema2.find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(StructField x0$1) {
                boolean bl;
                DataType b;
                StructField structField = x0$1;
                if (structField != null && (b = structField.dataType()) instanceof StructType) {
                    StructType structType = (StructType)b;
                    bl = DataSource$.MODULE$.org$apache$spark$sql$execution$datasources$DataSource$$hasEmptySchema$1(structType);
                } else {
                    bl = false;
                }
                return bl;
            }
        }).isDefined();
    }

    private DataSource$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        String jdbc = JdbcRelationProvider.class.getCanonicalName();
        String json = JsonFileFormat.class.getCanonicalName();
        String parquet = ParquetFileFormat.class.getCanonicalName();
        String csv = CSVFileFormat.class.getCanonicalName();
        String libsvm = "org.apache.spark.ml.source.libsvm.LibSVMFileFormat";
        String orc = "org.apache.spark.sql.hive.orc.OrcFileFormat";
        String nativeOrc = OrcFileFormat.class.getCanonicalName();
        String socket = TextSocketSourceProvider.class.getCanonicalName();
        String rate = RateStreamProvider.class.getCanonicalName();
        this.backwardCompatibilityMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc.DefaultSource"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.orc.DefaultSource"), (Object)nativeOrc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.orc"), (Object)nativeOrc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm.DefaultSource"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"com.databricks.spark.csv"), (Object)csv), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.streaming.TextSocketSourceProvider"), (Object)socket), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.streaming.RateSourceProvider"), (Object)rate)}));
        this.spark2RemovedClasses = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.sql.DataFrame", "org.apache.spark.sql.sources.HadoopFsRelationProvider", "org.apache.spark.Logging"}));
        this.GLOB_PATHS_KEY = "__globPaths__";
    }
}

