/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter$;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog;
import org.apache.spark.sql.execution.streaming.FileStreamSinkLog$;
import org.apache.spark.sql.execution.streaming.ManifestFileCommitProtocol;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055v!B\u000e\u001d\u0011\u0003Ic!B\u0016\u001d\u0011\u0003a\u0003\"B\u001d\u0002\t\u0003Q\u0004bB\u001e\u0002\u0005\u0004%\t\u0001\u0010\u0005\u0007\u000b\u0006\u0001\u000b\u0011B\u001f\t\u000b\u0019\u000bA\u0011A$\t\u000bE\fA\u0011\u0001:\t\r}\fA\u0011AA\u0001\u0011\u001d\t\t\"\u0001C\u0001\u0003'1Qa\u000b\u000f\u0001\u00033A!\"a\n\n\u0005\u0003\u0005\u000b\u0011BA\u0015\u0011!a\u0015B!A!\u0002\u0013I\u0006BCA\u0019\u0013\t\u0005\t\u0015!\u0003\u00024!I\u0011qH\u0005\u0003\u0002\u0003\u0006I!\u0014\u0005\u000b\u0003\u0003J!\u0011!Q\u0001\n\u0005\r\u0003BB\u001d\n\t\u0003\tI\u0005\u0003\u0005b\u0013\t\u0007I\u0011BA,\u0011\u001d\tI&\u0003Q\u0001\n\tD\u0011\"a\u0017\n\u0005\u0004%I!!\u0018\t\u000f\u0005}\u0013\u0002)A\u0005g\"I\u0011\u0011M\u0005C\u0002\u0013%\u0011Q\f\u0005\b\u0003GJ\u0001\u0015!\u0003t\u0011%\t)'\u0003b\u0001\n\u0013\t9\u0007\u0003\u0005\u0002p%\u0001\u000b\u0011BA5\u0011\u001d\t\t(\u0003C\u0005\u0003gBq!a\u001f\n\t\u0003\ni\bC\u0004\u0002*&!\t%a+\u0002\u001d\u0019KG.Z*ue\u0016\fWnU5oW*\u0011QDH\u0001\ngR\u0014X-Y7j]\u001eT!a\b\u0011\u0002\u0013\u0015DXmY;uS>t'BA\u0011#\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003G\u0011\nQa\u001d9be.T!!\n\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0013aA8sO\u000e\u0001\u0001C\u0001\u0016\u0002\u001b\u0005a\"A\u0004$jY\u0016\u001cFO]3b[NKgn[\n\u0004\u00035\u001a\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g\r\u0005\u00025o5\tQG\u0003\u00027E\u0005A\u0011N\u001c;fe:\fG.\u0003\u00029k\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001*\u0003-iW\r^1eCR\fG)\u001b:\u0016\u0003u\u0002\"AP\"\u000e\u0003}R!\u0001Q!\u0002\t1\fgn\u001a\u0006\u0002\u0005\u0006!!.\u0019<b\u0013\t!uH\u0001\u0004TiJLgnZ\u0001\r[\u0016$\u0018\rZ1uC\u0012K'\u000fI\u0001\fQ\u0006\u001cX*\u001a;bI\u0006$\u0018\r\u0006\u0003I\u0017\u0002T\u0007C\u0001\u0018J\u0013\tQuFA\u0004C_>dW-\u00198\t\u000b1+\u0001\u0019A'\u0002\tA\fG\u000f\u001b\t\u0004\u001dZKfBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011\u0006&\u0001\u0004=e>|GOP\u0005\u0002a%\u0011QkL\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006LA\u0002TKFT!!V\u0018\u0011\u0005isfBA.]!\t\u0001v&\u0003\u0002^_\u00051\u0001K]3eK\u001aL!\u0001R0\u000b\u0005u{\u0003\"B1\u0006\u0001\u0004\u0011\u0017A\u00035bI>|\u0007oQ8oMB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0005G>tgM\u0003\u0002hI\u00051\u0001.\u00193p_BL!!\u001b3\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u0015YW\u00011\u0001m\u0003\u001d\u0019\u0018\u000f\\\"p]\u001a\u0004\"!\\8\u000e\u00039T!A\u000e\u0011\n\u0005At'aB*R\u0019\u000e{gNZ\u0001\u0013O\u0016$X*\u001a;bI\u0006$\u0018\rT8h!\u0006$\b\u000e\u0006\u0003tsvt\bC\u0001;x\u001b\u0005)(B\u0001<g\u0003\t17/\u0003\u0002yk\n!\u0001+\u0019;i\u0011\u00151h\u00011\u0001{!\t!80\u0003\u0002}k\nQa)\u001b7f'f\u001cH/Z7\t\u000b13\u0001\u0019A:\t\u000b-4\u0001\u0019\u00017\u00021\rDWmY6Fg\u000e\f\u0007/\u001a3NKR\fG-\u0019;b!\u0006$\b\u000e\u0006\u0005\u0002\u0004\u0005%\u00111BA\b!\rq\u0013QA\u0005\u0004\u0003\u000fy#\u0001B+oSRDQA^\u0004A\u0002iDa!!\u0004\b\u0001\u0004\u0019\u0018\u0001D7fi\u0006$\u0017\r^1QCRD\u0007\"B6\b\u0001\u0004a\u0017aG1oG\u0016\u001cHo\u001c:Jg6+G/\u00193bi\u0006$\u0015N]3di>\u0014\u0018\u0010F\u0003I\u0003+\t9\u0002C\u0003M\u0011\u0001\u00071\u000fC\u0003b\u0011\u0001\u0007!m\u0005\u0004\n\u00037\t\tc\r\t\u0004}\u0005u\u0011bAA\u0010\u007f\t1qJ\u00196fGR\u00042AKA\u0012\u0013\r\t)\u0003\b\u0002\u0005'&t7.\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0003\u0002,\u00055R\"\u0001\u0011\n\u0007\u0005=\u0002E\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0006gS2,gi\u001c:nCR\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sq\u0012a\u00033bi\u0006\u001cx.\u001e:dKNLA!!\u0010\u00028\tQa)\u001b7f\r>\u0014X.\u0019;\u0002)A\f'\u000f^5uS>t7i\u001c7v[:t\u0015-\\3t\u0003\u001dy\u0007\u000f^5p]N\u0004RAWA#3fK1!a\u0012`\u0005\ri\u0015\r\u001d\u000b\r\u0003\u0017\ni%a\u0014\u0002R\u0005M\u0013Q\u000b\t\u0003U%Aq!a\n\u0010\u0001\u0004\tI\u0003C\u0003M\u001f\u0001\u0007\u0011\fC\u0004\u00022=\u0001\r!a\r\t\r\u0005}r\u00021\u0001N\u0011\u001d\t\te\u0004a\u0001\u0003\u0007*\u0012AY\u0001\fQ\u0006$wn\u001c9D_:4\u0007%\u0001\u0005cCN,\u0007+\u0019;i+\u0005\u0019\u0018!\u00032bg\u0016\u0004\u0016\r\u001e5!\u0003\u001dawn\u001a)bi\"\f\u0001\u0002\\8h!\u0006$\b\u000eI\u0001\bM&dW\rT8h+\t\tI\u0007E\u0002+\u0003WJ1!!\u001c\u001d\u0005E1\u0015\u000e\\3TiJ,\u0017-\\*j].dunZ\u0001\tM&dW\rT8hA\u0005I\"-Y:jG^\u0013\u0018\u000e^3K_\n\u001cF/\u0019;t)J\f7m[3s+\t\t)\b\u0005\u0003\u00026\u0005]\u0014\u0002BA=\u0003o\u0011\u0011DQ1tS\u000e<&/\u001b;f\u0015>\u00147\u000b^1ugR\u0013\u0018mY6fe\u0006A\u0011\r\u001a3CCR\u001c\u0007\u000e\u0006\u0004\u0002\u0004\u0005}\u0014\u0011\u0012\u0005\b\u0003\u0003K\u0002\u0019AAB\u0003\u001d\u0011\u0017\r^2i\u0013\u0012\u00042ALAC\u0013\r\t9i\f\u0002\u0005\u0019>tw\rC\u0004\u0002\ff\u0001\r!!$\u0002\t\u0011\fG/\u0019\t\u0005\u0003\u001f\u000b\u0019K\u0004\u0003\u0002\u0012\u0006\u0005f\u0002BAJ\u0003?sA!!&\u0002\u001e:!\u0011qSAN\u001d\r\u0001\u0016\u0011T\u0005\u0002O%\u0011QEJ\u0005\u0003G\u0011J!!\t\u0012\n\u0005U\u0003\u0013\u0002BAS\u0003O\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005U\u0003\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003e\u0003")
public class FileStreamSink
implements Sink,
Logging {
    private final SparkSession sparkSession;
    private final String path;
    private final FileFormat fileFormat;
    private final Seq<String> partitionColumnNames;
    private final Map<String, String> options;
    private final Configuration hadoopConf;
    private final Path basePath;
    private final Path logPath;
    private final FileStreamSinkLog fileLog;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean ancestorIsMetadataDirectory(Path path, Configuration configuration) {
        return FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(path, configuration);
    }

    public static void checkEscapedMetadataPath(FileSystem fileSystem, Path path, SQLConf sQLConf) {
        FileStreamSink$.MODULE$.checkEscapedMetadataPath(fileSystem, path, sQLConf);
    }

    public static Path getMetadataLogPath(FileSystem fileSystem, Path path, SQLConf sQLConf) {
        return FileStreamSink$.MODULE$.getMetadataLogPath(fileSystem, path, sQLConf);
    }

    public static boolean hasMetadata(Seq<String> seq, Configuration configuration, SQLConf sQLConf) {
        return FileStreamSink$.MODULE$.hasMetadata(seq, configuration, sQLConf);
    }

    public static String metadataDir() {
        return FileStreamSink$.MODULE$.metadataDir();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String name() {
        return Sink.name$(this);
    }

    @Override
    public StructType schema() {
        return Sink.schema$(this);
    }

    @Override
    public Set<TableCapability> capabilities() {
        return Sink.capabilities$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private Path basePath() {
        return this.basePath;
    }

    private Path logPath() {
        return this.logPath;
    }

    private FileStreamSinkLog fileLog() {
        return this.fileLog;
    }

    private BasicWriteJobStatsTracker basicWriteJobStatsTracker() {
        SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.hadoopConf());
        return new BasicWriteJobStatsTracker(serializableHadoopConf, BasicWriteJobStatsTracker$.MODULE$.metrics());
    }

    @Override
    public void addBatch(long batchId, Dataset<Row> data) {
        if (batchId <= BoxesRunTime.unboxToLong((Object)this.fileLog().getLatest().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Skipping already committed batch ").append(batchId).toString());
        } else {
            FileCommitProtocol committer = FileCommitProtocol$.MODULE$.instantiate(this.sparkSession.sessionState().conf().streamingFileCommitProtocolClass(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString(), this.path, FileCommitProtocol$.MODULE$.instantiate$default$4());
            FileCommitProtocol fileCommitProtocol = committer;
            if (fileCommitProtocol instanceof ManifestFileCommitProtocol) {
                ManifestFileCommitProtocol manifestFileCommitProtocol = (ManifestFileCommitProtocol)fileCommitProtocol;
                manifestFileCommitProtocol.setupManifestOptions(this.fileLog(), batchId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Seq partitionColumns = (Seq)this.partitionColumnNames.map((Function1 & Serializable & scala.Serializable)col -> {
                Function2 nameEquality = data.sparkSession().sessionState().conf().resolver();
                return (Attribute)data.logicalPlan().output().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink.$anonfun$addBatch$5(nameEquality, col, f))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new RuntimeException(new StringBuilder(38).append("Partition column ").append((String)col).append(" not found in schema ").append(data.schema()).toString());
                });
            }, Seq$.MODULE$.canBuildFrom());
            QueryExecution qe = data.queryExecution();
            FileFormatWriter$.MODULE$.write(this.sparkSession, qe.executedPlan(), this.fileFormat, committer, new FileFormatWriter.OutputSpec(this.path, (Map<Map<String, String>, String>)Predef$.MODULE$.Map().empty(), (Seq<Attribute>)qe.analyzed().output()), this.hadoopConf(), (Seq<Attribute>)partitionColumns, (Option<BucketSpec>)None$.MODULE$, (Seq<WriteJobStatsTracker>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BasicWriteJobStatsTracker[]{this.basicWriteJobStatsTracker()}))), this.options);
        }
    }

    public String toString() {
        return new StringBuilder(10).append("FileSink[").append(this.path).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$addBatch$5(Function2 nameEquality$1, String col$1, Attribute f) {
        return BoxesRunTime.unboxToBoolean((Object)nameEquality$1.apply((Object)f.name(), (Object)col$1));
    }

    public FileStreamSink(SparkSession sparkSession, String path, FileFormat fileFormat, Seq<String> partitionColumnNames, Map<String, String> options) {
        this.sparkSession = sparkSession;
        this.path = path;
        this.fileFormat = fileFormat;
        this.partitionColumnNames = partitionColumnNames;
        this.options = options;
        Sink.$init$(this);
        Logging.$init$((Logging)this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.basePath = new Path(path);
        this.logPath = FileStreamSink$.MODULE$.getMetadataLogPath(this.basePath().getFileSystem(this.hadoopConf()), this.basePath(), sparkSession.sessionState().conf());
        this.fileLog = new FileStreamSinkLog(FileStreamSinkLog$.MODULE$.VERSION(), sparkSession, this.logPath().toString());
    }
}

