/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001\u0002\u00192\u0001qB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u0011\u0002!\t!\u0013\u0005\u0006\u001b\u0002!IA\u0014\u0005\u0006-\u0002!Ia\u0016\u0005\u0006W\u0002!I\u0001\u001c\u0005\u0006a\u0002!\t%\u001d\u0005\u0006e\u0002!\te\u001d\u0005\u0006}\u0002!\te \u0005\b\u0003\u001b\u0001A\u0011BA\b\u0011\u001d\t\u0019\u0002\u0001C!\u0003+Aq!a\u0005\u0001\t\u0003\ny\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005U\u0002\u0001\"\u0011\u00028!9\u0011Q\u0007\u0001\u0005B\u0005\u0005\u0003bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003+\u0002A\u0011IA,\u0011\u001d\t)\u0006\u0001C!\u0003SBq!!\u0016\u0001\t\u0013\t)\bC\u0004\u0002|\u0001!\t%! \t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011\u0011\u0011\u0001\u0005B\u0005\u001d\u0005bBAG\u0001\u0011\u0005\u0013q\u0012\u0005\b\u0003\u001b\u0003A\u0011IAK\u0011\u001d\tY\n\u0001C!\u0003;Cq!a*\u0001\t\u0003\nI\u000bC\u0004\u0002(\u0002!\t%!,\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u00111\u0017\u0001\u0005B\u0005e\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003\u007f\u0003A\u0011IAt\u0011\u001d\ty\f\u0001C!\u0003cDq!a0\u0001\t\u0003\u0012\t\u0001C\u0004\u0003\u001a\u0001!\tEa\u0007\t\u000f\t\u0005\u0002\u0001\"\u0011\u0003$!9!q\u0005\u0001\u0005B\t%\u0002b\u0002B\u0017\u0001\u0011\u0005#q\u0006\u0005\b\u0005g\u0001A\u0011\tB\u001b\u0011\u001d\u0011\u0019\u0004\u0001C!\u0005sAqA!\u0014\u0001\t\u0003\u0012y\u0005C\u0004\u0003T\u0001!\tE!\u0016\t\u0011\t5\u0002\u0001\"\u00054\u0005/BqAa\u001e\u0001\t\u0003\u0012I\bC\u0004\u0003~\u0001!\tEa \b\u0011\t\u0015\u0015\u0007#\u00014\u0005\u000f3q\u0001M\u0019\t\u0002M\u0012I\t\u0003\u0004I[\u0011\u0005!\u0011\u0013\u0005\b\u0005'kC\u0011\u0001BK\u0005-\u0019\u0015\r^1m_\u001eLU\u000e\u001d7\u000b\u0005I\u001a\u0014\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Q*\u0014aA:rY*\u0011agN\u0001\u0006gB\f'o\u001b\u0006\u0003qe\na!\u00199bG\",'\"\u0001\u001e\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001i\u0004C\u0001 B\u001b\u0005y$B\u0001!4\u0003\u001d\u0019\u0017\r^1m_\u001eL!AQ \u0003\u000f\r\u000bG/\u00197pO\u0006a1\u000f]1sWN+7o]5p]B\u0011QIR\u0007\u0002g%\u0011qi\r\u0002\r'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005)c\u0005CA&\u0001\u001b\u0005\t\u0004\"B\"\u0003\u0001\u0004!\u0015AD:fgNLwN\\\"bi\u0006dwnZ\u000b\u0002\u001fB\u0011\u0001\u000bV\u0007\u0002#*\u0011\u0001I\u0015\u0006\u0003'N\n\u0001bY1uC2L8\u000f^\u0005\u0003+F\u0013abU3tg&|gnQ1uC2|w-A\u000bsKF,\u0018N]3ECR\f'-Y:f\u000bbL7\u000f^:\u0015\u0005as\u0006CA-]\u001b\u0005Q&\"A.\u0002\u000bM\u001c\u0017\r\\1\n\u0005uS&\u0001B+oSRDQa\u0018\u0003A\u0002\u0001\fa\u0001\u001a2OC6,\u0007CA1i\u001d\t\u0011g\r\u0005\u0002d56\tAM\u0003\u0002fw\u00051AH]8pizJ!a\u001a.\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003Oj\u000b!C]3rk&\u0014X\rV1cY\u0016,\u00050[:ugR\u0019\u0001,\u001c8\t\u000b}+\u0001\u0019\u00011\t\u000b=,\u0001\u0019\u00011\u0002\u0013Q\f'\r\\3OC6,\u0017aD2veJ,g\u000e\u001e#bi\u0006\u0014\u0017m]3\u0016\u0003\u0001\f!c]3u\u0007V\u0014(/\u001a8u\t\u0006$\u0018MY1tKR\u0011\u0001\f\u001e\u0005\u0006?\u001e\u0001\r\u0001\u0019\u0015\u0004\u000fYd\bcA-xs&\u0011\u0001P\u0017\u0002\u0007i\"\u0014xn^:\u0011\u0005\u0015S\u0018BA>4\u0005E\te.\u00197zg&\u001cX\t_2faRLwN\\\u0011\u0002{\u00069B-\u0019;bE\u0006\u001cX\r\t3pKN\u0004cn\u001c;!KbL7\u000f^\u0001\u000eY&\u001cH\u000fR1uC\n\f7/Z:\u0015\u0005\u0005\u0005\u0001#B#\u0002\u0004\u0005\u001d\u0011bAA\u0003g\t9A)\u0019;bg\u0016$\bc\u0001 \u0002\n%\u0019\u00111B \u0003\u0011\u0011\u000bG/\u00192bg\u0016\fA\"\\1lK\u0012\u000bG/\u00192bg\u0016$B!a\u0002\u0002\u0012!)q,\u0003a\u0001A\u0006QA.[:u)\u0006\u0014G.Z:\u0015\u0005\u0005]\u0001#B#\u0002\u0004\u0005e\u0001c\u0001 \u0002\u001c%\u0019\u0011QD \u0003\u000bQ\u000b'\r\\3\u0015\t\u0005]\u0011\u0011\u0005\u0005\u0006?.\u0001\r\u0001\u0019\u0015\u0004\u0017Yd\u0018!C7bW\u0016$\u0016M\u00197f)\u0011\tI\"!\u000b\t\u000f\u0005-B\u00021\u0001\u0002.\u0005QA/\u00192mK&#WM\u001c;\u0011\t\u0005=\u0012\u0011G\u0007\u0002%&\u0019\u00111\u0007*\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fQ\u0002\\5ti\u001a+hn\u0019;j_:\u001cHCAA\u001d!\u0015)\u00151AA\u001e!\rq\u0014QH\u0005\u0004\u0003\u007fy$\u0001\u0003$v]\u000e$\u0018n\u001c8\u0015\t\u0005e\u00121\t\u0005\u0006?:\u0001\r\u0001\u0019\u0015\u0004\u001dYd\u0018\u0001D7bW\u00164UO\\2uS>tG\u0003BA\u001e\u0003\u0017Bq!!\u0014\u0010\u0001\u0004\ty%A\u0005gk:\u001c\u0017\nZ3oiB!\u0011qFA)\u0013\r\t\u0019F\u0015\u0002\u0013\rVt7\r^5p]&#WM\u001c;jM&,'/A\u0006mSN$8i\u001c7v[:\u001cH\u0003BA-\u0003C\u0002R!RA\u0002\u00037\u00022APA/\u0013\r\tyf\u0010\u0002\u0007\u0007>dW/\u001c8\t\u000b=\u0004\u0002\u0019\u00011)\tA1\u0018QM\u0011\u0003\u0003O\nA\u0003^1cY\u0016\u0004Cm\\3tA9|G\u000fI3ySN$HCBA-\u0003W\ni\u0007C\u0003`#\u0001\u0007\u0001\rC\u0003p#\u0001\u0007\u0001\r\u000b\u0003\u0012m\u0006E\u0014EAA:\u0003\u0001\"\u0017\r^1cCN,\u0007e\u001c:!i\u0006\u0014G.\u001a\u0011e_\u0016\u001c\bE\\8uA\u0015D\u0018n\u001d;\u0015\t\u0005e\u0013q\u000f\u0005\b\u0003s\u0012\u0002\u0019AA\u0017\u0003=!\u0018M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\u0018aC4fi\u0012\u000bG/\u00192bg\u0016$B!a\u0002\u0002\u0000!)ql\u0005a\u0001A\u0006Aq-\u001a;UC\ndW\r\u0006\u0003\u0002\u001a\u0005\u0015\u0005\"B8\u0015\u0001\u0004\u0001GCBA\r\u0003\u0013\u000bY\tC\u0003`+\u0001\u0007\u0001\rC\u0003p+\u0001\u0007\u0001-A\u0006hKR4UO\\2uS>tG\u0003BA\u001e\u0003#Ca!a%\u0017\u0001\u0004\u0001\u0017\u0001\u00044v]\u000e$\u0018n\u001c8OC6,GCBA\u001e\u0003/\u000bI\nC\u0003`/\u0001\u0007\u0001\r\u0003\u0004\u0002\u0014^\u0001\r\u0001Y\u0001\u000fI\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\u0011\ty*!*\u0011\u0007e\u000b\t+C\u0002\u0002$j\u0013qAQ8pY\u0016\fg\u000eC\u0003`1\u0001\u0007\u0001-A\u0006uC\ndW-\u0012=jgR\u001cH\u0003BAP\u0003WCQa\\\rA\u0002\u0001$b!a(\u00020\u0006E\u0006\"B0\u001b\u0001\u0004\u0001\u0007\"B8\u001b\u0001\u0004\u0001\u0017A\u00044v]\u000e$\u0018n\u001c8Fq&\u001cHo\u001d\u000b\u0005\u0003?\u000b9\f\u0003\u0004\u0002\u0014n\u0001\r\u0001\u0019\u000b\u0007\u0003?\u000bY,!0\t\u000b}c\u0002\u0019\u00011\t\r\u0005ME\u00041\u0001a\u0003-\u0019'/Z1uKR\u000b'\r\\3\u0015\r\u0005\r\u0017\u0011]Ar!\u0011\t)-a7\u000f\t\u0005\u001d\u0017q\u001b\b\u0005\u0003\u0013\f)N\u0004\u0003\u0002L\u0006Mg\u0002BAg\u0003#t1aYAh\u0013\u0005Q\u0014B\u0001\u001d:\u0013\t1t'\u0003\u00025k%\u0019\u0011\u0011\\\u001a\u0002\u000fA\f7m[1hK&!\u0011Q\\Ap\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002ZNBQa\\\u000fA\u0002\u0001Da!!:\u001e\u0001\u0004\u0001\u0017\u0001\u00029bi\"$\u0002\"a1\u0002j\u0006-\u0018Q\u001e\u0005\u0006_z\u0001\r\u0001\u0019\u0005\u0007\u0003Kt\u0002\u0019\u00011\t\r\u0005=h\u00041\u0001a\u0003\u0019\u0019x.\u001e:dKRA\u00111YAz\u0003k\f9\u0010C\u0003p?\u0001\u0007\u0001\r\u0003\u0004\u0002p~\u0001\r\u0001\u0019\u0005\b\u0003s|\u0002\u0019AA~\u0003\u001dy\u0007\u000f^5p]N\u0004R!YA\u007fA\u0002L1!a@k\u0005\ri\u0015\r\u001d\u000b\u000b\u0003\u0007\u0014\u0019A!\u0002\u0003\b\t]\u0001\"B8!\u0001\u0004\u0001\u0007BBAxA\u0001\u0007\u0001\rC\u0004\u0003\n\u0001\u0002\rAa\u0003\u0002\rM\u001c\u0007.Z7b!\u0011\u0011iAa\u0005\u000e\u0005\t=!b\u0001B\tg\u0005)A/\u001f9fg&!!Q\u0003B\b\u0005)\u0019FO];diRK\b/\u001a\u0005\b\u0003s\u0004\u0003\u0019AA~\u00031!'o\u001c9UK6\u0004h+[3x)\u0011\tyJ!\b\t\r\t}\u0011\u00051\u0001a\u0003!1\u0018.Z<OC6,\u0017A\u00053s_B<En\u001c2bYR+W\u000e\u001d,jK^$B!a(\u0003&!1!q\u0004\u0012A\u0002\u0001\f\u0011C]3d_Z,'\u000fU1si&$\u0018n\u001c8t)\rA&1\u0006\u0005\u0006_\u000e\u0002\r\u0001Y\u0001\tSN\u001c\u0015m\u00195fIR!\u0011q\u0014B\u0019\u0011\u0015yG\u00051\u0001a\u0003)\u0019\u0017m\u00195f)\u0006\u0014G.\u001a\u000b\u00041\n]\u0002\"B8&\u0001\u0004\u0001G#\u0002-\u0003<\tu\u0002\"B8'\u0001\u0004\u0001\u0007b\u0002B M\u0001\u0007!\u0011I\u0001\rgR|'/Y4f\u0019\u00164X\r\u001c\t\u0005\u0005\u0007\u0012I%\u0004\u0002\u0003F)\u0019!qI\u001b\u0002\u000fM$xN]1hK&!!1\nB#\u00051\u0019Fo\u001c:bO\u0016dUM^3m\u00031)hnY1dQ\u0016$\u0016M\u00197f)\rA&\u0011\u000b\u0005\u0006_\u001e\u0002\r\u0001Y\u0001\u000bG2,\u0017M]\"bG\",G#\u0001-\u0015\t\u0005}%\u0011\f\u0005\b\u00057J\u0003\u0019\u0001B/\u0003\u0015\th*Y7fa\u0011\u0011yF!\u001a\u0011\u000b\u0015\u000b\u0019A!\u0019\u0011\t\t\r$Q\r\u0007\u0001\t1\u00119G!\u0017\u0002\u0002\u0003\u0005)\u0011\u0001B5\u0005\ryF%M\t\u0005\u0005W\u0012\t\bE\u0002Z\u0005[J1Aa\u001c[\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\u0017B:\u0013\r\u0011)H\u0017\u0002\u0004\u0003:L\u0018\u0001\u0004:fMJ,7\u000f\u001b+bE2,Gc\u0001-\u0003|!)qN\u000ba\u0001A\u0006i!/\u001a4sKND')\u001f)bi\"$2\u0001\u0017BA\u0011\u0019\u0011\u0019i\u000ba\u0001A\u0006a!/Z:pkJ\u001cW\rU1uQ\u0006Y1)\u0019;bY><\u0017*\u001c9m!\tYUfE\u0002.\u0005\u0017\u00032!\u0017BG\u0013\r\u0011yI\u0017\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u001d\u0015aC7bW\u0016$\u0015\r^1tKR,BAa&\u0003 R1!\u0011\u0014Bo\u0005[$BAa'\u0003,B)Q)a\u0001\u0003\u001eB!!1\rBP\t\u001d\u0011\tk\fb\u0001\u0005G\u0013\u0011\u0001V\t\u0005\u0005W\u0012)\u000b\u0005\u0003\u00020\t\u001d\u0016b\u0001BU%\nQB)\u001a4j]\u0016$')_\"p]N$(/^2u_J\u0004\u0016M]1ng\"I!QV\u0018\u0002\u0002\u0003\u000f!qV\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004C\u0002BY\u0005#\u0014iJ\u0004\u0003\u00034\n-g\u0002\u0002B[\u0005\u000ftAAa.\u0003B:!!\u0011\u0018B_\u001d\r\u0019'1X\u0005\u00027&\u0019!q\u0018.\u0002\u000fI,g\r\\3di&!!1\u0019Bc\u0003\u001d\u0011XO\u001c;j[\u0016T1Aa0[\u0013\u0011\tIN!3\u000b\t\t\r'QY\u0005\u0005\u0005\u001b\u0014y-\u0001\u0005v]&4XM]:f\u0015\u0011\tIN!3\n\t\tM'Q\u001b\u0002\b)f\u0004X\rV1h\u0013\u0011\u00119N!7\u0003\u0011QK\b/\u001a+bONTAAa7\u0003F\u0006\u0019\u0011\r]5\t\u000f\t}w\u00061\u0001\u0003b\u0006!A-\u0019;b!\u0019\u0011\u0019Oa:\u0003\u001e:!!\u0011\u0018Bs\u0013\r\tINW\u0005\u0005\u0005S\u0014YOA\u0002TKFT1!!7[\u0011\u0015\u0019u\u00061\u0001E\u0001")
public class CatalogImpl
extends Catalog {
    private final SparkSession sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    private SessionCatalog sessionCatalog() {
        return this.sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (!this.sessionCatalog().databaseExists(dbName)) {
            throw new AnalysisException(new StringBuilder(27).append("Database '").append(dbName).append("' does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void requireTableExists(String dbName, String tableName) {
        if (!this.sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            throw new AnalysisException(new StringBuilder(39).append("Table '").append(tableName).append("' does not exist in database '").append(dbName).append("'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public String currentDatabase() {
        return this.sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.sessionCatalog().listDatabases().map((Function1 & Serializable & scala.Serializable)dbName -> this.makeDatabase((String)dbName), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(null)));
    }

    private Database makeDatabase(String dbName) {
        CatalogDatabase metadata = this.sessionCatalog().getDatabaseMetadata(dbName);
        return new Database(metadata.name(), metadata.description(), CatalogUtils$.MODULE$.URIToString(metadata.locationUri()));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        Seq tables = (Seq)this.sessionCatalog().listTables(dbName).map((Function1 & Serializable & scala.Serializable)tableIdent -> this.makeTable((TableIdentifier)tableIdent), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(null)));
    }

    private Table makeTable(TableIdentifier tableIdent) {
        Some some;
        try {
            some = new Some((Object)this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        Some metadata = some;
        boolean isTemp = this.sessionCatalog().isTemporaryTable(tableIdent);
        return new Table(tableIdent.table(), (String)((Option)metadata.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().database()).getOrElse((Function0 & Serializable & scala.Serializable)() -> tableIdent.database())).orNull(Predef$.MODULE$.$conforms()), (String)metadata.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.comment().orNull(Predef$.MODULE$.$conforms())).orNull(Predef$.MODULE$.$conforms()), isTemp ? "TEMPORARY" : (String)metadata.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tableType().name()).orNull(Predef$.MODULE$.$conforms()), isTemp);
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.sessionCatalog().listFunctions(dbName).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FunctionIdentifier functIdent = (FunctionIdentifier)tuple2._1();
            Function function = this.makeFunction(functIdent);
            return function;
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(null)));
    }

    private Function makeFunction(FunctionIdentifier funcIdent) {
        ExpressionInfo metadata = this.sessionCatalog().lookupFunctionInfo(funcIdent);
        return new Function(metadata.getName(), metadata.getDb(), null, metadata.getClassName(), metadata.getDb() == null);
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.listColumns(tableIdent);
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = ((TraversableOnce)tableMetadata.bucketSpec().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.bucketColumnNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).toSet();
        Seq columns = (Seq)tableMetadata.schema().map((Function1 & Serializable & scala.Serializable)c -> new Column(c.name(), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()), c.dataType().catalogString(), c.nullable(), partitionColumnNames.contains((Object)c.name()), bucketColumnNames.contains((Object)c.name())), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(null)));
    }

    @Override
    public Database getDatabase(String dbName) {
        return this.makeDatabase(dbName);
    }

    @Override
    public Table getTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.getTable((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        if (!this.tableExists(dbName, tableName)) {
            throw new AnalysisException(new StringBuilder(41).append("Table or view '").append(tableName).append("' not found in database '").append(dbName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.makeTable(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Function getFunction(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.getFunction((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public Function getFunction(String dbName, String functionName) {
        return this.makeFunction(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.sessionCatalog().databaseExists(dbName);
    }

    @Override
    public boolean tableExists(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.tableExists((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public boolean tableExists(String dbName, String tableName) {
        TableIdentifier tableIdent = new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName));
        return this.sessionCatalog().isTemporaryTable(tableIdent) || this.sessionCatalog().tableExists(tableIdent);
    }

    @Override
    public boolean functionExists(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.functionExists((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public boolean functionExists(String dbName, String functionName) {
        return this.sessionCatalog().functionExists(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Dataset<Row> createTable(String tableName, String path) {
        String dataSourceName = this.sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createTable(tableName, path, dataSourceName);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String path, String source) {
        return this.createTable(tableName, source, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), options);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, StructType schema, Map<String, String> options) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions(options);
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, schema, (Option)new Some((Object)source), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19(), CatalogTable$.MODULE$.apply$default$20());
        CreateTable plan = new CreateTable(tableDesc, SaveMode.ErrorIfExists, (Option<LogicalPlan>)None$.MODULE$);
        this.sparkSession.sessionState().executePlan(plan).toRdd();
        return this.sparkSession.table(tableIdent);
    }

    @Override
    public boolean dropTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropTempView$1(this, viewName, viewDef)));
    }

    @Override
    public boolean dropGlobalTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getGlobalTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropGlobalTempView$1(this, viewName, viewDef)));
    }

    @Override
    public void recoverPartitions(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.sparkSession.sessionState().executePlan(new AlterTableRecoverPartitionsCommand(tableIdent, AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2())).toRdd();
    }

    @Override
    public boolean isCached(String tableName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(this.sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void cacheTable(String tableName, StorageLevel storageLevel) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), storageLevel);
    }

    @Override
    public void uncacheTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        boolean cascade = !this.sessionCatalog().isTemporaryTable(tableIdent);
        this.sparkSession.sharedState().cacheManager().uncacheQuery(this.sparkSession.table(tableName), cascade);
    }

    @Override
    public void clearCache() {
        this.sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        block2: {
            TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
            CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent);
            Dataset<Row> table = this.sparkSession.table(tableIdent);
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                table.queryExecution().analyzed().refresh();
            } else {
                this.sessionCatalog().refreshTable(tableIdent);
            }
            Option<CachedData> cache = this.sparkSession.sharedState().cacheManager().lookupCachedData(table);
            this.sparkSession.sharedState().cacheManager().uncacheQuery(table, true);
            if (!cache.nonEmpty()) break block2;
            Option<String> cacheName = ((CachedData)cache.get()).cachedRepresentation().cacheBuilder().tableName();
            StorageLevel cacheLevel = ((CachedData)cache.get()).cachedRepresentation().cacheBuilder().storageLevel();
            this.sparkSession.sharedState().cacheManager().cacheQuery(table, cacheName, cacheLevel);
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.sparkSession.sharedState().cacheManager().recacheByPath(this.sparkSession, resourcePath);
    }

    public static final /* synthetic */ boolean $anonfun$dropTempView$1(CatalogImpl $this, String viewName$1, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, $this.sparkSession.sharedState().cacheManager().uncacheQuery$default$4());
        return $this.sessionCatalog().dropTempView(viewName$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropGlobalTempView$1(CatalogImpl $this, String viewName$2, LogicalPlan viewDef) {
        $this.sparkSession.sharedState().cacheManager().uncacheQuery($this.sparkSession, viewDef, false, $this.sparkSession.sharedState().cacheManager().uncacheQuery$default$4());
        return $this.sessionCatalog().dropGlobalTempView(viewName$2);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }
}

