/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser.ui.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.ui.swing.AJButtonMenuCombo;
import org.aspectj.ajde.ui.swing.BuildConfigPopupMenu;
import org.aspectj.ajde.ui.swing.MultiStructureViewPanel;
import org.aspectj.asm.IProgramElement;
import org.aspectj.tools.ajbrowser.BrowserManager;
import org.aspectj.tools.ajbrowser.ui.BrowserMessageHandler;
import org.aspectj.tools.ajbrowser.ui.EditorManager;
import org.aspectj.tools.ajbrowser.ui.swing.MessageHandlerPanel;

public class TopFrame
extends JFrame {
    private static final long serialVersionUID = 1007473581156451702L;
    private static final File CURRENT_DIR = new File(".");
    public JLabel statusText_label = new JLabel();
    private JPanel editor_panel = null;
    private JPanel sourceEditor_panel = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu jMenu1 = new JMenu();
    private JMenu jMenu2 = new JMenu();
    private JMenuItem projectBuild_menuItem = new JMenuItem();
    private FlowLayout left_flowLayout = new FlowLayout();
    private JMenuItem jMenuItem1 = new JMenuItem();
    private JMenuItem exit_menuItem = new JMenuItem();
    private JSplitPane top_splitPane = new JSplitPane();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JMenuItem projectRun_menuItem = new JMenuItem();
    private JMenuItem projectRunOther_menuItem = new JMenuItem();
    private JPanel status_panel = new JPanel();
    private BorderLayout borderLayout4 = new BorderLayout();
    private Border emptyBorder = BorderFactory.createEmptyBorder();
    private JPanel toolbar_panel = new JPanel();
    private JSplitPane right_splitPane = new JSplitPane();
    private MessageHandlerPanel messages_panel = null;
    private JMenu tools_menu = new JMenu();
    private JMenuItem joinpointProbe_menuItem = new JMenuItem();
    private JMenuItem projectDebug_menuItem = new JMenuItem();
    private JMenuItem svProperties_menuItem = new JMenuItem();
    private File lastChosenDir = CURRENT_DIR;
    JPanel toolBar_panel = new JPanel();
    JToolBar build_toolBar = new JToolBar();
    JButton closeConfig_button = new JButton();
    JButton openConfig_button = new JButton();
    JButton run_button = new JButton();
    JToolBar project_toolBar = new JToolBar();
    JButton save_button = new JButton();
    JButton options_button = new JButton();
    JButton editConfig_button = new JButton();
    JToolBar file_toolBar = new JToolBar();
    JPanel filler_panel = new JPanel();
    BorderLayout borderLayout5 = new BorderLayout();
    BorderLayout borderLayout6 = new BorderLayout();
    Border border8;
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JPanel multiView_panel;
    private AJButtonMenuCombo buildCombo;

    public void init(MultiStructureViewPanel multiViewPanel, MessageHandlerPanel compilerMessagesPanel, JPanel editorPanel) {
        try {
            this.multiView_panel = multiViewPanel;
            this.messages_panel = compilerMessagesPanel;
            this.editor_panel = editorPanel;
            this.sourceEditor_panel = editorPanel;
            this.jbInit();
            this.svProperties_menuItem.setIcon(Ajde.getDefault().getIconRegistry().getBrowserOptionsIcon());
            this.projectBuild_menuItem.setIcon(Ajde.getDefault().getIconRegistry().getBuildIcon());
            this.projectRun_menuItem.setIcon(Ajde.getDefault().getIconRegistry().getExecuteIcon());
            this.projectRunOther_menuItem.setIcon(Ajde.getDefault().getIconRegistry().getExecuteIcon());
            this.projectDebug_menuItem.setIcon(Ajde.getDefault().getIconRegistry().getDebugIcon());
            this.setJMenuBar(this.menuBar);
            this.setIconImage(((ImageIcon)Ajde.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.ADVICE)).getImage());
            this.setLocation(75, 10);
            this.setSize(900, 650);
            this.setTitle("AspectJ Browser");
            this.fixButtonBorders();
            this.messages_panel.setVisible(false);
            BuildConfigPopupMenu orderMenu = new BuildConfigPopupMenu(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    BrowserManager.getDefault().saveAll();
                }
            });
            this.buildCombo = new AJButtonMenuCombo("Build", "Build", Ajde.getDefault().getIconRegistry().getBuildIcon(), orderMenu, false);
            this.build_toolBar.add((Component)this.buildCombo, 1);
            this.refreshBuildMenu();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void refreshBuildMenu() {
        BuildConfigPopupMenu orderMenu = new BuildConfigPopupMenu(new AbstractAction(){
            private static final long serialVersionUID = -3204840278758386318L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                BrowserManager.getDefault().saveAll();
            }
        });
        this.buildCombo.setMenu(orderMenu);
    }

    public void setEditorPanel(JPanel panel) {
        this.editor_panel = panel;
        this.right_splitPane.remove(this.editor_panel);
        this.right_splitPane.add((Component)panel, "top");
        panel.setVisible(true);
    }

    private void fixButtonBorders() {
        this.run_button.setBorder(null);
        this.options_button.setBorder(null);
        this.openConfig_button.setBorder(null);
        this.closeConfig_button.setBorder(null);
        this.save_button.setBorder(null);
        this.editConfig_button.setBorder(null);
    }

    private void jbInit() throws Exception {
        this.border8 = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(Color.white, new Color(156, 156, 158)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.emptyBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.jMenu1.setFont(new Font("Dialog", 0, 11));
        this.jMenu1.setText("File");
        this.jMenu1.setMnemonic(70);
        this.jMenu2.setFont(new Font("Dialog", 0, 11));
        this.jMenu2.setText("Project");
        this.jMenu2.setMnemonic(80);
        this.projectBuild_menuItem.setFont(new Font("Dialog", 0, 11));
        this.projectBuild_menuItem.setText("Build");
        this.projectBuild_menuItem.setMnemonic(66);
        this.projectBuild_menuItem.setAccelerator(KeyStroke.getKeyStroke(66, 8));
        this.projectBuild_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.projectBuild_menuItem_actionPerformed(e);
            }
        });
        this.left_flowLayout.setAlignment(0);
        this.jMenuItem1.setFont(new Font("Dialog", 0, 11));
        this.jMenuItem1.setText("Save");
        this.jMenuItem1.setMnemonic(83);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(83, 8));
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.exit_menuItem.setFont(new Font("Dialog", 0, 11));
        this.exit_menuItem.setText("Exit");
        this.exit_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.exit_menuItem_actionPerformed(e);
            }
        });
        this.top_splitPane.setPreferredSize(new Dimension(706, 800));
        this.top_splitPane.setDividerSize(4);
        this.getContentPane().setLayout(this.borderLayout3);
        this.projectRun_menuItem.setEnabled(true);
        this.projectRun_menuItem.setFont(new Font("Dialog", 0, 11));
        this.projectRun_menuItem.setText("Run in same VM");
        this.projectRun_menuItem.setToolTipText("Run in same VM (hold shift down to run in separate process)");
        this.projectRun_menuItem.setMnemonic(82);
        this.projectRun_menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 8));
        this.projectRun_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.projectRun_menuItem_actionPerformed(e);
            }
        });
        this.projectRunOther_menuItem.setEnabled(true);
        this.projectRunOther_menuItem.setFont(new Font("Dialog", 0, 11));
        this.projectRunOther_menuItem.setText("Run in separate process");
        this.projectRunOther_menuItem.setMnemonic(80);
        this.projectRunOther_menuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        this.projectRunOther_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.projectRunOther_menuItem_actionPerformed(e);
            }
        });
        this.statusText_label.setFont(new Font("Dialog", 0, 11));
        this.statusText_label.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusText_label.setMaximumSize(new Dimension(2000, 20));
        this.statusText_label.setPreferredSize(new Dimension(300, 20));
        this.status_panel.setLayout(this.borderLayout4);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                TopFrame.this.this_windowClosed(e);
            }

            @Override
            public void windowClosing(WindowEvent e) {
                TopFrame.this.this_windowClosing(e);
            }
        });
        this.toolbar_panel.setLayout(this.borderLayout5);
        this.right_splitPane.setOrientation(0);
        this.right_splitPane.setBorder(null);
        this.right_splitPane.setDividerSize(4);
        this.tools_menu.setFont(new Font("Dialog", 0, 11));
        this.tools_menu.setText("Tools");
        this.tools_menu.setMnemonic(84);
        this.projectDebug_menuItem.setEnabled(false);
        this.projectDebug_menuItem.setFont(new Font("Dialog", 0, 11));
        this.projectDebug_menuItem.setText("Debug");
        this.svProperties_menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.svProperties_menuItem_actionPerformed(e);
            }
        });
        this.svProperties_menuItem.setText("Options...");
        this.svProperties_menuItem.setActionCommand("AJDE Console...");
        this.svProperties_menuItem.setFont(new Font("Dialog", 0, 11));
        this.svProperties_menuItem.setMnemonic(79);
        this.svProperties_menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.build_toolBar.setBorder(this.emptyBorder);
        this.build_toolBar.setFloatable(false);
        this.closeConfig_button.setMaximumSize(new Dimension(100, 20));
        this.closeConfig_button.setEnabled(true);
        this.closeConfig_button.setFont(new Font("Dialog", 0, 11));
        this.closeConfig_button.setBorder(null);
        this.closeConfig_button.setMinimumSize(new Dimension(24, 20));
        this.closeConfig_button.setPreferredSize(new Dimension(20, 20));
        this.closeConfig_button.setToolTipText("Close build configuration");
        this.closeConfig_button.setIcon(Ajde.getDefault().getIconRegistry().getCloseConfigIcon());
        this.closeConfig_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.closeConfig_button_actionPerformed(e);
            }
        });
        this.openConfig_button.setMaximumSize(new Dimension(100, 20));
        this.openConfig_button.setEnabled(true);
        this.openConfig_button.setFont(new Font("Dialog", 0, 11));
        this.openConfig_button.setBorder(null);
        this.openConfig_button.setMinimumSize(new Dimension(24, 20));
        this.openConfig_button.setPreferredSize(new Dimension(20, 20));
        this.openConfig_button.setToolTipText("Select build configuration...");
        this.openConfig_button.setIcon(Ajde.getDefault().getIconRegistry().getOpenConfigIcon());
        this.openConfig_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.openConfig_button_actionPerformed(e);
            }
        });
        this.run_button.setMaximumSize(new Dimension(60, 20));
        this.run_button.setEnabled(true);
        this.run_button.setFont(new Font("Dialog", 0, 11));
        this.run_button.setBorder(null);
        this.run_button.setMinimumSize(new Dimension(24, 20));
        this.run_button.setPreferredSize(new Dimension(20, 20));
        this.run_button.setToolTipText("Run in same VM (hold shift down to run in separate process)");
        this.run_button.setIcon(Ajde.getDefault().getIconRegistry().getExecuteIcon());
        this.run_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.run_button_actionPerformed(e);
            }
        });
        this.project_toolBar.setBorder(this.emptyBorder);
        this.save_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.save_button_actionPerformed(e);
            }
        });
        this.save_button.setIcon(Ajde.getDefault().getIconRegistry().getSaveIcon());
        this.save_button.setText("Save");
        this.save_button.setToolTipText("Save");
        this.save_button.setPreferredSize(new Dimension(55, 20));
        this.save_button.setMinimumSize(new Dimension(24, 20));
        this.save_button.setFont(new Font("Dialog", 0, 11));
        this.save_button.setBorder(null);
        this.save_button.setMaximumSize(new Dimension(60, 20));
        this.options_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.options_button_actionPerformed(e);
            }
        });
        this.options_button.setIcon(Ajde.getDefault().getIconRegistry().getBrowserOptionsIcon());
        this.options_button.setText("Options");
        this.options_button.setToolTipText("Options...");
        this.options_button.setPreferredSize(new Dimension(60, 20));
        this.options_button.setMinimumSize(new Dimension(24, 20));
        this.options_button.setFont(new Font("Dialog", 0, 11));
        this.options_button.setBorder(null);
        this.options_button.setMaximumSize(new Dimension(80, 20));
        this.editConfig_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopFrame.this.editConfig_button_actionPerformed(e);
            }
        });
        this.editConfig_button.setIcon(Ajde.getDefault().getIconRegistry().getStructureSwingIcon(IProgramElement.Kind.FILE_LST));
        this.editConfig_button.setText("Edit Config");
        this.editConfig_button.setToolTipText("Edit Config...");
        this.editConfig_button.setPreferredSize(new Dimension(80, 20));
        this.editConfig_button.setMinimumSize(new Dimension(24, 20));
        this.editConfig_button.setFont(new Font("Dialog", 0, 11));
        this.editConfig_button.setBorder(null);
        this.editConfig_button.setMaximumSize(new Dimension(80, 20));
        this.file_toolBar.setBorder(this.emptyBorder);
        this.toolBar_panel.setLayout(this.borderLayout6);
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText(" Build: ");
        this.jLabel2.setText("      Run: ");
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add((Component)this.top_splitPane, "Center");
        this.top_splitPane.add((Component)this.right_splitPane, "right");
        this.top_splitPane.add((Component)this.multiView_panel, "left");
        this.right_splitPane.add((Component)this.messages_panel, "bottom");
        this.right_splitPane.add((Component)this.editor_panel, "top");
        this.getContentPane().add((Component)this.status_panel, "South");
        this.status_panel.add((Component)this.statusText_label, "Center");
        this.getContentPane().add((Component)this.toolbar_panel, "North");
        this.toolbar_panel.add((Component)this.filler_panel, "Center");
        this.toolbar_panel.add((Component)this.toolBar_panel, "West");
        this.file_toolBar.add((Component)this.save_button, null);
        this.file_toolBar.add((Component)this.options_button, null);
        this.toolBar_panel.add((Component)this.build_toolBar, "West");
        this.toolBar_panel.add((Component)this.project_toolBar, "Center");
        this.project_toolBar.add((Component)this.jLabel2, null);
        this.project_toolBar.add((Component)this.run_button, null);
        this.build_toolBar.add((Component)this.jLabel1, null);
        this.build_toolBar.add((Component)this.openConfig_button, null);
        this.build_toolBar.add((Component)this.closeConfig_button, null);
        this.toolBar_panel.add((Component)this.file_toolBar, "East");
        this.menuBar.add(this.jMenu1);
        this.menuBar.add(this.jMenu2);
        this.menuBar.add(this.tools_menu);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.addSeparator();
        this.jMenu1.add(this.exit_menuItem);
        this.jMenu2.add(this.projectBuild_menuItem);
        this.jMenu2.add(this.projectRun_menuItem);
        this.jMenu2.add(this.projectRunOther_menuItem);
        this.tools_menu.add(this.joinpointProbe_menuItem);
        this.tools_menu.add(this.svProperties_menuItem);
        this.top_splitPane.setDividerLocation(380);
        this.right_splitPane.setDividerLocation(500);
        this.project_toolBar.addSeparator();
        this.project_toolBar.addSeparator();
    }

    private void exit_menuItem_actionPerformed(ActionEvent e) {
        this.quit();
    }

    private void this_windowClosing(WindowEvent e) {
        this.quit();
    }

    private void quit() {
        this.dispose();
        System.exit(0);
    }

    void treeMode_comboBox_actionPerformed(ActionEvent e) {
    }

    void save_button_actionPerformed(ActionEvent e) {
        BrowserManager.getDefault().getEditorManager().saveContents();
    }

    void this_windowClosed(WindowEvent e) {
        this.quit();
    }

    public void showMessagesPanel(BrowserMessageHandler handler) {
        this.right_splitPane.setDividerLocation(this.right_splitPane.getHeight() - 100);
        this.messages_panel.showMessageHandlerPanel(handler, true);
    }

    public void hideMessagesPanel(BrowserMessageHandler handler) {
        this.right_splitPane.setDividerLocation(this.right_splitPane.getHeight());
        this.messages_panel.showMessageHandlerPanel(handler, false);
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        BrowserManager.getDefault().getEditorManager().saveContents();
    }

    void projectBuild_menuItem_actionPerformed(ActionEvent e) {
        BrowserManager.getDefault().saveAll();
        if (EditorManager.isShiftDown(e.getModifiers())) {
            this.buildFresh();
        } else {
            this.build();
        }
    }

    void run_button_actionPerformed(ActionEvent e) {
        if (EditorManager.isShiftDown(e.getModifiers())) {
            this.runInNewVM();
        } else {
            this.runInSameVM();
        }
    }

    void projectRunOther_menuItem_actionPerformed(ActionEvent e) {
        this.runInNewVM();
    }

    void projectRun_menuItem_actionPerformed(ActionEvent e) {
        if (EditorManager.isShiftDown(e.getModifiers())) {
            this.runInNewVM();
        } else {
            this.runInSameVM();
        }
    }

    void build_button_actionPerformed(ActionEvent e) {
        BrowserManager.getDefault().saveAll();
        if (EditorManager.isShiftDown(e.getModifiers())) {
            this.buildFresh();
        } else {
            this.build();
        }
    }

    void options_button_actionPerformed(ActionEvent e) {
        Ajde.getDefault().showOptionsFrame();
    }

    void editConfig_button_actionPerformed(ActionEvent e) {
        BrowserManager.getDefault().openFile(Ajde.getDefault().getBuildConfigManager().getActiveConfigFile());
        this.refreshBuildMenu();
    }

    public void resetSourceEditorPanel() {
        this.right_splitPane.removeAll();
        this.right_splitPane.add((Component)this.sourceEditor_panel, "top");
    }

    private void svProperties_menuItem_actionPerformed(ActionEvent e) {
        Ajde.getDefault().showOptionsFrame();
    }

    private void openConfig_button_actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(this.lastChosenDir);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getPath().endsWith(".lst") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "AspectJ Build Configuration (*.lst)";
            }
        });
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File result = fileChooser.getSelectedFile();
            String path = result.getAbsolutePath();
            if (!Ajde.getDefault().getBuildConfigManager().getAllBuildConfigFiles().contains(path)) {
                Ajde.getDefault().getBuildConfigManager().getAllBuildConfigFiles().add(0, path);
            }
            Ajde.getDefault().getBuildConfigManager().setActiveConfigFile(path);
            this.lastChosenDir = result.getParentFile();
            if (null == this.lastChosenDir) {
                this.lastChosenDir = CURRENT_DIR;
            }
            this.refreshBuildMenu();
        }
    }

    private void closeConfig_button_actionPerformed(ActionEvent e) {
        Ajde.getDefault().getBuildConfigManager().getAllBuildConfigFiles().remove(Ajde.getDefault().getBuildConfigManager().getActiveConfigFile());
        if (!Ajde.getDefault().getBuildConfigManager().getAllBuildConfigFiles().isEmpty()) {
            Ajde.getDefault().getBuildConfigManager().setActiveConfigFile((String)Ajde.getDefault().getBuildConfigManager().getAllBuildConfigFiles().get(0));
        }
        this.refreshBuildMenu();
    }

    private void buildFresh() {
        Ajde.getDefault().runBuildInDifferentThread(Ajde.getDefault().getBuildConfigManager().getActiveConfigFile(), true);
    }

    private void build() {
        Ajde.getDefault().runBuildInDifferentThread(Ajde.getDefault().getBuildConfigManager().getActiveConfigFile(), false);
    }

    private void runInSameVM() {
        Ajde.getDefault().runInSameVM();
    }

    private void runInNewVM() {
        Ajde.getDefault().runInNewVM();
    }
}

