///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var CommandLink = /** @class */ (function () {
        function CommandLink() {
        }
        CommandLink.disableOnClick = function (data, showDots, linkText, linkProcessingText, linkGlyphicon, linkProcessingGlyphicon, hideGlyphicon, disableRenderRegionsIds) {
            var status = data.type === "error" ? "error" : data.status;
            // console.log(data.source.id);
            var $commandLink = $(document.getElementById(data.source.id));
            switch (status) {
                case "begin":// Before the ajax request is sent.
                    // console.log('ajax request begin');
                    $commandLink.addClass("disabled");
                    var $glyphicon = $commandLink.find(".butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphicon.hide();
                    }
                    if (linkProcessingGlyphicon.length > 0) {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-glyphicon butter-component-processing-spinner");
                        $glyphicon.addClass(linkProcessingGlyphicon);
                        if (linkProcessingText.length > 0 && linkGlyphicon.length === 0) {
                            // glyphicon only appears on ajax request
                            $glyphicon.addClass("butter-component-glyphicon-width-margin");
                        }
                    }
                    else {
                        $glyphicon.removeAttr("class");
                        $glyphicon.addClass("butter-component-spinner tiny butter-component-processing-spinner");
                    }
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").startDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "inline-block");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkProcessingText);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Disable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).show();
                    }
                    break;
                case "complete":// After the ajax response is arrived.
                    // console.log('ajax request complete');
                    break;
                case "success": // After update of HTML DOM based on ajax response..
                case "error":// After update of HTML DOM based on ajax response..
                    // console.log('ajax request success');
                    $commandLink.removeClass("disabled");
                    if (showDots) {
                        $commandLink.find(".butter-component-glyphicon-processing").stopDots();
                        $commandLink.find(".butter-component-glyphicon-processing").css("display", "none");
                        $commandLink.find(".butter-component-glyphicon-text").html(linkText ? linkText : "");
                    }
                    var $glyphiconError = $commandLink.find(".butter-component-processing-spinner");
                    $glyphiconError.removeAttr("class");
                    $glyphiconError.addClass("butter-component-glyphicon");
                    if (hideGlyphicon) {
                        $glyphiconError.show();
                    }
                    if (linkGlyphicon.length > 0) {
                        $glyphiconError.addClass(linkGlyphicon);
                    }
                    if (disableRenderRegionsIds !== "undefined") {
                        // console.log('Enable field');
                        new ButterFaces.Overlay(0, false, disableRenderRegionsIds.replace(/[:]/g, "\:")).hide();
                    }
                    break;
            }
        };
        /**
         * Submit given form.
         * @param formId the target form id to submit
         * @param params a list of params to be added to form as hidden input fields
         * @param target the target of the form submission
         */
        CommandLink.submitForm = function (formId, params, target) {
            var form = document.getElementById(formId);
            ButterFaces.CommandLink.addParametersAsHiddenFieldsToForm(form, params);
            var oldFormTarget = ButterFaces.CommandLink.setFormTarget(form, target);
            if (form.onsubmit) {
                var result = form.onsubmit();
                if (ButterFaces.Object.isNullOrUndefined(result) || result) {
                    form.submit();
                }
            }
            else {
                form.submit();
            }
            form.target = oldFormTarget;
            ButterFaces.CommandLink.removeHiddenFieldsFromForm(form);
        };
        CommandLink.addParametersAsHiddenFieldsToForm = function (form, params) {
            var bfHiddenInputFields = [];
            form.bfHiddenInputFields = bfHiddenInputFields;
            var i = 0;
            for (var k in params) {
                if (params.hasOwnProperty(k)) {
                    var p = document.createElement("input");
                    p.type = "hidden";
                    p.name = k;
                    p.value = params[k];
                    form.appendChild(p);
                    bfHiddenInputFields[i++] = p;
                }
            }
        };
        CommandLink.removeHiddenFieldsFromForm = function (form) {
            var bfHiddenInputFields = form.bfHiddenInputFields;
            if (bfHiddenInputFields !== null) {
                for (var i = 0; i < bfHiddenInputFields.length; i++) {
                    form.removeChild(bfHiddenInputFields[i]);
                }
            }
        };
        /**
         * Updates form target (if exists) and returns previous form target
         * @param form the torm to add the new target to
         * @param target the target to add (if not null)
         * @return the previous form target
         */
        CommandLink.setFormTarget = function (form, target) {
            var previousTarget = form.target;
            if (target) {
                form.target = target;
            }
            return previousTarget;
        };
        return CommandLink;
    }());
    ButterFaces.CommandLink = CommandLink;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
