/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.butterfaces.resolver.WebXmlParameters;

public class HandleResourceListener
implements SystemEventListener {
    private static final String HEAD = "head";
    private static final String TARGET = "target";
    private static final String CONFIGURABLE_LIBRARY_NAME = "butterfaces-dist-bundle-dev-js";

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        UIViewRoot source = (UIViewRoot)event.getSource();
        FacesContext context = FacesContext.getCurrentInstance();
        WebXmlParameters webXmlParameters = new WebXmlParameters(context.getExternalContext());
        boolean provideJQuery = webXmlParameters.isProvideJQuery();
        boolean provideBootstrap = webXmlParameters.isProvideBoostrap();
        boolean useCompressedResources = webXmlParameters.isUseCompressedResources();
        boolean disablePrimeFacesJQuery = webXmlParameters.isIntegrationPrimeFacesDisableJQuery();
        ArrayList<UIComponent> resources = new ArrayList<UIComponent>(source.getComponentResources(context, HEAD));
        if (useCompressedResources && context.getApplication().getProjectStage() == ProjectStage.Production) {
            this.handleCompressedResources(context, provideJQuery, provideBootstrap, resources, source);
        } else {
            this.handleConfigurableResources(context, provideJQuery, provideBootstrap, resources, source);
        }
        if (disablePrimeFacesJQuery) {
            for (UIComponent resource : resources) {
                String resourceLibrary = (String)resource.getAttributes().get("library");
                String resourceName = (String)resource.getAttributes().get("name");
                if (!"primefaces".equals(resourceLibrary) || !"jquery/jquery.js".equals(resourceName)) continue;
                source.removeComponentResource(context, resource);
            }
        }
    }

    private void handleCompressedResources(FacesContext context, boolean provideJQuery, boolean provideBootstrap, List<UIComponent> resources, UIViewRoot view) {
        this.removeAllResourcesFromViewRoot(context, resources, view);
        if (provideBootstrap && provideJQuery) {
            this.addGeneratedCSSResource(context, "dist-butterfaces-bootstrap.min.css", view);
            this.addGeneratedJSResource(context, "butterfaces-all-with-jquery-and-bootstrap-bundle.min.js", "butterfaces-dist-bundle-js", view);
        } else if (provideBootstrap) {
            this.addGeneratedCSSResource(context, "dist-butterfaces-bootstrap.min.css", view);
            this.addGeneratedJSResource(context, "butterfaces-all-with-bootstrap-bundle.min.js", "butterfaces-dist-bundle-js", view);
        } else if (provideJQuery) {
            this.addGeneratedCSSResource(context, "dist-butterfaces-only.min.css", view);
            this.addGeneratedJSResource(context, "butterfaces-all-with-jquery-bundle.min.js", "butterfaces-dist-bundle-js", view);
        } else {
            this.addGeneratedCSSResource(context, "dist-butterfaces-only.min.css", view);
            this.addGeneratedJSResource(context, "butterfaces-all-bundle.min.js", "butterfaces-dist-bundle-js", view);
        }
        for (UIComponent resource : resources) {
            context.getViewRoot().addComponentResource(context, resource, HEAD);
        }
    }

    private void removeAllResourcesFromViewRoot(FacesContext context, List<UIComponent> resources, UIViewRoot view) {
        Iterator<UIComponent> it = resources.iterator();
        while (it.hasNext()) {
            UIComponent resource = it.next();
            String resourceLibrary = (String)resource.getAttributes().get("library");
            this.removeResource(context, resource, view);
            if (resourceLibrary == null || !resourceLibrary.startsWith("butterfaces")) continue;
            it.remove();
        }
    }

    private void handleConfigurableResources(FacesContext context, boolean provideJQuery, boolean provideBootstrap, List<UIComponent> resources, UIViewRoot view) {
        for (UIComponent resource : resources) {
            String resourceLibrary = (String)resource.getAttributes().get("library");
            String resourceName = (String)resource.getAttributes().get("name");
            boolean isResourceAccepted = true;
            if (resourceName != null && CONFIGURABLE_LIBRARY_NAME.equals(resourceLibrary)) {
                if (!provideJQuery && resourceName.equals("butterfaces-third-party-jquery.js")) {
                    isResourceAccepted = false;
                } else if (!provideBootstrap && resourceName.equals("butterfaces-third-party-bootstrap.js")) {
                    isResourceAccepted = false;
                }
            }
            if (isResourceAccepted) continue;
            this.removeResource(context, resource, view);
        }
    }

    private void addGeneratedJSResource(FacesContext context, String resourceName, String library, UIViewRoot view) {
        this.addGeneratedResource(context, resourceName, "javax.faces.resource.Script", library, view);
    }

    private void addGeneratedCSSResource(FacesContext context, String resourceName, UIViewRoot view) {
        this.addGeneratedResource(context, resourceName, "javax.faces.resource.Stylesheet", "butterfaces-dist-css", view);
    }

    private void addGeneratedResource(FacesContext context, String resourceName, String rendererType, String value, UIViewRoot view) {
        UIOutput resource = new UIOutput();
        resource.getAttributes().put("name", resourceName);
        resource.setRendererType(rendererType);
        resource.getAttributes().put("library", value);
        view.addComponentResource(context, (UIComponent)resource, HEAD);
    }

    private void removeResource(FacesContext context, UIComponent resource, UIViewRoot view) {
        view.removeComponentResource(context, resource, HEAD);
        view.removeComponentResource(context, resource, TARGET);
    }
}

