/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.context;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.butterfaces.context.FacesContextStringResolverWrapper;
import org.butterfaces.util.StringUtils;

public class StringHtmlEncoder {
    public static String encodeComponent(FacesContext context, UIComponent component) throws IOException {
        FacesContextStringResolverWrapper resolver = new FacesContextStringResolverWrapper(context);
        component.encodeAll((FacesContext)resolver);
        return resolver.getStringWriter().toString().replace("\n", "").trim();
    }

    public static String encodeComponentWithSurroundingDiv(FacesContext context, UIComponent component) throws IOException {
        return StringHtmlEncoder.encodeComponentWithSurroundingDiv(context, component, null);
    }

    public static String encodeComponentWithSurroundingDiv(FacesContext context, UIComponent component, String styleClass) throws IOException {
        if (StringUtils.isNotEmpty(styleClass)) {
            return "<div class=\"" + styleClass + "\">" + StringHtmlEncoder.encodeComponent(context, component) + "</div>";
        }
        return "<div>" + StringHtmlEncoder.encodeComponent(context, component) + "</div>";
    }

    public static String encodeComponentWithSurroundingDivIfNecessary(FacesContext context, UIComponent component, String styleClass) throws IOException {
        String encodedFacet = StringHtmlEncoder.encodeComponent(context, component);
        if (StringUtils.isNotEmpty(styleClass) && !encodedFacet.contains(styleClass)) {
            return "<div class=\"" + styleClass + "\">" + encodedFacet + "</div>";
        }
        return "<div>" + encodedFacet + "</div>";
    }
}

