/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.behavior;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehavior;
import javax.faces.context.FacesContext;
import org.butterfaces.util.StringJoiner;
import org.butterfaces.util.StringUtils;

public class JsfAjaxRequest {
    private final String source;
    private String event;
    private String execute;
    private String render;
    private List<String> onEventHandlers = new ArrayList<String>();
    private List<String> onErrorHandlers = new ArrayList<String>();
    private String params;
    private String behaviorEvent;
    private String delay;
    private boolean resetValues;

    public JsfAjaxRequest(String source, boolean isIdString) {
        Objects.requireNonNull(source, "source attribute may not be empty!");
        this.source = isIdString ? "'" + source + "'" : source;
    }

    public JsfAjaxRequest(UIComponentBase component, AjaxBehavior ajaxBehavior, String event) {
        this(component.getClientId(), true);
        if (!ajaxBehavior.isDisabled()) {
            if (ajaxBehavior.getExecute() != null) {
                this.execute = this.convertStringListToJoinedString(ajaxBehavior.getExecute(), component);
            }
            if (ajaxBehavior.getRender() != null) {
                this.render = this.convertStringListToJoinedString(ajaxBehavior.getRender(), component);
            }
            if (ajaxBehavior.getOnevent() != null) {
                this.addOnEventHandler(ajaxBehavior.getOnevent());
            }
            if (ajaxBehavior.getOnerror() != null) {
                this.addOnErrorHandler(ajaxBehavior.getOnerror());
            }
            try {
                if (StringUtils.isNotEmpty(ajaxBehavior.getDelay())) {
                    this.delay = ajaxBehavior.getDelay();
                }
                this.resetValues = ajaxBehavior.isResetValues();
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            this.setEvent(event);
            this.setBehaviorEvent(event);
        }
    }

    public JsfAjaxRequest setEvent(String event) {
        this.event = event;
        return this;
    }

    public JsfAjaxRequest setExecute(String execute) {
        this.execute = execute;
        return this;
    }

    public JsfAjaxRequest setDelay(String delay) {
        this.delay = delay;
        return this;
    }

    public JsfAjaxRequest setRender(String render) {
        this.render = render;
        return this;
    }

    public JsfAjaxRequest setRender(UIComponentBase component, String eventName) {
        this.render = StringJoiner.on(' ').join(JsfAjaxRequest.createRerenderIds(component, eventName)).toString();
        return this;
    }

    public JsfAjaxRequest setResetValues(boolean resetValues) {
        this.resetValues = resetValues;
        return this;
    }

    public JsfAjaxRequest addRender(String render) {
        if (StringUtils.isNotEmpty(render)) {
            this.render = this.render == null ? render : this.render + " " + render;
        }
        return this;
    }

    public JsfAjaxRequest setParams(String params) {
        this.params = params;
        return this;
    }

    public JsfAjaxRequest setBehaviorEvent(String behaviorEvent) {
        this.behaviorEvent = behaviorEvent;
        return this;
    }

    public JsfAjaxRequest addOnEventHandler(String functionString) {
        if (StringUtils.isNotEmpty(functionString)) {
            this.onEventHandlers.add(functionString);
        }
        return this;
    }

    public JsfAjaxRequest addOnErrorHandler(String functionString) {
        if (StringUtils.isNotEmpty(functionString)) {
            this.onErrorHandlers.add(functionString);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("jsf.ajax.request(");
        sb.append(this.source);
        if (StringUtils.isNotEmpty(this.event)) {
            sb.append(", '").append(this.event).append("'");
        }
        if (this.hasOptions()) {
            sb.append(", {");
            boolean isAtLeastOneOptionSet = false;
            if (StringUtils.isNotEmpty(this.execute)) {
                sb.append("execute: '").append(this.execute).append("'");
                isAtLeastOneOptionSet = true;
            }
            if (StringUtils.isNotEmpty(this.render)) {
                this.writeSeparatorIfNecessary(sb, isAtLeastOneOptionSet);
                sb.append("render: '").append(this.render).append("'");
                isAtLeastOneOptionSet = true;
            }
            if (!this.onEventHandlers.isEmpty()) {
                this.writeSeparatorIfNecessary(sb, isAtLeastOneOptionSet);
                sb.append("onevent: ").append(this.renderFunctionCalls(this.onEventHandlers));
                isAtLeastOneOptionSet = true;
            }
            if (!this.onErrorHandlers.isEmpty()) {
                this.writeSeparatorIfNecessary(sb, isAtLeastOneOptionSet);
                sb.append("onerror: ").append(this.renderFunctionCalls(this.onErrorHandlers));
                isAtLeastOneOptionSet = true;
            }
            if (StringUtils.isNotEmpty(this.delay)) {
                this.writeSeparatorIfNecessary(sb, isAtLeastOneOptionSet);
                sb.append("delay: '").append(this.delay).append("'");
                isAtLeastOneOptionSet = true;
            }
            if (this.resetValues) {
                this.writeSeparatorIfNecessary(sb, isAtLeastOneOptionSet);
                sb.append("resetValues: '").append(this.resetValues).append("'");
                isAtLeastOneOptionSet = true;
            }
            if (StringUtils.isNotEmpty(this.params)) {
                this.writeSeparatorIfNecessary(sb, isAtLeastOneOptionSet);
                sb.append("params: ").append(this.params);
                isAtLeastOneOptionSet = true;
            }
            if (StringUtils.isNotEmpty(this.behaviorEvent)) {
                this.writeSeparatorIfNecessary(sb, isAtLeastOneOptionSet);
                sb.append("'javax.faces.behavior.event': '").append(this.behaviorEvent).append("'");
            }
            sb.append("}");
        }
        sb.append(");");
        return sb.toString();
    }

    public static List<String> createRerenderIds(UIComponentBase component, String eventName) {
        ArrayList<String> idsToRender = new ArrayList<String>();
        Map behaviors = component.getClientBehaviors();
        List refreshBehaviors = (List)behaviors.get(eventName);
        if (refreshBehaviors == null) {
            return new ArrayList<String>();
        }
        boolean enabledAjaxEventFound = false;
        if (!refreshBehaviors.isEmpty()) {
            for (ClientBehavior refreshBehavior : refreshBehaviors) {
                AjaxBehavior ajaxBehavior;
                if (!(refreshBehavior instanceof AjaxBehavior) || (ajaxBehavior = (AjaxBehavior)refreshBehavior).isDisabled()) continue;
                if (ajaxBehavior.getRender() != null && !ajaxBehavior.getRender().isEmpty()) {
                    for (String singleRender : ajaxBehavior.getRender()) {
                        idsToRender.add(JsfAjaxRequest.getResolvedId(component, singleRender));
                    }
                }
                enabledAjaxEventFound = true;
            }
        }
        if (!enabledAjaxEventFound) {
            return new ArrayList<String>();
        }
        return idsToRender;
    }

    private static String getResolvedId(UIComponentBase component, String id) {
        if (id.equals("@all") || id.equals("@none") || id.equals("@form") || id.equals("@this")) {
            return id;
        }
        UIComponent resolvedComponent = component.findComponent(id);
        if (resolvedComponent == null) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (context != null && id.charAt(0) == UINamingContainer.getSeparatorChar((FacesContext)context)) {
                return id.substring(1);
            }
            return id;
        }
        return resolvedComponent.getClientId();
    }

    private void writeSeparatorIfNecessary(StringBuilder sb, boolean isAtLeastOneOptionSet) {
        if (isAtLeastOneOptionSet) {
            sb.append(", ");
        }
    }

    private String renderFunctionCalls(List<String> functions) {
        StringBuilder sb = new StringBuilder("function(data){");
        for (String function : functions) {
            sb.append(function);
            if (!function.contains(")")) {
                sb.append("(data)");
            }
            sb.append(";");
        }
        sb.append("}");
        return sb.toString();
    }

    private boolean hasOptions() {
        return StringUtils.isNotEmpty(this.execute) || StringUtils.isNotEmpty(this.render) || StringUtils.isNotEmpty(this.delay) || this.resetValues || !this.onEventHandlers.isEmpty() || !this.onErrorHandlers.isEmpty() || StringUtils.isNotEmpty(this.params) || StringUtils.isNotEmpty(this.behaviorEvent);
    }

    private String convertStringListToJoinedString(Collection<String> clientIds) {
        return this.convertStringListToJoinedString(clientIds, null);
    }

    private String convertStringListToJoinedString(Collection<String> clientIds, UIComponentBase component) {
        if (clientIds.isEmpty()) {
            return null;
        }
        StringJoiner joiner = StringJoiner.on(' ');
        for (String clientId : clientIds) {
            if (!StringUtils.isNotEmpty(clientId)) continue;
            if (component != null) {
                joiner = joiner.join(JsfAjaxRequest.getResolvedId(component, clientId));
                continue;
            }
            joiner = joiner.join(clientId);
        }
        return joiner.toString();
    }
}

