/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.partrenderer;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.butterfaces.component.html.HtmlTooltip;
import org.butterfaces.component.html.feature.Validation;

public class TooltipValidationRenderer {
    public void renderTooltipIfNecessary(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderTooltip(component)) {
            boolean tooltipRendered = false;
            for (UIComponent uiComponent : component.getChildren()) {
                if (!(uiComponent instanceof HtmlTooltip) || !uiComponent.isRendered()) continue;
                tooltipRendered = true;
                break;
            }
            if (!tooltipRendered) {
                HtmlTooltip htmlTooltip = new HtmlTooltip();
                htmlTooltip.setPlacement(((Validation)component).getValidationErrorPlacement());
                htmlTooltip.setParent(component);
                htmlTooltip.encodeAll(context);
            }
        }
    }

    private boolean shouldRenderTooltip(UIComponent component) {
        return component instanceof Validation && !((Validation)component).isValid();
    }
}

