/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.base.renderer.HtmlBasicRenderer;
import org.butterfaces.component.html.HtmlSection;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.renderkit.html_basic.SectionRenderer")
public class SectionRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        HtmlSection fieldSet = (HtmlSection)component;
        String style = fieldSet.getStyle();
        String styleClass = fieldSet.getStyleClass();
        writer.startElement("section", component);
        this.writeIdAttribute(context, writer, component);
        if (null != style) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if (null != styleClass) {
            writer.writeAttribute("class", (Object)("butter-component-section " + styleClass), "styleClass");
        } else {
            writer.writeAttribute("class", (Object)"butter-component-section", "styleClass");
        }
        this.encodeHeader(component, writer, fieldSet);
        writer.startElement("div", component);
        writer.writeAttribute("class", (Object)"butter-component-section-content", null);
    }

    private void encodeHeader(UIComponent component, ResponseWriter writer, HtmlSection section) throws IOException {
        UIComponent additionalHeader = this.getFacet(component, "additional-header");
        boolean labelNotEmpty = StringUtils.isNotEmpty(section.getLabel());
        if (labelNotEmpty) {
            writer.startElement("div", component);
            writer.writeAttribute("class", (Object)"butter-component-section-title d-flex flex-row pb-2", null);
            writer.writeText((Object)section.getLabel(), component, "label");
            if (StringUtils.isNotEmpty(section.getBadgeText())) {
                writer.startElement("span", component);
                writer.writeAttribute("class", (Object)"badge badge-pill badge-secondary ml-1", null);
                writer.writeText((Object)section.getBadgeText(), component, "badgeText");
                writer.endElement("span");
            }
            if (additionalHeader != null) {
                writer.startElement("span", component);
                writer.writeAttribute("class", (Object)"butter-component-section-additional-header", null);
                additionalHeader.encodeAll(FacesContext.getCurrentInstance());
                writer.endElement("span");
            }
            writer.endElement("div");
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("div");
        writer.endElement("section");
    }
}

