/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIInput;
import javax.faces.component.UINamingContainer;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.html.text.HtmlTags;
import org.butterfaces.component.partrenderer.ReadonlyPartRenderer;
import org.butterfaces.component.partrenderer.RenderUtils;
import org.butterfaces.component.renderkit.html_basic.text.AbstractHtmlTagRenderer;
import org.butterfaces.component.renderkit.html_basic.text.model.CachedNodesInitializer;
import org.butterfaces.component.renderkit.html_basic.text.part.TrivialComponentsEntriesNodePartRenderer;
import org.butterfaces.component.renderkit.html_basic.text.util.FreeTextSeparators;
import org.butterfaces.component.renderkit.html_basic.text.util.TrivialComponentsUtil;
import org.butterfaces.model.tree.DefaultNodeImpl;
import org.butterfaces.model.tree.Node;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.TagsRenderer")
public class TagsRenderer
extends AbstractHtmlTagRenderer<HtmlTags> {
    @Override
    protected boolean encodeReadonly() {
        return false;
    }

    @Override
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component, "butter-component-tags");
    }

    @Override
    protected void encodeInnerEnd(UIComponent component, ResponseWriter writer) throws IOException {
        HtmlTags htmlTags = (HtmlTags)component;
        if (htmlTags.isReadonly()) {
            if (htmlTags.getValue() == null || StringUtils.isEmpty((String)htmlTags.getValue())) {
                new ReadonlyPartRenderer().renderReadonly(htmlTags, writer);
            } else {
                writer.startElement("div", component);
                writer.writeAttribute("class", (Object)"butter-component-value butter-flex-grow", null);
                super.encodeSuperEnd(FacesContext.getCurrentInstance(), component);
                writer.endElement("div");
            }
        }
    }

    @Override
    protected void encodeEnd(HtmlTags htmlTags, ResponseWriter writer) throws IOException {
        writer.startElement("script", (UIComponent)htmlTags);
        String clientIdSeparator = String.valueOf(UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance()));
        String treeBoxReadableId = htmlTags.getClientId().replace(clientIdSeparator, "_");
        writer.writeText((Object)"jQuery(function () {\n", null);
        String jQueryBySelector = RenderUtils.createJQueryBySelector(htmlTags.getClientId(), ".butter-input-component");
        writer.writeText((Object)("var trivialTagsJQueryObject" + treeBoxReadableId + " = " + jQueryBySelector + ";\n"), null);
        writer.writeText((Object)("var trivialTagsOptions" + treeBoxReadableId + " = " + this.createTagOptions(htmlTags) + ";\n"), null);
        writer.writeText((Object)("var trivialTags" + treeBoxReadableId + " = ButterFaces.createTrivialTagComponent(" + jQueryBySelector + ",trivialTagsOptions" + treeBoxReadableId + ");\n"), null);
        writer.writeText((Object)"});", null);
        writer.endElement("script");
    }

    @Override
    protected void setSubmittedValue(UIComponent component, Object value) {
        if (component instanceof UIInput) {
            String decodedValue = value.toString().replace("&#x2F;", "/").replace("&quot;", "\"").replace("&#39;", "'").replace("&amp;", "&").replace("&lt;", "<").replace("&gt;", ">");
            ((UIInput)component).setSubmittedValue((Object)decodedValue);
        }
    }

    private String createTagOptions(HtmlTags tags) throws IOException {
        String selectedEntries;
        StringBuilder options = new StringBuilder();
        List<Node> entries = this.createEntries(tags.getEntries());
        String editable = TrivialComponentsEntriesNodePartRenderer.getEditingMode(tags);
        boolean showTrigger = !entries.isEmpty();
        options.append("{");
        options.append("\n    showTrigger: " + showTrigger + ",");
        options.append("\n    autoComplete: " + tags.isAutoComplete() + ",");
        options.append("\n    distinct: " + tags.isDistinct() + ",");
        options.append("\n    editingMode: '" + editable + "',");
        if (tags.getMaxTags() != null) {
            options.append("\n    maxSelectedEntries: " + tags.getMaxTags() + ",");
        }
        if (StringUtils.isNotEmpty(selectedEntries = this.getSelectedEntries(tags))) {
            options.append("\n    selectedEntries: [" + selectedEntries + "],");
        }
        options.append("\n    freeTextSeparators: " + this.createFreeTextSeparators(tags) + ",");
        if (!entries.isEmpty()) {
            List<String> mustacheKeys = TrivialComponentsUtil.createMustacheKeys(FacesContext.getCurrentInstance(), (UIComponentBase)tags);
            Map<Integer, Node> nodesMap = CachedNodesInitializer.createNodesMap(entries);
            options.append("\n    entries: " + new TrivialComponentsEntriesNodePartRenderer().renderEntriesAsJSON(entries, TrivialComponentsUtil.replaceDotInMustacheKeys(mustacheKeys), nodesMap) + ",");
        }
        options.append("\n}");
        return options.toString();
    }

    private List<Node> createEntries(List<Object> objects) {
        ArrayList<Node> entries = new ArrayList<Node>();
        if (objects != null) {
            for (Object object : objects) {
                entries.add(new DefaultNodeImpl<Object>(null, object));
            }
        }
        return entries;
    }

    private String createFreeTextSeparators(HtmlTags tags) {
        return "[" + StringUtils.joinWithCommaSeparator(FreeTextSeparators.getFreeTextSeparators(tags), true) + "]";
    }

    private String getSelectedEntries(HtmlTags tags) {
        String componentValue = this.getSubmittedValueOrValue(tags);
        if (StringUtils.isNotEmpty(componentValue)) {
            Iterator<String> iterator = new ArrayList<String>(Arrays.asList(componentValue.split(","))).iterator();
            StringBuilder sb = new StringBuilder();
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (!StringUtils.isNotEmpty(next)) continue;
                sb.append("{title:'" + this.escapeDisplayValue(next) + "'}");
                if (!iterator.hasNext()) continue;
                sb.append(",");
            }
            return sb.toString();
        }
        return null;
    }

    private String escapeDisplayValue(String value) {
        return value.replace("&", "&amp;").replace("/", "&#x2F;").replace("\"", "&quot;").replace("'", "&#39;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private String getSubmittedValueOrValue(HtmlTags tags) {
        if (tags.getSubmittedValue() != null) {
            return tags.getSubmittedValue().toString();
        }
        if (tags.getValue() != null) {
            return tags.getValue().toString();
        }
        return null;
    }
}

