/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.butterfaces.util.StringUtils;

public class MustacheResolver {
    public static final Pattern MUSTACHE_PATTERN = Pattern.compile("\\{\\{(.*?)\\}\\}");

    public static List<String> getMustacheKeys(String template) {
        HashSet<String> keys = new HashSet<String>();
        if (StringUtils.isNotEmpty(template)) {
            Matcher matcher = MUSTACHE_PATTERN.matcher(template);
            while (matcher.find()) {
                keys.add(matcher.group(1));
            }
        }
        return new ArrayList<String>(keys);
    }

    public static List<String> getMustacheKeysForTreeNode(String template) {
        List<String> mustacheKeys = MustacheResolver.getMustacheKeys(template);
        mustacheKeys.removeAll(Arrays.asList("id", "title", "expanded", "description", "imageStyle", "imageClass", "styleClass"));
        return mustacheKeys;
    }
}

