///<reference path="../../node_modules/trivial-components/dist/js/bundle/trivial-components-global.d.ts"/>
///<reference path="../../node_modules/@types/mustache/index.d.ts"/>
var ButterFaces;
(function (ButterFaces) {
    function createTrivialTagComponent($input, options) {
        return new TrivialComponents.TrivialTagComboBox($input, {
            autoComplete: options.autoComplete,
            allowFreeText: true,
            showTrigger: options.showTrigger,
            distinct: options.distinct,
            editingMode: options.editingMode,
            matchingOptions: {
                matchingMode: "contains",
                ignoreCase: true,
                maxLevenshteinDistance: 0
            },
            maxSelectedEntries: options.maxSelectedEntries,
            selectedEntries: options.selectedEntries,
            freeTextSeparators: options.freeTextSeparators,
            entries: options.entries,
            valueFunction: function (entries) {
                return entries
                    .map(function (entry) { return entry.id != null ? entry.id : entry.title; })
                    .join(",");
            },
            freeTextEntryFactory: function (freeText) {
                return { title: escapeHtml(freeText) };
            },
            entryRenderingFunction: function (entry) { return "<div>" + entry.title + "</div>"; },
        });
        function escapeHtml(source) {
            /* tslint:disable */
            var entityMap = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                '"': "&quot;",
                "'": "&#39;",
                "/": "&#x2F;"
            };
            /* tslint:enable */
            return source.replace(/[&<>"'\/]/g, function (s) { return entityMap[s]; });
        }
    }
    ButterFaces.createTrivialTagComponent = createTrivialTagComponent;
    function createTrivialTreeComponent($input, options) {
        return new TrivialComponents.TrivialTree($input, {
            searchBarMode: options.searchBarMode,
            selectedEntryId: options.selectedEntryId,
            performanceOptimizationSettings: options.performanceOptimizationSettings,
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComponent = createTrivialTreeComponent;
    function createTrivialComboBox($input, options) {
        return new TrivialComponents.TrivialComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry) {
                return Mustache.render(options.template, entry);
            },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.template, entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries
        });
    }
    ButterFaces.createTrivialComboBox = createTrivialComboBox;
    function createTrivialTreeComboBox($input, options) {
        return new TrivialComponents.TrivialTreeComboBox($input, {
            allowFreeText: false,
            entryToEditorTextFunction: function (entry) { return entry[options.inputTextProperty]; },
            entryRenderingFunction: function (entry, depth) { return Mustache.render(options.templates[Math.min(options.templates.length - 1, depth)], entry); },
            selectedEntryRenderingFunction: function (entry) {
                if (!entry || entry._isEmptyEntry) {
                    return options.emptyEntryTemplate || "";
                }
                else if (options.selectedEntryTemplate) {
                    return Mustache.render(options.selectedEntryTemplate, entry);
                }
                else {
                    return Mustache.render(options.templates[0], entry);
                }
            },
            editingMode: options.editingMode,
            showClearButton: options.showClearButton,
            selectedEntry: options.selectedEntry,
            spinnerTemplate: options.spinnerTemplate,
            noEntriesTemplate: options.noEntriesTemplate,
            entries: options.entries,
            queryFunction: TrivialComponents.customTreeQueryFunctionFactory(options.entries, "children", "expanded", function (entry, queryString, nodeDepth) {
                // TODO remove null parameter after trivial component is fixed
                var titleMatches = entry.title && TrivialComponents.trivialMatch(entry.title, queryString, null).length > 0;
                var descriptionMatches = entry.description && TrivialComponents.trivialMatch(entry.description, queryString, null).length > 0;
                return titleMatches || descriptionMatches;
            })
        });
    }
    ButterFaces.createTrivialTreeComboBox = createTrivialTreeComboBox;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
