///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-util-string.ts"/>
///<reference path="butterfaces-util-object.ts"/>
(function ($) {
    // you have to extend jQuery with the fn["pluginName"] notation because in Typescript you can't extend
    // the existing typing interface with fn.pluginName!
    $.fn["butterMaxLength"] = function (options) {
        return this.each(function (index, element) {
            new ButterFaces.MaxLengthIndicator($(element), options);
        });
    };
})(jQuery);
var ButterFaces;
(function (ButterFaces) {
    var ERROR_STYLE_CLASS = "has-error";
    var INVALID_STYLE_CLASS = "is-invalid";
    var MaxLengthIndicator = /** @class */ (function () {
        function MaxLengthIndicator(rootElement, options) {
            this.rootElement = rootElement;
            this.options = options;
            this.valueElement = this.rootElement.find("textarea");
            this.maxLengthElement = $("<div>").addClass("butter-component-maxlength-counter");
            this.maxLengthElement.insertAfter(this.valueElement);
            this.initializeComponent();
        }
        MaxLengthIndicator.prototype.initializeComponent = function () {
            console.log("ButterFaces.MaxLengthIndicator - initializeComponent");
            this.hasInitialValidationError = this.rootElement.hasClass(ERROR_STYLE_CLASS);
            console.log(this.valueElement);
            var that = this;
            this.valueElement.on("focus blur keyup cut paste", function () {
                that.checkValue();
            });
            // initial check
            this.checkValue();
        };
        MaxLengthIndicator.prototype.checkValue = function () {
            var value = this.valueElement.val();
            if (!ButterFaces.Object.isNullOrUndefined(value)) {
                console.log("ButterFaces.MaxLengthIndicator: updating maxlength value");
                var freeLetterCount = this.options.maxLength - value.length;
                var formatted = ButterFaces.String.format(this.options.maxLengthText, [freeLetterCount, this.options.maxLength]);
                this.maxLengthElement.text(formatted);
                if (!this.hasInitialValidationError) {
                    if (freeLetterCount < 0) {
                        this.rootElement.addClass(ERROR_STYLE_CLASS);
                        this.valueElement.addClass(INVALID_STYLE_CLASS);
                    }
                    else {
                        this.rootElement.removeClass(ERROR_STYLE_CLASS);
                        this.valueElement.removeClass(INVALID_STYLE_CLASS);
                    }
                }
            }
        };
        return MaxLengthIndicator;
    }());
    ButterFaces.MaxLengthIndicator = MaxLengthIndicator;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
