///<reference path="../../node_modules/@types/jquery/index.d.ts"/>
///<reference path="butterfaces-guid.ts"/>
///<reference path="butterfaces-util-object.ts"/>
var ButterFaces;
(function (ButterFaces) {
    var Overlay = /** @class */ (function () {
        function Overlay(delay, isTransparentBlockingOverlayActive, selector) {
            if (delay === void 0) { delay = 500; }
            if (isTransparentBlockingOverlayActive === void 0) { isTransparentBlockingOverlayActive = true; }
            if (selector === void 0) { selector = "body"; }
            this.isHiding = true;
            this.delay = delay;
            this.isTransparentBlockingOverlayActive = isTransparentBlockingOverlayActive;
            this.selector = selector;
            console.log("ButterFaces.Overlay.constructor - creating overlay with delay is "
                + this.delay
                + ", isTransparentBlockingOverlayActive is "
                + this.isTransparentBlockingOverlayActive
                + ", selector is "
                + this.selector);
        }
        Overlay.prototype.show = function () {
            var _this = this;
            var $elementsToDisable = $(this.selector);
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                _this.isHiding = false;
                if (!ButterFaces.Object.isNullOrUndefined($elementToDisable.attr("data-overlay-uuid"))) {
                    if (ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid")).length > 0) {
                        console.log("ButterFaces.Overlay.show - overlay already existing. Skip showing overlay");
                        return;
                    }
                    else {
                        $elementToDisable.removeAttr("data-overlay-uuid");
                    }
                }
                console.log("ButterFaces.Overlay.show - appending not displayed overlay to body");
                var uuid = ButterFaces.Guid.newGuid();
                var $overlay = $("<div class='butter-component-overlay' data-overlay-uuid='" + uuid + "'><div class='" + _this.calcOverlaySpinnerClass($elementToDisable) + "'></div></div>");
                $elementToDisable.attr("data-overlay-uuid", uuid);
                if (_this.selector === "body") {
                    $overlay.addClass("overlay-body");
                }
                else {
                    // TODO if blockpage is true set it to max size
                    $overlay.offset($elementToDisable.offset())
                        .width($elementToDisable.outerWidth())
                        .height($elementToDisable.outerHeight())
                        .addClass("overlay-body-child")
                        .css({ "position": "absolute" }); // IE overrides css position so set it here
                }
                $("body").append($overlay);
                if (_this.isTransparentBlockingOverlayActive) {
                    console.log("ButterFaces.Overlay.show - isTransparentBlockingOverlayActive is true, showing transparent overlay direcly");
                    $overlay.show();
                }
                window.setTimeout(function () {
                    if (!_this.isHiding && !_this.isTransparentBlockingOverlayActive) {
                        console.log("ButterFaces.Overlay.show - deferred: isTransparentBlockingOverlayActive is false, showing transparent overlay after delay");
                        $overlay.show();
                    }
                    if (!_this.isHiding) {
                        console.log("ButterFaces.Overlay.show - deferred: starting animation to make overlay intransparent");
                        $overlay
                            .stop(true)
                            .animate({
                            opacity: 1
                        }, 300, function () {
                            console.log("ButterFaces.Overlay.show - deferred: animation ended to make overlay intransparent");
                        });
                    }
                }, _this.delay);
            });
        };
        Overlay.prototype.hide = function () {
            console.log("ButterFaces.Overlay.hide - starting animation to make overlay transparent");
            var $elementsToDisable = $(this.selector);
            this.isHiding = true;
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            $elementsToDisable.each(function (index, elementToDisable) {
                var $elementToDisable = $(elementToDisable);
                var overlayUuid = $elementToDisable.attr("data-overlay-uuid");
                if (!ButterFaces.Object.isNullOrUndefined(overlayUuid) && ButterFaces.Overlay.findOverlay(overlayUuid).length > 0) {
                    var $overlay = ButterFaces.Overlay.findOverlay($elementToDisable.attr("data-overlay-uuid"));
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.prototype.calcOverlaySpinnerClass = function (element) {
            if (element.outerHeight() < 55) {
                return "butter-component-spinner tiny";
            }
            if (element.outerHeight() < 105) {
                return "butter-component-spinner small";
            }
            return "butter-component-spinner";
        };
        Overlay.hideAll = function () {
            console.log("ButterFaces.Overlay.hideAll - starting animation to make all overlays transparent");
            ButterFaces.Overlay.fadeOutDetachtedOverlays();
            ButterFaces.Overlay.fadeOutAttachtedOverlays();
        };
        Overlay.fadeOutDetachtedOverlays = function () {
            // remove unbinded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                if ($("[data-overlay-uuid=" + uuidToCheck + "]").length === 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                }
            });
        };
        Overlay.fadeOutAttachtedOverlays = function () {
            // remove binded elements
            $(".butter-component-overlay").each(function (index, elementToCheck) {
                var $overlay = $(elementToCheck);
                var uuidToCheck = $(elementToCheck).attr("data-overlay-uuid");
                var elements = $("[data-overlay-uuid=" + uuidToCheck + "]");
                if (elements.length > 1) {
                    ButterFaces.Overlay.fadeOutOverlay($overlay);
                    elements.each(function (index, element) {
                        var $element = $(element);
                        $element.removeAttr("data-overlay-uuid");
                    });
                }
            });
        };
        Overlay.fadeOutOverlay = function ($overlay) {
            $overlay
                .stop(true)
                .animate({
                opacity: 0
            }, 300, function () {
                $overlay.remove();
                console.log("ButterFaces.Overlay.hide - animation ended to make overlay transparent, OVERLAY REMOVED");
            });
        };
        Overlay.findOverlay = function (uuid) {
            return $("body .butter-component-overlay[data-overlay-uuid='" + uuid + "']");
        };
        return Overlay;
    }());
    ButterFaces.Overlay = Overlay;
})(ButterFaces || (ButterFaces = {}));

//# sourceMappingURL=data:application/json;charset=utf8;base64,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
