/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.html.action;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIForm;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public abstract class AbstractKeyCodeAction
extends UIComponentBase {
    private static final Logger LOGGER = Logger.getLogger(AbstractKeyCodeAction.class.getName());
    private static final String SCRIPT_ELEMENT = "script";
    private static final String SCRIPT_LANGUAGE_ATTRIBUTE = "language";
    private static final String SCRIPT_LANGUAGE_JAVASCRIPT = "JavaScript";
    private static final String SCRIPT_TYPE_ATTRIBUTE = "type";
    private static final String SCRIPT_TYPE_TEXT_JAVASCRIPT = "text/javascript";
    protected static final String PROPERTY_RENDERED = "rendered";

    public abstract String getListeningKeyCode();

    public abstract String getFormActionMarker();

    public String getFamily() {
        return "defaultAction";
    }

    public boolean isRendered() {
        Object eval = this.getStateHelper().eval((Serializable)((Object)PROPERTY_RENDERED));
        return eval == null ? true : (Boolean)eval;
    }

    public void setRendered(boolean rendered) {
        this.updateStateHelper(PROPERTY_RENDERED, rendered);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        UIComponent actionComponent = this.getParent();
        String actionComponentId = actionComponent.getClientId(context);
        UIForm form = this.getForm(actionComponent);
        if (form == null) {
            LOGGER.warning("AbstractKeyCodeAction does not have an ambient form. Form is required");
        } else {
            this.markForm(form, this.getClientId(context));
            ResponseWriter responseWriter = context.getResponseWriter();
            this.writeActionScript(responseWriter, form, actionComponentId);
        }
    }

    private void writeActionScript(ResponseWriter responseWriter, UIForm form, String actionComponentId) throws IOException {
        responseWriter.startElement(SCRIPT_ELEMENT, (UIComponent)this);
        responseWriter.writeAttribute(SCRIPT_LANGUAGE_ATTRIBUTE, (Object)SCRIPT_LANGUAGE_JAVASCRIPT, SCRIPT_LANGUAGE_ATTRIBUTE);
        responseWriter.writeAttribute(SCRIPT_TYPE_ATTRIBUTE, (Object)SCRIPT_TYPE_TEXT_JAVASCRIPT, SCRIPT_TYPE_ATTRIBUTE);
        responseWriter.write(this.createFunctionCode(form.getClientId(), actionComponentId));
        responseWriter.endElement(SCRIPT_ELEMENT);
    }

    private String createFunctionCode(String formId, String actionComponentId) {
        StringBuilder sb = new StringBuilder();
        sb.append("document.forms['" + formId + "'].onkeypress = ");
        sb.append("new Function(\"event\", \"" + this.createBody(actionComponentId) + "\");");
        return sb.toString();
    }

    private String createBody(String actionComponentId) {
        StringBuilder sb = new StringBuilder();
        sb.append("if (!event) { event = window.event; }");
        sb.append("var evt = event.target?event.target:event.srcElement;");
        sb.append("if (evt.tagName.toLowerCase() != 'textarea') {");
        sb.append("{var keycode;");
        sb.append("if (window.event) keycode = window.event.keyCode;");
        sb.append("else if (event) keycode = event.which;");
        sb.append("else return true;");
        sb.append("if (keycode == " + this.getListeningKeyCode() + ")");
        sb.append("{document.getElementById('" + actionComponentId + "').click();return false; }");
        sb.append("else return true; }");
        sb.append("}");
        sb.append("return true;");
        return sb.toString();
    }

    private void markForm(UIForm form, String componentId) {
        if (this.isFormMarked(form) && !this.isFormMarkedWithId(form, componentId)) {
            LOGGER.warning("AbstractKeyCodeAction only supports one key event");
        } else {
            form.getAttributes().put(this.getFormActionMarker(), componentId);
        }
    }

    private boolean isFormMarked(UIForm form) {
        return form.getAttributes().containsKey(this.getFormActionMarker());
    }

    private boolean isFormMarkedWithId(UIForm form, String componentId) {
        return form.getAttributes().get(this.getFormActionMarker()).equals(componentId);
    }

    private UIForm getForm(UIComponent component) {
        while (component != null && !(component instanceof UIForm)) {
            component = component.getParent();
        }
        return (UIForm)component;
    }

    private void updateStateHelper(String propertyName, Object value) {
        this.getStateHelper().put((Serializable)((Object)propertyName), value);
        ValueExpression ve = this.getValueExpression(propertyName);
        if (ve != null) {
            ve.setValue(this.getFacesContext().getELContext(), value);
        }
    }
}

