/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.component.renderkit.html_basic.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIOutput;
import javax.faces.component.UIParameter;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.component.behavior.ClientBehaviorContext;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.render.FacesRenderer;
import org.butterfaces.component.base.renderer.HtmlBasicRenderer;
import org.butterfaces.component.behavior.JsfAjaxRequest;
import org.butterfaces.component.html.action.HtmlCommandLink;
import org.butterfaces.component.renderkit.html_basic.action.ParameterAppender;
import org.butterfaces.resolver.AjaxClientIdResolver;
import org.butterfaces.resolver.ClientBehaviorResolver;
import org.butterfaces.resolver.UIComponentResolver;
import org.butterfaces.resolver.WebXmlParameters;
import org.butterfaces.util.StringJoiner;
import org.butterfaces.util.StringUtils;

@FacesRenderer(componentFamily="org.butterfaces.component.family", rendererType="org.butterfaces.component.renderkit.html_basic.commandLinkRenderer")
public class CommandLinkRenderer
extends HtmlBasicRenderer {
    private WebXmlParameters webXmlParameters;
    private String onEventCallback = null;

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.onEventCallback = null;
        HtmlCommandLink link = (HtmlCommandLink)component;
        ResponseWriter writer = context.getResponseWriter();
        this.webXmlParameters = new WebXmlParameters(context.getExternalContext());
        if (!link.isDisabled()) {
            this.renderAsActive(context, component);
        } else {
            writer.startElement("span", component);
            this.writeIdAttributeIfNecessary(context, writer, component);
            this.writeStyleClass(writer, component);
            if (StringUtils.isNotEmpty(link.getStyle())) {
                writer.writeAttribute("style", (Object)link.getStyle(), "style");
            }
            this.writeValue(component, writer);
        }
    }

    @Override
    protected boolean shouldWriteIdAttribute(UIComponent component) {
        return true;
    }

    @Override
    public void decode(FacesContext context, UIComponent component) {
        String clientId;
        HtmlCommandLink link = (HtmlCommandLink)component;
        if (link.isDisabled()) {
            return;
        }
        ExternalContext external = context.getExternalContext();
        Map params = external.getRequestParameterMap();
        String resetValues = (String)params.get("javax.faces.partial.resetValues");
        String render = (String)params.get("javax.faces.partial.render");
        if (StringUtils.isNotEmpty(resetValues) && StringUtils.isNotEmpty(render) && Boolean.valueOf(resetValues).booleanValue()) {
            String[] split;
            for (String clientId2 : split = render.split(" ")) {
                UIComponent renderComponent = context.getViewRoot().findComponent(clientId2);
                this.resetValues(renderComponent);
            }
        }
        if ((clientId = this.decodeBehaviors(context, component)) == null) {
            clientId = component.getClientId(context);
        }
        if (params.containsKey(clientId) || this.isPartialOrBehaviorAction(clientId, params)) {
            component.queueEvent((FacesEvent)new ActionEvent(component));
        }
    }

    private boolean isPartialOrBehaviorAction(String clientId, Map<String, String> requestParameter) {
        if (clientId == null || clientId.length() == 0) {
            return false;
        }
        if (!clientId.equals(requestParameter.get("javax.faces.source"))) {
            return false;
        }
        String behaviorEvent = requestParameter.get("javax.faces.behavior.event");
        if (behaviorEvent != null) {
            return "action".equals(behaviorEvent);
        }
        return "click".equals(requestParameter.get("javax.faces.partial.event"));
    }

    private void resetValues(UIComponent component) {
        if (component == null) {
            return;
        }
        for (UIComponent child : component.getChildren()) {
            this.resetValues(child);
        }
        if (component instanceof UIOutput) {
            ((UIOutput)component).resetValue();
        } else if (component instanceof EditableValueHolder) {
            ((EditableValueHolder)component).resetValue();
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        HtmlCommandLink link = (HtmlCommandLink)component;
        ResponseWriter writer = context.getResponseWriter();
        if (!link.isDisabled()) {
            if (link.isAjaxDisableLinkOnRequest()) {
                writer.startElement("script", component);
                writer.writeText((Object)("function " + this.getOnEventListenerName(component) + "(data) {"), null);
                if (StringUtils.isNotEmpty(this.onEventCallback)) {
                    writer.writeText((Object)("    " + this.onEventCallback + "(data);"), null);
                }
                String processingText = this.createAjaxProcessingText(link);
                String processingGlyphicon = this.createAjaxProcessingGlyphicon(link);
                AjaxClientIdResolver ajaxClientIdResolver = new AjaxClientIdResolver((UIComponent)link);
                String jQueryIDSelector = this.isAjaxDisableRenderReqionOnRequest(link, this.webXmlParameters) != false ? ajaxClientIdResolver.getjQueryRenderIDSelector() : "undefined";
                writer.writeText((Object)this.createDisableOnClickFunctionCall(link, processingText, processingGlyphicon, jQueryIDSelector), null);
                writer.writeText((Object)"}", null);
                writer.endElement("script");
            }
            writer.endElement("a");
        } else {
            writer.endElement("span");
        }
    }

    private Boolean isAjaxDisableRenderReqionOnRequest(HtmlCommandLink link, WebXmlParameters parameters) {
        Boolean disableRegion = link.isAjaxDisableRenderRegionsOnRequest();
        return disableRegion != null ? disableRegion.booleanValue() : parameters.isAjaxDisableRenderRegionsOnRequest();
    }

    private String createDisableOnClickFunctionCall(HtmlCommandLink link, String processingText, String processingGlyphicon, String jQueryIDSelector) {
        StringBuilder sb = new StringBuilder();
        sb.append("    ButterFaces.CommandLink.disableOnClick(data, ");
        sb.append(link.isAjaxShowWaitingDotsOnRequest()).append(",");
        if (link.getValue() != null) {
            sb.append("'").append(link.getValue()).append("'");
        } else {
            sb.append("null");
        }
        sb.append(",'");
        sb.append(processingText).append("','");
        sb.append(link.getGlyphicon()).append("','");
        sb.append(processingGlyphicon).append("',");
        sb.append(link.isAjaxHideGlyphiconOnRequest()).append(",'");
        sb.append(jQueryIDSelector).append("');");
        return sb.toString();
    }

    private String createAjaxProcessingText(HtmlCommandLink link) {
        if (StringUtils.isNotEmpty(link.getAjaxProcessingTextOnRequest())) {
            return link.getAjaxProcessingTextOnRequest();
        }
        return this.webXmlParameters.getAjaxProcessingTextOnRequest();
    }

    private String createAjaxProcessingGlyphicon(HtmlCommandLink link) {
        if (StringUtils.isNotEmpty(link.getAjaxProcessingGlyphiconOnRequest())) {
            return link.getAjaxProcessingGlyphiconOnRequest();
        }
        return this.webXmlParameters.getAjaxProcessingGlyphiconOnRequest();
    }

    private void writeValue(UIComponent component, ResponseWriter writer) throws IOException {
        String label;
        HtmlCommandLink commandLink = (HtmlCommandLink)component;
        this.writeGlyphiconIfNecessary(commandLink, writer);
        writer.startElement("span", component);
        writer.writeAttribute("class", (Object)"butter-component-glyphicon-text", null);
        Object value = ((UICommand)component).getValue();
        if (value != null && StringUtils.isNotEmpty(label = value.toString())) {
            writer.writeText((Object)label, component, null);
        }
        writer.endElement("span");
        this.writeWaitingDotsIfNecessary(commandLink, writer);
    }

    private void renderAsActive(FacesContext context, UIComponent component) throws IOException {
        HtmlCommandLink link = (HtmlCommandLink)component;
        ResponseWriter writer = context.getResponseWriter();
        AjaxBehavior ajaxBehavior = ClientBehaviorResolver.findFirstActiveAjaxBehavior((UIComponentBase)link, "action");
        if (link.isAjaxDisableLinkOnRequest() && ajaxBehavior != null) {
            if (StringUtils.isNotEmpty(ajaxBehavior.getOnevent())) {
                this.onEventCallback = ajaxBehavior.getOnevent();
            }
            ajaxBehavior.setOnevent(this.getOnEventListenerName(component));
            ajaxBehavior.setOnerror(this.getOnEventListenerName(component));
        }
        writer.startElement("a", (UIComponent)link);
        this.writeIdAttributeIfNecessary(context, writer, (UIComponent)link);
        writer.writeAttribute("href", (Object)"#", "href");
        this.renderBooleanValue(component, writer, "disabled");
        this.renderBooleanValue(component, writer, "ismap");
        this.renderStringValue(component, writer, "title");
        this.renderStringValue(component, writer, "tabindex");
        this.renderStringValue(component, writer, "style");
        this.renderStringValue(component, writer, "target");
        this.renderStringValue(component, writer, "accesskey");
        this.renderStringValue(component, writer, "charset");
        this.renderStringValue(component, writer, "coords");
        this.renderStringValue(component, writer, "dir");
        this.renderStringValue(component, writer, "hreflang");
        this.renderStringValue(component, writer, "lang");
        this.renderStringValue(component, writer, "rel");
        this.renderStringValue(component, writer, "rev");
        this.renderStringValue(component, writer, "shape");
        this.renderStringValue(component, writer, "type");
        this.renderEventValue(component, writer, "onkeydown", "keydown");
        this.renderEventValue(component, writer, "onkeyup", "keyup");
        this.renderEventValue(component, writer, "onblur", "blur");
        if (ajaxBehavior != null) {
            this.renderOnClickEventValue(component, writer, new JsfAjaxRequest((UIComponentBase)link, ajaxBehavior, "action").toString());
        } else {
            String submitHandler = CommandLinkRenderer.buildJavaScriptFormSubmitCall(context, component, this.getTrimmedTarget(component));
            this.renderOnClickEventValue(component, writer, submitHandler);
        }
        this.renderEventValue(component, writer, "ondblclick", "dblclick");
        this.renderEventValue(component, writer, "onfocus", "focus");
        this.renderEventValue(component, writer, "onkeypress", "keypress");
        this.renderEventValue(component, writer, "onmousedown", "mousedown");
        this.renderEventValue(component, writer, "onmousemove", "mousemove");
        this.renderEventValue(component, writer, "onmouseout", "mouseout");
        this.renderEventValue(component, writer, "onmouseover", "mouseover");
        this.renderEventValue(component, writer, "onmouseup", "mouseup");
        this.writeStyleClass(writer, (UIComponent)link);
        this.writeValue((UIComponent)link, writer);
        if (ajaxBehavior != null) {
            ajaxBehavior.setOnevent(this.onEventCallback);
        }
    }

    private String getTrimmedTarget(UIComponent component) throws IOException {
        Object target = component.getAttributes().get("target");
        if (target != null && StringUtils.isNotEmpty(target.toString())) {
            return target.toString().trim();
        }
        return null;
    }

    private static String buildJavaScriptFormSubmitCall(FacesContext context, UIComponent component, String submitTarget) {
        Collection<ClientBehaviorContext.Parameter> params = CommandLinkRenderer.findBehaviorParameters(component);
        StringBuilder builder = new StringBuilder(256);
        String formClientId = UIComponentResolver.getFormClientId(component, context);
        String componentClientId = component.getClientId(context);
        builder.append("ButterFaces.CommandLink.submitForm('");
        builder.append(formClientId);
        builder.append("',{");
        ParameterAppender.appendProperty(builder, componentClientId, componentClientId);
        if (null != params && !params.isEmpty()) {
            for (ClientBehaviorContext.Parameter param : params) {
                ParameterAppender.appendProperty(builder, param.getName(), param.getValue());
            }
        }
        builder.append("},'");
        if (submitTarget != null) {
            builder.append(submitTarget);
        }
        builder.append("')");
        return builder.toString();
    }

    private static Collection<ClientBehaviorContext.Parameter> findBehaviorParameters(UIComponent component) {
        int childCount = component.getChildCount();
        ArrayList<ClientBehaviorContext.Parameter> params = null;
        if (childCount > 0) {
            for (UIComponent kid : component.getChildren()) {
                if (!(kid instanceof UIParameter)) continue;
                UIParameter uiParam = (UIParameter)kid;
                String name = uiParam.getName();
                Object value = uiParam.getValue();
                if (!StringUtils.isNotEmpty(name)) continue;
                if (params == null) {
                    params = new ArrayList<ClientBehaviorContext.Parameter>(childCount);
                }
                params.add(new ClientBehaviorContext.Parameter(name, value));
            }
        }
        return params == null ? Collections.emptyList() : params;
    }

    private void renderOnClickEventValue(UIComponent component, ResponseWriter writer, String onClickEvent) throws IOException {
        String componentEventFunction = this.createComponentEventFunction(component, "onclick");
        if (componentEventFunction != null) {
            writer.writeAttribute("onclick", (Object)(onClickEvent + ";" + componentEventFunction + ";return false"), "onclick");
        } else {
            writer.writeAttribute("onclick", (Object)(onClickEvent + ";return false"), "onclick");
        }
    }

    private void writeStyleClass(ResponseWriter writer, UIComponent component) throws IOException {
        String generatedStyleClass;
        HtmlCommandLink link = (HtmlCommandLink)component;
        String styleClass = (String)component.getAttributes().get("styleClass");
        StringJoiner generatedStyleClassJoiner = StringJoiner.on(' ').join(StringUtils.getNotNullValue(styleClass, ""));
        if (link.isDisabled()) {
            generatedStyleClassJoiner = generatedStyleClassJoiner.join("btn-disabled disabled");
        }
        if (StringUtils.isEmpty(link.getGlyphicon())) {
            generatedStyleClassJoiner = generatedStyleClassJoiner.join("no-glyphicon");
        }
        if ((generatedStyleClass = generatedStyleClassJoiner.toString()).length() > 0) {
            writer.writeAttribute("class", (Object)generatedStyleClass, "styleClass");
        }
    }

    private String getOnEventListenerName(UIComponent component) {
        char separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance());
        return "glyphiconLinkListener_" + component.getClientId().replace(separatorChar + "", "_");
    }

    private void writeWaitingDotsIfNecessary(HtmlCommandLink commandLink, ResponseWriter writer) throws IOException {
        if (commandLink.isAjaxDisableLinkOnRequest()) {
            writer.startElement("span", (UIComponent)commandLink);
            writer.writeAttribute("class", (Object)"butter-component-glyphicon-processing", null);
            writer.endElement("span");
        }
    }

    private void writeGlyphiconIfNecessary(HtmlCommandLink commandLink, ResponseWriter writer) throws IOException {
        String glyphicon = StringUtils.getNotNullValue(commandLink.getGlyphicon(), "");
        writer.startElement("span", (UIComponent)commandLink);
        writer.writeAttribute("class", (Object)("butter-component-glyphicon " + glyphicon), null);
        writer.endElement("span");
    }
}

