/*
 * Decompiled with CFR 0.152.
 */
package org.butterfaces.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.butterfaces.util.StringUtils;

public class ReflectionUtil {
    public static final char ATTRIBUTE_SEPARATOR = '.';

    public String getStringValueFromObject(Object object, String fieldName) {
        return this.convertToString(this.getValueFromObject(object, fieldName, Object.class));
    }

    public <T> T getValueFromObject(Object object, String fieldName, Class<T> valueClass) {
        int indexOfFirstDot = fieldName.indexOf(this.getAttributeSeparator());
        if (indexOfFirstDot > 0) {
            String firstFieldName = fieldName.substring(0, indexOfFirstDot);
            String restOfFieldName = fieldName.substring(indexOfFirstDot + 1);
            Object innerObject = this.getPlainValueFromObject(object, firstFieldName);
            return this.getValueFromObject(innerObject, restOfFieldName, valueClass);
        }
        return (T)this.getPlainValueFromObject(object, fieldName);
    }

    protected char getAttributeSeparator() {
        return '.';
    }

    private Object getPlainValueFromObject(Object object, String fieldName) {
        Object value = this.getValuePropertyByField(object, fieldName, Object.class);
        if (value == null) {
            value = this.getValuePropertyByGetter(object, fieldName, Object.class);
        }
        return value;
    }

    private <T> T getValuePropertyByField(Object object, String fieldName, Class<T> valueClass) {
        try {
            Field declaredField = object.getClass().getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return (T)declaredField.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            return null;
        }
    }

    private <T> T getValuePropertyByGetter(Object object, String fieldName, Class<T> valueClass) {
        try {
            Method method = object.getClass().getMethod("get" + this.toUpperCase(fieldName), new Class[0]);
            Object valueObject = method.invoke(object, (Object[])null);
            return (T)valueObject;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    private String toUpperCase(String str) {
        return Character.toString(str.charAt(0)).toUpperCase() + str.substring(1);
    }

    private String convertToString(Object object) {
        String rowIdentifierAsString;
        if (object != null && StringUtils.isNotEmpty(rowIdentifierAsString = object.toString())) {
            return rowIdentifierAsString;
        }
        return null;
    }
}

