/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.parser;

import io.restassured.response.Response;
import org.catools.common.text.CStringUtil;
import org.catools.zapi.exception.CZApiClientException;
import org.catools.zapi.model.CZApiCycle;
import org.catools.zapi.model.CZApiCycles;
import org.catools.zapi.model.CZApiProject;
import org.catools.zapi.model.CZApiProjects;
import org.catools.zapi.model.CZApiVersion;
import org.catools.zapi.parser.CZApiBaseParser;
import org.json.JSONArray;
import org.json.JSONObject;

public class CZApiCyclesParser
extends CZApiBaseParser {
    public static CZApiCycles parse(CZApiProject project, Response response) {
        CZApiCycles output = new CZApiCycles();
        try {
            JSONObject input = new JSONObject(response.body().asString());
            JSONArray names = input.names();
            for (int i = 0; i < names.length(); ++i) {
                String key = names.getString(i);
                if (CStringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"recordsCount")) continue;
                JSONObject json = input.getJSONObject(key);
                if (project.getId().longValue() != json.optLong("projectId")) continue;
                output.add(CZApiCyclesParser.parseCzApiCycle(project.setId(json.optLong("projectId")), key, json));
            }
        }
        catch (Throwable t) {
            throw new CZApiClientException("Could not parse input to JSON Array. input: " + response.body().asString(), t);
        }
        return output;
    }

    public static CZApiCycles parse(CZApiProjects projects, Response response) {
        CZApiCycles output = new CZApiCycles();
        try {
            JSONObject input = new JSONObject(response.body().asString());
            JSONArray names = input.names();
            for (int i = 0; i < names.length(); ++i) {
                String key = names.getString(i);
                if (CStringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"recordsCount")) continue;
                JSONObject json = input.getJSONObject(key);
                output.add(CZApiCyclesParser.parseCzApiCycle(projects.getById(json.optLong("projectId")), key, json));
            }
        }
        catch (Throwable t) {
            throw new CZApiClientException("Could not parse input to JSON Array. input: " + response.body().asString(), t);
        }
        return output;
    }

    private static CZApiCycle parseCzApiCycle(CZApiProject project, String key, JSONObject json) {
        CZApiCycle cycle = new CZApiCycle();
        cycle.setId(Long.valueOf(key));
        cycle.setProject(project);
        cycle.setVersion(new CZApiVersion(json.optLong("versionId"), json.optString("versionName")));
        cycle.setDescription(json.optString("description"));
        cycle.setStartDate(CZApiCyclesParser.getDate(json, "startDate"));
        cycle.setEndDate(CZApiCyclesParser.getDate(json, "endDate"));
        cycle.setEnvironment(json.optString("environment"));
        cycle.setBuild(json.optString("build"));
        cycle.setName(json.optString("name"));
        cycle.setModifiedBy(CStringUtil.removeEnd((String)json.optString("modifiedBy"), (String)"(Inactive)"));
        return cycle;
    }
}

