/*
 * Decompiled with CFR 0.152.
 */
package org.catools.zapi.rest.cycle;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.specification.RequestSpecification;
import java.util.Date;
import org.catools.common.date.CDate;
import org.catools.common.extensions.verify.CVerify;
import org.catools.zapi.CZApiClient;
import org.catools.zapi.configs.CZApiConfigs;
import org.catools.zapi.exception.CZApiException;
import org.catools.zapi.model.CZApiCycle;
import org.catools.zapi.model.CZApiCycles;
import org.catools.zapi.model.CZApiProject;
import org.catools.zapi.model.CZApiProjects;
import org.catools.zapi.model.CZApiVersion;
import org.catools.zapi.parser.CZApiCycleParser;
import org.catools.zapi.parser.CZApiCyclesParser;
import org.catools.zapi.rest.CZApiRestClient;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;

public class CZApiCycleClient
extends CZApiRestClient {
    public CZApiCycles getAllCycle(CZApiProject project, CZApiVersion version) {
        RequestSpecification specification = RestAssured.given().baseUri(CZApiConfigs.ZApi.getZApiUri()).basePath("/cycle").queryParam("projectId", new Object[]{project.getId()}).queryParam("versionId", new Object[]{version.getId()});
        return CZApiCyclesParser.parse(project, this.get(specification));
    }

    public CZApiCycle getCycleById(long cycleId) {
        CZApiProjects projects = CZApiClient.Project.getProjects();
        return CZApiCycleParser.parse(projects, this.get(String.format("/cycle/%s", cycleId)));
    }

    public long createCycle(CZApiCycle cycle) {
        return this.cloneCycle(null, cycle);
    }

    public long createCycle(String name, String build, String environment, String description, Date startDate, Date endDate, Long projectId, Long versionId) {
        return this.cloneCycle(null, name, build, environment, description, startDate, endDate, projectId, versionId);
    }

    public long cloneCycle(Long clonedCycleId, CZApiCycle cycle) {
        return this.cloneCycle(clonedCycleId, cycle.getName(), cycle.getBuild(), cycle.getEnvironment(), cycle.getDescription(), (Date)cycle.getStartDate(), (Date)cycle.getEndDate(), cycle.getProject().getId(), cycle.getVersion().getId());
    }

    public long cloneCycle(Long clonedCycleId, String name, String build, String environment, String description, Date startDate, Date endDate, Long projectId, Long versionId) {
        JSONObject entity = new JSONObject();
        try {
            entity.put("clonedCycleId", (Object)clonedCycleId).put("name", (Object)name).put("build", (Object)build).put("environment", (Object)environment).put("description", (Object)description).put("startDate", (Object)new CDate(startDate).toFormat("dd/MMM/yyyy")).put("endDate", (Object)new CDate(endDate).toFormat("dd/MMM/yyyy")).put("projectId", (Object)projectId).put("versionId", (Object)versionId);
        }
        catch (Throwable t) {
            throw new CZApiException("Could convert", t);
        }
        RequestSpecification specification = RestAssured.given().baseUri(CZApiConfigs.ZApi.getZApiUri()).basePath("/cycle").body((Object)entity);
        Response response = this.post(specification);
        try {
            String id = (String)response.body().jsonPath().get("id");
            new CVerify((Logger)CZApiCycleClient.logger).String.isNotBlank(id, "Test cycle has been created.", new Object[0]);
            return Long.valueOf(id);
        }
        catch (Throwable t) {
            throw new CZApiException("Failed to parse response\n" + response.getBody(), t);
        }
    }
}

