/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2.securitygroups;

import org.cloudfoundry.client.v2.securitygroups.AssociateSecurityGroupSpaceRequest;
import org.cloudfoundry.client.v2.securitygroups.AssociateSecurityGroupSpaceResponse;
import org.cloudfoundry.client.v2.securitygroups.CreateSecurityGroupRequest;
import org.cloudfoundry.client.v2.securitygroups.CreateSecurityGroupResponse;
import org.cloudfoundry.client.v2.securitygroups.DeleteSecurityGroupRequest;
import org.cloudfoundry.client.v2.securitygroups.DeleteSecurityGroupResponse;
import org.cloudfoundry.client.v2.securitygroups.GetSecurityGroupRequest;
import org.cloudfoundry.client.v2.securitygroups.GetSecurityGroupResponse;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupRunningDefaultsRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupRunningDefaultsResponse;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupSpacesRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupSpacesResponse;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupStagingDefaultsRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupStagingDefaultsResponse;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupsRequest;
import org.cloudfoundry.client.v2.securitygroups.ListSecurityGroupsResponse;
import org.cloudfoundry.client.v2.securitygroups.RemoveSecurityGroupRunningDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.RemoveSecurityGroupSpaceRequest;
import org.cloudfoundry.client.v2.securitygroups.RemoveSecurityGroupStagingDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.SecurityGroups;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupRunningDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupRunningDefaultResponse;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupStagingDefaultRequest;
import org.cloudfoundry.client.v2.securitygroups.SetSecurityGroupStagingDefaultResponse;
import org.cloudfoundry.client.v2.securitygroups.UpdateSecurityGroupRequest;
import org.cloudfoundry.client.v2.securitygroups.UpdateSecurityGroupResponse;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.v2.AbstractClientV2Operations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class ReactorSecurityGroups
extends AbstractClientV2Operations
implements SecurityGroups {
    public ReactorSecurityGroups(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<AssociateSecurityGroupSpaceResponse> associateSpace(AssociateSecurityGroupSpaceRequest request) {
        return this.put(request, AssociateSecurityGroupSpaceResponse.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId(), "spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<CreateSecurityGroupResponse> create(CreateSecurityGroupRequest request) {
        return this.post(request, CreateSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"security_groups"})).checkpoint();
    }

    public Mono<DeleteSecurityGroupResponse> delete(DeleteSecurityGroupRequest request) {
        return this.delete(request, DeleteSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<GetSecurityGroupResponse> get(GetSecurityGroupRequest request) {
        return this.get((Object)request, GetSecurityGroupResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<ListSecurityGroupsResponse> list(ListSecurityGroupsRequest request) {
        return this.get((Object)request, ListSecurityGroupsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"security_groups"})).checkpoint();
    }

    public Mono<ListSecurityGroupRunningDefaultsResponse> listRunningDefaults(ListSecurityGroupRunningDefaultsRequest request) {
        return this.get((Object)request, ListSecurityGroupRunningDefaultsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"config", "running_security_groups"})).checkpoint();
    }

    public Mono<ListSecurityGroupSpacesResponse> listSpaces(ListSecurityGroupSpacesRequest request) {
        return this.get((Object)request, ListSecurityGroupSpacesResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId(), "spaces"})).checkpoint();
    }

    public Mono<ListSecurityGroupStagingDefaultsResponse> listStagingDefaults(ListSecurityGroupStagingDefaultsRequest request) {
        return this.get((Object)request, ListSecurityGroupStagingDefaultsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"config", "staging_security_groups"})).checkpoint();
    }

    public Mono<Void> removeRunningDefault(RemoveSecurityGroupRunningDefaultRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"config", "running_security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<Void> removeSpace(RemoveSecurityGroupSpaceRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId(), "spaces", request.getSpaceId()})).checkpoint();
    }

    public Mono<Void> removeStagingDefault(RemoveSecurityGroupStagingDefaultRequest request) {
        return this.delete(request, Void.class, builder -> builder.pathSegment(new String[]{"config", "staging_security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<SetSecurityGroupRunningDefaultResponse> setRunningDefault(SetSecurityGroupRunningDefaultRequest request) {
        return this.put(request, SetSecurityGroupRunningDefaultResponse.class, builder -> builder.pathSegment(new String[]{"config", "running_security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<SetSecurityGroupStagingDefaultResponse> setStagingDefault(SetSecurityGroupStagingDefaultRequest request) {
        return this.put(request, SetSecurityGroupStagingDefaultResponse.class, builder -> builder.pathSegment(new String[]{"config", "staging_security_groups", request.getSecurityGroupId()})).checkpoint();
    }

    public Mono<UpdateSecurityGroupResponse> update(UpdateSecurityGroupRequest request) {
        return this.put(request, UpdateSecurityGroupResponse.class, builder -> builder.pathSegment(new String[]{"security_groups", request.getSecurityGroupId()})).checkpoint();
    }
}

