/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.routing;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.routing._ReactorRoutingClient;
import org.cloudfoundry.routing.v1.routergroups.RouterGroups;
import org.cloudfoundry.routing.v1.tcproutes.TcpRoutes;
import org.immutables.value.Generated;
import reactor.core.publisher.Mono;

@Generated(from="_ReactorRoutingClient", generator="Immutables")
public final class ReactorRoutingClient
extends _ReactorRoutingClient {
    private final transient RouterGroups routerGroups;
    private final transient TcpRoutes tcpRoutes;
    private final ConnectionContext connectionContext;
    private final Mono<String> root;
    private final TokenProvider tokenProvider;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ReactorRoutingClient(Builder builder) {
        this.connectionContext = builder.connectionContext;
        this.tokenProvider = builder.tokenProvider;
        if (builder.root != null) {
            this.initShim.root((Mono<String>)builder.root);
        }
        this.routerGroups = this.initShim.routerGroups();
        this.tcpRoutes = this.initShim.tcpRoutes();
        this.root = this.initShim.getRoot();
        this.initShim = null;
    }

    @Override
    public RouterGroups routerGroups() {
        InitShim shim = this.initShim;
        return shim != null ? shim.routerGroups() : this.routerGroups;
    }

    @Override
    public TcpRoutes tcpRoutes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tcpRoutes() : this.tcpRoutes;
    }

    @Override
    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public Mono<String> getRoot() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRoot() : this.root;
    }

    @Override
    public TokenProvider getTokenProvider() {
        return this.tokenProvider;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReactorRoutingClient && this.equalTo((ReactorRoutingClient)another);
    }

    private boolean equalTo(ReactorRoutingClient another) {
        return this.routerGroups.equals(another.routerGroups) && this.tcpRoutes.equals(another.tcpRoutes) && this.connectionContext.equals(another.connectionContext) && this.root.equals(another.root) && this.tokenProvider.equals(another.tokenProvider);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.routerGroups.hashCode();
        h += (h << 5) + this.tcpRoutes.hashCode();
        h += (h << 5) + this.connectionContext.hashCode();
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.tokenProvider.hashCode();
        return h;
    }

    public String toString() {
        return "ReactorRoutingClient{routerGroups=" + this.routerGroups + ", tcpRoutes=" + this.tcpRoutes + ", connectionContext=" + this.connectionContext + ", root=" + this.root + ", tokenProvider=" + this.tokenProvider + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_ReactorRoutingClient", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CONNECTION_CONTEXT = 1L;
        private static final long INIT_BIT_TOKEN_PROVIDER = 2L;
        private long initBits = 3L;
        private ConnectionContext connectionContext;
        private Mono<String> root;
        private TokenProvider tokenProvider;

        private Builder() {
        }

        public final Builder from(ReactorRoutingClient instance) {
            return this.from((_ReactorRoutingClient)instance);
        }

        final Builder from(_ReactorRoutingClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.connectionContext(instance.getConnectionContext());
            this.root(instance.getRoot());
            this.tokenProvider(instance.getTokenProvider());
            return this;
        }

        public final Builder connectionContext(ConnectionContext connectionContext) {
            this.connectionContext = Objects.requireNonNull(connectionContext, "connectionContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder root(Mono<String> root) {
            this.root = Objects.requireNonNull(root, "root");
            return this;
        }

        public final Builder tokenProvider(TokenProvider tokenProvider) {
            this.tokenProvider = Objects.requireNonNull(tokenProvider, "tokenProvider");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ReactorRoutingClient build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ReactorRoutingClient(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectionContext");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tokenProvider");
            }
            return "Cannot build ReactorRoutingClient, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="_ReactorRoutingClient", generator="Immutables")
    private final class InitShim {
        private byte routerGroupsBuildStage = 0;
        private RouterGroups routerGroups;
        private byte tcpRoutesBuildStage = 0;
        private TcpRoutes tcpRoutes;
        private byte rootBuildStage = 0;
        private Mono<String> root;

        private InitShim() {
        }

        RouterGroups routerGroups() {
            if (this.routerGroupsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.routerGroupsBuildStage == 0) {
                this.routerGroupsBuildStage = (byte)-1;
                this.routerGroups = Objects.requireNonNull(ReactorRoutingClient.super.routerGroups(), "routerGroups");
                this.routerGroupsBuildStage = 1;
            }
            return this.routerGroups;
        }

        TcpRoutes tcpRoutes() {
            if (this.tcpRoutesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tcpRoutesBuildStage == 0) {
                this.tcpRoutesBuildStage = (byte)-1;
                this.tcpRoutes = Objects.requireNonNull(ReactorRoutingClient.super.tcpRoutes(), "tcpRoutes");
                this.tcpRoutesBuildStage = 1;
            }
            return this.tcpRoutes;
        }

        Mono<String> getRoot() {
            if (this.rootBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rootBuildStage == 0) {
                this.rootBuildStage = (byte)-1;
                this.root = Objects.requireNonNull(ReactorRoutingClient.super.getRoot(), "root");
                this.rootBuildStage = 1;
            }
            return this.root;
        }

        void root(Mono<String> root) {
            this.root = root;
            this.rootBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.routerGroupsBuildStage == -1) {
                attributes.add("routerGroups");
            }
            if (this.tcpRoutesBuildStage == -1) {
                attributes.add("tcpRoutes");
            }
            if (this.rootBuildStage == -1) {
                attributes.add("root");
            }
            return "Cannot build ReactorRoutingClient, attribute initializers form cycle " + attributes;
        }
    }
}

