/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa;

import java.util.function.Function;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.UsernameProvider;
import org.cloudfoundry.reactor.uaa.authorizations.ReactorAuthorizations;
import org.cloudfoundry.reactor.uaa.clients.ReactorClients;
import org.cloudfoundry.reactor.uaa.groups.ReactorGroups;
import org.cloudfoundry.reactor.uaa.identityproviders.ReactorIdentityProviders;
import org.cloudfoundry.reactor.uaa.identityzones.ReactorIdentityZones;
import org.cloudfoundry.reactor.uaa.serverinformation.ReactorServerInformation;
import org.cloudfoundry.reactor.uaa.tokens.ReactorTokens;
import org.cloudfoundry.reactor.uaa.users.ReactorUsers;
import org.cloudfoundry.uaa.UaaClient;
import org.cloudfoundry.uaa.authorizations.Authorizations;
import org.cloudfoundry.uaa.clients.Clients;
import org.cloudfoundry.uaa.groups.Groups;
import org.cloudfoundry.uaa.identityproviders.IdentityProviders;
import org.cloudfoundry.uaa.identityzones.IdentityZones;
import org.cloudfoundry.uaa.serverinformation.ServerInformation;
import org.cloudfoundry.uaa.tokens.Tokens;
import org.cloudfoundry.uaa.users.Users;
import org.immutables.value.Value;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

@Value.Immutable
abstract class _ReactorUaaClient
implements UaaClient {
    _ReactorUaaClient() {
    }

    @Value.Derived
    public Authorizations authorizations() {
        return new ReactorAuthorizations(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Derived
    public Clients clients() {
        return new ReactorClients(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Derived
    public Mono<String> getUsername() {
        return this.getUsernameProvider().get();
    }

    @Value.Derived
    public Groups groups() {
        return new ReactorGroups(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Derived
    public IdentityProviders identityProviders() {
        return new ReactorIdentityProviders(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Derived
    public IdentityZones identityZones() {
        return new ReactorIdentityZones(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Derived
    public ServerInformation serverInformation() {
        return new ReactorServerInformation(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Derived
    public Tokens tokens() {
        return new ReactorTokens(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    @Value.Derived
    public Users users() {
        return new ReactorUsers(this.getConnectionContext(), this.getRoot(), this.getTokenProvider());
    }

    abstract ConnectionContext getConnectionContext();

    @Nullable
    abstract String getIdentityZoneSubdomain();

    @Value.Default
    Mono<String> getRoot() {
        Mono cached = this.getConnectionContext().getRootProvider().getRoot("uaa", this.getConnectionContext()).map(_ReactorUaaClient.getIdentityZoneEndpoint(this.getIdentityZoneSubdomain()));
        return this.getConnectionContext().getCacheDuration().map(arg_0 -> ((Mono)cached).cache(arg_0)).orElseGet(() -> ((Mono)cached).cache());
    }

    abstract TokenProvider getTokenProvider();

    @Value.Default
    UsernameProvider getUsernameProvider() {
        return new UsernameProvider(this.getConnectionContext(), this.getTokenProvider(), this.tokens());
    }

    private static Function<String, String> getIdentityZoneEndpoint(String identityZoneId) {
        return raw -> {
            if (identityZoneId == null) {
                return raw;
            }
            UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)raw);
            builder.host(String.format("%s.%s", identityZoneId, builder.build().getHost()));
            return builder.build().encode().toUriString();
        };
    }
}

