/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.tokens;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.util.AsciiString;
import java.util.Base64;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.uaa.ResponseType;
import org.cloudfoundry.uaa.tokens.CheckTokenRequest;
import org.cloudfoundry.uaa.tokens.CheckTokenResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByAuthorizationCodeRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByAuthorizationCodeResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByClientCredentialsRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByClientCredentialsResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByOneTimePasscodeRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByOneTimePasscodeResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByOpenIdRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByOpenIdResponse;
import org.cloudfoundry.uaa.tokens.GetTokenByPasswordRequest;
import org.cloudfoundry.uaa.tokens.GetTokenByPasswordResponse;
import org.cloudfoundry.uaa.tokens.GetTokenKeyRequest;
import org.cloudfoundry.uaa.tokens.GetTokenKeyResponse;
import org.cloudfoundry.uaa.tokens.GrantType;
import org.cloudfoundry.uaa.tokens.ListTokenKeysRequest;
import org.cloudfoundry.uaa.tokens.ListTokenKeysResponse;
import org.cloudfoundry.uaa.tokens.RefreshTokenRequest;
import org.cloudfoundry.uaa.tokens.RefreshTokenResponse;
import org.cloudfoundry.uaa.tokens.Tokens;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorTokens
extends AbstractUaaOperations
implements Tokens {
    private static final AsciiString BASIC_PREAMBLE = new AsciiString((CharSequence)"Basic ");

    public ReactorTokens(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<CheckTokenResponse> check(CheckTokenRequest request) {
        return this.post(request, CheckTokenResponse.class, builder -> builder.pathSegment(new String[]{"check_token"}), outbound -> {}, outbound -> {
            String encoded = Base64.getEncoder().encodeToString(new AsciiString((CharSequence)request.getClientId()).concat((CharSequence)":").concat((CharSequence)request.getClientSecret()).toByteArray());
            return Mono.just((Object)outbound.set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)(BASIC_PREAMBLE + encoded)));
        }).checkpoint();
    }

    public Mono<GetTokenByAuthorizationCodeResponse> getByAuthorizationCode(GetTokenByAuthorizationCodeRequest request) {
        return this.post(request, GetTokenByAuthorizationCodeResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{GrantType.AUTHORIZATION_CODE}).queryParam("response_type", new Object[]{ResponseType.TOKEN}), ReactorTokens::setUrlEncoded, ReactorTokens::removeAuthorization).checkpoint();
    }

    public Mono<GetTokenByClientCredentialsResponse> getByClientCredentials(GetTokenByClientCredentialsRequest request) {
        return this.post(request, GetTokenByClientCredentialsResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{GrantType.CLIENT_CREDENTIALS}).queryParam("response_type", new Object[]{ResponseType.TOKEN}), ReactorTokens::setUrlEncoded, ReactorTokens::removeAuthorization).checkpoint();
    }

    public Mono<GetTokenByOneTimePasscodeResponse> getByOneTimePasscode(GetTokenByOneTimePasscodeRequest request) {
        return this.post(request, GetTokenByOneTimePasscodeResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{GrantType.PASSWORD}).queryParam("response_type", new Object[]{ResponseType.TOKEN}), ReactorTokens::setUrlEncoded, ReactorTokens::removeAuthorization).checkpoint();
    }

    public Mono<GetTokenByOpenIdResponse> getByOpenId(GetTokenByOpenIdRequest request) {
        return this.post(request, GetTokenByOpenIdResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{GrantType.AUTHORIZATION_CODE}).queryParam("response_type", new Object[]{ResponseType.ID_TOKEN}), ReactorTokens::setUrlEncoded, ReactorTokens::removeAuthorization).checkpoint();
    }

    public Mono<GetTokenByPasswordResponse> getByPassword(GetTokenByPasswordRequest request) {
        return this.post(request, GetTokenByPasswordResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{GrantType.PASSWORD}).queryParam("response_type", new Object[]{ResponseType.TOKEN}), ReactorTokens::setUrlEncoded, ReactorTokens::removeAuthorization).checkpoint();
    }

    public Mono<GetTokenKeyResponse> getKey(GetTokenKeyRequest request) {
        return this.get((Object)request, GetTokenKeyResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"token_key"})).checkpoint();
    }

    public Mono<ListTokenKeysResponse> listKeys(ListTokenKeysRequest request) {
        return this.get((Object)request, ListTokenKeysResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"token_keys"})).checkpoint();
    }

    public Mono<RefreshTokenResponse> refresh(RefreshTokenRequest request) {
        return this.post(request, RefreshTokenResponse.class, builder -> builder.pathSegment(new String[]{"oauth", "token"}).queryParam("grant_type", new Object[]{GrantType.REFRESH_TOKEN}), ReactorTokens::setUrlEncoded, ReactorTokens::removeAuthorization).checkpoint();
    }

    private static Mono<HttpHeaders> removeAuthorization(HttpHeaders request) {
        return Mono.just((Object)request.remove((CharSequence)HttpHeaderNames.AUTHORIZATION));
    }

    private static void setUrlEncoded(HttpHeaders request) {
        request.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED);
    }
}

