/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.uaa.users;

import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.uaa.AbstractUaaOperations;
import org.cloudfoundry.uaa.users.ChangeUserPasswordRequest;
import org.cloudfoundry.uaa.users.ChangeUserPasswordResponse;
import org.cloudfoundry.uaa.users.CreateUserRequest;
import org.cloudfoundry.uaa.users.CreateUserResponse;
import org.cloudfoundry.uaa.users.DeleteUserRequest;
import org.cloudfoundry.uaa.users.DeleteUserResponse;
import org.cloudfoundry.uaa.users.ExpirePasswordRequest;
import org.cloudfoundry.uaa.users.ExpirePasswordResponse;
import org.cloudfoundry.uaa.users.GetUserVerificationLinkRequest;
import org.cloudfoundry.uaa.users.GetUserVerificationLinkResponse;
import org.cloudfoundry.uaa.users.InviteUsersRequest;
import org.cloudfoundry.uaa.users.InviteUsersResponse;
import org.cloudfoundry.uaa.users.ListUsersRequest;
import org.cloudfoundry.uaa.users.ListUsersResponse;
import org.cloudfoundry.uaa.users.LookupUserIdsRequest;
import org.cloudfoundry.uaa.users.LookupUserIdsResponse;
import org.cloudfoundry.uaa.users.UpdateUserRequest;
import org.cloudfoundry.uaa.users.UpdateUserResponse;
import org.cloudfoundry.uaa.users.UserInfoRequest;
import org.cloudfoundry.uaa.users.UserInfoResponse;
import org.cloudfoundry.uaa.users.Users;
import org.cloudfoundry.uaa.users.VerifyUserRequest;
import org.cloudfoundry.uaa.users.VerifyUserResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public final class ReactorUsers
extends AbstractUaaOperations
implements Users {
    public ReactorUsers(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    public Mono<ChangeUserPasswordResponse> changePassword(ChangeUserPasswordRequest request) {
        return this.put(request, ChangeUserPasswordResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getUserId(), "password"})).checkpoint();
    }

    public Mono<CreateUserResponse> create(CreateUserRequest request) {
        return this.post(request, CreateUserResponse.class, builder -> builder.pathSegment(new String[]{"Users"})).checkpoint();
    }

    public Mono<DeleteUserResponse> delete(DeleteUserRequest request) {
        return this.delete(request, DeleteUserResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getUserId()})).checkpoint();
    }

    public Mono<ExpirePasswordResponse> expirePassword(ExpirePasswordRequest request) {
        return this.patch(request, ExpirePasswordResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getUserId(), "status"})).checkpoint();
    }

    public Mono<GetUserVerificationLinkResponse> getVerificationLink(GetUserVerificationLinkRequest request) {
        return this.get((Object)request, GetUserVerificationLinkResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"Users", request.getUserId(), "verify-link"})).checkpoint();
    }

    public Mono<InviteUsersResponse> invite(InviteUsersRequest request) {
        return this.post(request, InviteUsersResponse.class, builder -> builder.pathSegment(new String[]{"invite_users"})).checkpoint();
    }

    public Mono<ListUsersResponse> list(ListUsersRequest request) {
        return this.get((Object)request, ListUsersResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"Users"})).checkpoint();
    }

    public Mono<LookupUserIdsResponse> lookup(LookupUserIdsRequest request) {
        return this.get((Object)request, LookupUserIdsResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"ids", "Users"})).checkpoint();
    }

    public Mono<UpdateUserResponse> update(UpdateUserRequest request) {
        return this.put(request, UpdateUserResponse.class, builder -> builder.pathSegment(new String[]{"Users", request.getId()})).checkpoint();
    }

    public Mono<UserInfoResponse> userInfo(UserInfoRequest request) {
        return this.get((Object)request, UserInfoResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"userinfo"})).checkpoint();
    }

    public Mono<VerifyUserResponse> verify(VerifyUserRequest request) {
        return this.get((Object)request, VerifyUserResponse.class, (UriComponentsBuilder builder) -> builder.pathSegment(new String[]{"Users", request.getUserId(), "verify"})).checkpoint();
    }
}

