/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.util.JsonCodec;
import org.cloudfoundry.reactor.util.Operator;
import org.cloudfoundry.reactor.util.OperatorContext;
import org.cloudfoundry.reactor.util.UserAgent;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public abstract class AbstractReactorOperations {
    protected static final String APPLICATION_ZIP = "application/zip";
    protected final ConnectionContext connectionContext;
    protected final Mono<String> root;
    protected final TokenProvider tokenProvider;

    protected AbstractReactorOperations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        this.connectionContext = connectionContext;
        this.root = root;
        this.tokenProvider = tokenProvider;
    }

    protected Mono<Operator> createOperator() {
        HttpClient httpClient = this.connectionContext.getHttpClient();
        return this.root.map(this::buildOperatorContext).map(context -> new Operator((OperatorContext)context, httpClient)).map(operator -> operator.headers(this::addHeaders)).map(operator -> operator.headersWhen(this::addHeadersWhen));
    }

    private void addHeaders(HttpHeaders httpHeaders) {
        UserAgent.setUserAgent(httpHeaders);
        JsonCodec.setDecodeHeaders(httpHeaders);
    }

    private Mono<? extends HttpHeaders> addHeadersWhen(HttpHeaders httpHeaders) {
        return this.tokenProvider.getToken(this.connectionContext).map(token -> httpHeaders.set((CharSequence)HttpHeaderNames.AUTHORIZATION, token));
    }

    private OperatorContext buildOperatorContext(String root) {
        return OperatorContext.builder().connectionContext(this.connectionContext).root(root).tokenProvider(this.tokenProvider).build();
    }
}

