/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpStatusClass;
import java.util.Map;
import java.util.function.Function;
import org.cloudfoundry.UnknownCloudFoundryException;
import org.cloudfoundry.client.v2.ClientV2Exception;
import org.cloudfoundry.client.v3.ClientV3Exception;
import org.cloudfoundry.client.v3.Errors;
import org.cloudfoundry.reactor.HttpClientResponseWithBody;
import org.cloudfoundry.reactor.util.ErrorPayloadMapper;
import org.cloudfoundry.uaa.UaaException;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClientResponse;

public final class ErrorPayloadMappers {
    public static ErrorPayloadMapper clientV2(ObjectMapper objectMapper) {
        return inbound -> inbound.flatMap(ErrorPayloadMappers.mapToError((statusCode, payload) -> {
            Map map = (Map)objectMapper.readValue(payload, Map.class);
            Integer code = (Integer)map.get("code");
            String description = (String)map.get("description");
            String errorCode = (String)map.get("error_code");
            return new ClientV2Exception(statusCode, code, description, errorCode);
        }));
    }

    public static ErrorPayloadMapper clientV3(ObjectMapper objectMapper) {
        return inbound -> inbound.flatMap(ErrorPayloadMappers.mapToError((statusCode, payload) -> {
            Errors errors = (Errors)objectMapper.readValue(payload, Errors.class);
            return new ClientV3Exception(statusCode, errors.getErrors());
        }));
    }

    public static ErrorPayloadMapper fallback() {
        return inbound -> inbound.flatMap(responseWithBody -> {
            HttpClientResponse response = responseWithBody.getResponse();
            if (ErrorPayloadMappers.isError(response)) {
                return responseWithBody.getBody().aggregate().asString().flatMap(payload -> Mono.error((Throwable)new UnknownCloudFoundryException(Integer.valueOf(response.status().code()), payload)));
            }
            return Mono.just((Object)responseWithBody);
        });
    }

    public static ErrorPayloadMapper uaa(ObjectMapper objectMapper) {
        return inbound -> inbound.flatMap(ErrorPayloadMappers.mapToError((statusCode, payload) -> {
            Map map = (Map)objectMapper.readValue(payload, Map.class);
            String error = (String)map.get("error");
            String errorDescription = (String)map.get("error_description");
            return new UaaException(statusCode, error, errorDescription);
        }));
    }

    private static boolean isError(HttpClientResponse response) {
        HttpStatusClass statusClass = response.status().codeClass();
        return statusClass == HttpStatusClass.CLIENT_ERROR || statusClass == HttpStatusClass.SERVER_ERROR;
    }

    private static Function<HttpClientResponseWithBody, Mono<HttpClientResponseWithBody>> mapToError(ExceptionGenerator exceptionGenerator) {
        return response -> {
            if (!ErrorPayloadMappers.isError(response.getResponse())) {
                return Mono.just((Object)response);
            }
            return response.getBody().aggregate().asString().switchIfEmpty(Mono.error((Throwable)new UnknownCloudFoundryException(Integer.valueOf(response.getResponse().status().code())))).flatMap(payload -> {
                try {
                    return Mono.error((Throwable)exceptionGenerator.apply(response.getResponse().status().code(), (String)payload));
                }
                catch (Exception e) {
                    return Mono.error((Throwable)new UnknownCloudFoundryException(Integer.valueOf(response.getResponse().status().code()), payload));
                }
            });
        };
    }

    @FunctionalInterface
    private static interface ExceptionGenerator {
        public RuntimeException apply(Integer var1, String var2) throws Exception;
    }
}

