/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.client.v2.FilterBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.cloudfoundry.reactor.util.ErrorPayloadMapper;
import org.cloudfoundry.reactor.util.MultipartHttpClientRequest;
import org.reactivestreams.Publisher;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientRequest;
import reactor.ipc.netty.http.client.HttpClientResponse;

public abstract class AbstractClientV2Operations
extends AbstractReactorOperations {
    private final ConnectionContext connectionContext;

    protected AbstractClientV2Operations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
        this.connectionContext = connectionContext;
    }

    protected final <T> Mono<T> delete(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doDelete(requestPayload, responseType, AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound, ErrorPayloadMapper.clientV2(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(responseType, AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound, ErrorPayloadMapper.clientV2(this.connectionContext.getObjectMapper()));
    }

    protected final Mono<HttpClientResponse> get(Object requestPayload, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<Mono<HttpClientRequest>, Mono<HttpClientRequest>> requestTransformer) {
        return this.doGet(AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.transform(requestTransformer), ErrorPayloadMapper.clientV2(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPost(requestPayload, responseType, AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound, ErrorPayloadMapper.clientV2(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> post(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<Mono<MultipartHttpClientRequest>, Publisher<Void>> requestTransformer) {
        return this.doPost(responseType, AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.map(AbstractClientV2Operations.multipartRequest(this.connectionContext.getObjectMapper())).transform(requestTransformer), ErrorPayloadMapper.clientV2(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPut(requestPayload, responseType, AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound, ErrorPayloadMapper.clientV2(this.connectionContext.getObjectMapper()));
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer, Function<Mono<MultipartHttpClientRequest>, Publisher<Void>> requestTransformer) {
        return this.doPut(responseType, AbstractClientV2Operations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound.map(AbstractClientV2Operations.multipartRequest(this.connectionContext.getObjectMapper())).transform(requestTransformer), ErrorPayloadMapper.clientV2(this.connectionContext.getObjectMapper()));
    }

    private static Function<HttpClientRequest, MultipartHttpClientRequest> multipartRequest(ObjectMapper objectMapper) {
        return request -> new MultipartHttpClientRequest(objectMapper, (HttpClientRequest)request);
    }

    private static Function<UriComponentsBuilder, UriComponentsBuilder> queryTransformer(Object requestPayload) {
        return builder -> {
            FilterBuilder.augment(builder, requestPayload);
            QueryBuilder.augment(builder, requestPayload);
            return builder;
        };
    }
}

