/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.client.v2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.cloudfoundry.client.v2.FilterParameter;
import org.cloudfoundry.reactor.client.MethodNameComparator;
import org.cloudfoundry.reactor.util.AnnotationUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.Exceptions;

final class FilterBuilder {
    private FilterBuilder() {
    }

    public static void augment(UriComponentsBuilder builder, Object instance) {
        Arrays.stream(instance.getClass().getMethods()).sorted(MethodNameComparator.INSTANCE).forEach(FilterBuilder.processMethod(builder, instance));
    }

    private static Optional<Object> getValue(Method method, Object instance) {
        try {
            return Optional.ofNullable(method.invoke(instance, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static Consumer<FilterParameter> processAnnotation(UriComponentsBuilder builder, Method method, Object instance) {
        return filterParameter -> FilterBuilder.getValue(method, instance).ifPresent(FilterBuilder.processValue(builder, filterParameter));
    }

    private static void processCollection(UriComponentsBuilder builder, FilterParameter filterParameter, Object value) {
        List collection = ((Collection)value).stream().map(o -> o.toString().trim()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        if (collection.size() == 1) {
            FilterBuilder.processValue(builder, filterParameter.value(), filterParameter.operation(), (String)collection.get(0));
        } else if (collection.size() > 1) {
            FilterBuilder.processValue(builder, filterParameter.value(), filterParameter.collectionOperation(), collection.stream().collect(Collectors.joining(",")));
        }
    }

    private static Consumer<Method> processMethod(UriComponentsBuilder builder, Object instance) {
        return method -> AnnotationUtils.findAnnotation(method, FilterParameter.class).ifPresent(FilterBuilder.processAnnotation(builder, method, instance));
    }

    private static Consumer<Object> processValue(UriComponentsBuilder builder, FilterParameter filterParameter) {
        return value -> {
            if (value instanceof Collection) {
                FilterBuilder.processCollection(builder, filterParameter, value);
            } else {
                FilterBuilder.processValue(builder, filterParameter.value(), filterParameter.operation(), value.toString().trim());
            }
        };
    }

    private static void processValue(UriComponentsBuilder builder, String name, FilterParameter.Operation operation, String value) {
        if (!value.isEmpty()) {
            builder.queryParam("q", new Object[]{String.format("%s%s%s", name, operation, value)});
        }
    }
}

