/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.networking;

import java.util.function.Function;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.QueryBuilder;
import org.cloudfoundry.reactor.util.AbstractReactorOperations;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClientResponse;

public abstract class AbstractNetworkingOperations
extends AbstractReactorOperations {
    protected AbstractNetworkingOperations(ConnectionContext connectionContext, Mono<String> root, TokenProvider tokenProvider) {
        super(connectionContext, root, tokenProvider);
    }

    protected final <T> Mono<T> get(Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(responseType, uriTransformer, outbound -> outbound, inbound -> inbound);
    }

    protected final <T> Mono<T> get(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(responseType, AbstractNetworkingOperations.queryTransformer(requestPayload).andThen(uriTransformer), outbound -> outbound, inbound -> inbound);
    }

    protected final Mono<HttpClientResponse> get(Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doGet(uriTransformer, outbound -> outbound, inbound -> inbound);
    }

    protected final <T> Mono<T> post(Object request, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPost(request, responseType, uriTransformer, outbound -> outbound, inbound -> inbound);
    }

    protected final <T> Mono<T> put(Object requestPayload, Class<T> responseType, Function<UriComponentsBuilder, UriComponentsBuilder> uriTransformer) {
        return this.doPut(requestPayload, responseType, uriTransformer, outbound -> outbound, inbound -> inbound);
    }

    private static Function<UriComponentsBuilder, UriComponentsBuilder> queryTransformer(Object requestPayload) {
        return builder -> {
            QueryBuilder.augment(builder, requestPayload);
            return builder;
        };
    }
}

