/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.reactor.util;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.cloudfoundry.reactor.ProxyConfiguration;
import org.cloudfoundry.reactor.util.CertificateCollectingTrustManager;
import org.cloudfoundry.reactor.util.SslCertificateTruster;
import org.cloudfoundry.reactor.util.StaticTrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.options.ClientOptions;
import reactor.ipc.netty.resources.LoopResources;
import reactor.ipc.netty.tcp.TcpClient;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public final class DefaultSslCertificateTruster
implements SslCertificateTruster {
    private final Logger logger = LoggerFactory.getLogger((String)"cloudfoundry-client.trust");
    private final AtomicReference<X509TrustManager> delegate;
    private final Optional<ProxyConfiguration> proxyConfiguration;
    private final LoopResources threadPool;
    private final Set<Tuple2<String, Integer>> trustedHostsAndPorts;

    public DefaultSslCertificateTruster(Optional<ProxyConfiguration> proxyConfiguration, LoopResources threadPool) {
        this.proxyConfiguration = proxyConfiguration;
        this.threadPool = threadPool;
        this.delegate = new AtomicReference<X509TrustManager>(DefaultSslCertificateTruster.getTrustManager(DefaultSslCertificateTruster.getTrustManagerFactory(null)));
        this.trustedHostsAndPorts = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.delegate.get().checkClientTrusted(x509Certificates, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        this.delegate.get().checkServerTrusted(x509Certificates, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.get().getAcceptedIssuers();
    }

    @Override
    public Mono<Void> trust(String host, int port, Duration duration) {
        Tuple2 hostAndPort = Tuples.of((Object)host, (Object)port);
        if (this.trustedHostsAndPorts.contains(hostAndPort)) {
            return Mono.empty();
        }
        this.logger.warn("Trusting SSL Certificate for {}:{}", (Object)host, (Object)port);
        X509TrustManager trustManager = this.delegate.get();
        return DefaultSslCertificateTruster.getUntrustedCertificates(duration, host, port, this.proxyConfiguration, this.threadPool, trustManager).doOnNext(untrustedCertificates -> {
            KeyStore trustStore = DefaultSslCertificateTruster.addToTrustStore(untrustedCertificates, trustManager);
            this.delegate.set(DefaultSslCertificateTruster.getTrustManager(DefaultSslCertificateTruster.getTrustManagerFactory(trustStore)));
        }).doOnSuccess(untrustedCertificates -> {
            this.trustedHostsAndPorts.add((Tuple2<String, Integer>)hostAndPort);
            this.logger.debug("Trusted SSL Certificate for {}:{}", (Object)host, (Object)port);
        }).then();
    }

    private static KeyStore addToTrustStore(X509Certificate[] untrustedCertificates, X509TrustManager trustManager) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            int count = 0;
            for (X509Certificate certificate : untrustedCertificates) {
                trustStore.setCertificateEntry(String.valueOf(count++), certificate);
            }
            for (X509Certificate certificate : trustManager.getAcceptedIssuers()) {
                trustStore.setCertificateEntry(String.valueOf(count++), certificate);
            }
            return trustStore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static TcpClient getTcpClient(Optional<ProxyConfiguration> proxyConfiguration, LoopResources threadPool, CertificateCollectingTrustManager collector, String host, int port) {
        return TcpClient.create(options -> {
            ((ClientOptions.Builder)options.host(host).port(port).loopResources(threadPool)).disablePool().sslSupport(ssl -> ssl.trustManager((TrustManagerFactory)((Object)new StaticTrustManagerFactory(collector))));
            proxyConfiguration.ifPresent(c -> c.configure((ClientOptions.Builder)options));
        });
    }

    private static X509TrustManager getTrustManager(TrustManagerFactory trustManagerFactory) {
        for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return (X509TrustManager)trustManager;
        }
        throw new IllegalStateException("No X509TrustManager in TrustManagerFactory");
    }

    private static TrustManagerFactory getTrustManagerFactory(KeyStore trustStore) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            return trustManagerFactory;
        }
        catch (KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static Mono<X509Certificate[]> getUntrustedCertificates(Duration duration, String host, int port, Optional<ProxyConfiguration> proxyConfiguration, LoopResources threadPool, X509TrustManager delegate) {
        CertificateCollectingTrustManager collector = new CertificateCollectingTrustManager(delegate);
        return DefaultSslCertificateTruster.getTcpClient(proxyConfiguration, threadPool, collector, host, port).newHandler((inbound, outbound) -> inbound.receive().then()).timeout(duration).handle((c, sink) -> {
            X509Certificate[] chain = collector.getCollectedCertificateChain();
            if (chain == null) {
                sink.error((Throwable)new IllegalStateException("Could not obtain server certificate chain"));
            }
            if (collector.isTrusted().booleanValue()) {
                sink.complete();
            } else {
                sink.next((Object)chain);
            }
        });
    }
}

