/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.doppler.ContainerMetric;
import org.cloudfoundry.doppler.CounterEvent;
import org.cloudfoundry.doppler.Error;
import org.cloudfoundry.doppler.EventType;
import org.cloudfoundry.doppler.HttpStartStop;
import org.cloudfoundry.doppler.LogMessage;
import org.cloudfoundry.doppler.ValueMetric;
import org.cloudfoundry.doppler._Envelope;
import org.immutables.value.Generated;

@Generated(from="_Envelope", generator="Immutables")
public final class Envelope
extends _Envelope {
    @Nullable
    private final ContainerMetric containerMetric;
    @Nullable
    private final CounterEvent counterEvent;
    @Nullable
    private final String deployment;
    @Nullable
    private final Error error;
    private final EventType eventType;
    @Nullable
    private final HttpStartStop httpStartStop;
    @Nullable
    private final String index;
    @Nullable
    private final String ip;
    @Nullable
    private final String job;
    @Nullable
    private final LogMessage logMessage;
    private final String origin;
    private final Map<String, String> tags;
    @Nullable
    private final Long timestamp;
    @Nullable
    private final ValueMetric valueMetric;

    private Envelope(Builder builder) {
        this.containerMetric = builder.containerMetric;
        this.counterEvent = builder.counterEvent;
        this.deployment = builder.deployment;
        this.error = builder.error;
        this.eventType = builder.eventType;
        this.httpStartStop = builder.httpStartStop;
        this.index = builder.index;
        this.ip = builder.ip;
        this.job = builder.job;
        this.logMessage = builder.logMessage;
        this.origin = builder.origin;
        this.tags = Envelope.createUnmodifiableMap(false, false, builder.tags);
        this.timestamp = builder.timestamp;
        this.valueMetric = builder.valueMetric;
    }

    @Override
    @Nullable
    public ContainerMetric getContainerMetric() {
        return this.containerMetric;
    }

    @Override
    @Nullable
    public CounterEvent getCounterEvent() {
        return this.counterEvent;
    }

    @Override
    @Nullable
    public String getDeployment() {
        return this.deployment;
    }

    @Override
    @Nullable
    public Error getError() {
        return this.error;
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    @Nullable
    public HttpStartStop getHttpStartStop() {
        return this.httpStartStop;
    }

    @Override
    @Nullable
    public String getIndex() {
        return this.index;
    }

    @Override
    @Nullable
    public String getIp() {
        return this.ip;
    }

    @Override
    @Nullable
    public String getJob() {
        return this.job;
    }

    @Override
    @Nullable
    public LogMessage getLogMessage() {
        return this.logMessage;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Override
    @Nullable
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    @Nullable
    public ValueMetric getValueMetric() {
        return this.valueMetric;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Envelope && this.equalTo((Envelope)another);
    }

    private boolean equalTo(Envelope another) {
        return Objects.equals(this.containerMetric, another.containerMetric) && Objects.equals(this.counterEvent, another.counterEvent) && Objects.equals(this.deployment, another.deployment) && Objects.equals(this.error, another.error) && this.eventType.equals((Object)another.eventType) && Objects.equals(this.httpStartStop, another.httpStartStop) && Objects.equals(this.index, another.index) && Objects.equals(this.ip, another.ip) && Objects.equals(this.job, another.job) && Objects.equals(this.logMessage, another.logMessage) && this.origin.equals(another.origin) && this.tags.equals(another.tags) && Objects.equals(this.timestamp, another.timestamp) && Objects.equals(this.valueMetric, another.valueMetric);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.containerMetric);
        h += (h << 5) + Objects.hashCode(this.counterEvent);
        h += (h << 5) + Objects.hashCode(this.deployment);
        h += (h << 5) + Objects.hashCode(this.error);
        h += (h << 5) + this.eventType.hashCode();
        h += (h << 5) + Objects.hashCode(this.httpStartStop);
        h += (h << 5) + Objects.hashCode(this.index);
        h += (h << 5) + Objects.hashCode(this.ip);
        h += (h << 5) + Objects.hashCode(this.job);
        h += (h << 5) + Objects.hashCode(this.logMessage);
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.tags.hashCode();
        h += (h << 5) + Objects.hashCode(this.timestamp);
        h += (h << 5) + Objects.hashCode(this.valueMetric);
        return h;
    }

    public String toString() {
        return "Envelope{containerMetric=" + this.containerMetric + ", counterEvent=" + this.counterEvent + ", deployment=" + this.deployment + ", error=" + this.error + ", eventType=" + (Object)((Object)this.eventType) + ", httpStartStop=" + this.httpStartStop + ", index=" + this.index + ", ip=" + this.ip + ", job=" + this.job + ", logMessage=" + this.logMessage + ", origin=" + this.origin + ", tags=" + this.tags + ", timestamp=" + this.timestamp + ", valueMetric=" + this.valueMetric + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_Envelope", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_EVENT_TYPE = 1L;
        private static final long INIT_BIT_ORIGIN = 2L;
        private long initBits = 3L;
        private ContainerMetric containerMetric;
        private CounterEvent counterEvent;
        private String deployment;
        private Error error;
        private EventType eventType;
        private HttpStartStop httpStartStop;
        private String index;
        private String ip;
        private String job;
        private LogMessage logMessage;
        private String origin;
        private Map<String, String> tags = new LinkedHashMap<String, String>();
        private Long timestamp;
        private ValueMetric valueMetric;

        private Builder() {
        }

        public final Builder from(Envelope instance) {
            return this.from((_Envelope)instance);
        }

        final Builder from(_Envelope instance) {
            ValueMetric valueMetricValue;
            LogMessage logMessageValue;
            String jobValue;
            String ipValue;
            String indexValue;
            Error errorValue;
            String deploymentValue;
            CounterEvent counterEventValue;
            Objects.requireNonNull(instance, "instance");
            ContainerMetric containerMetricValue = instance.getContainerMetric();
            if (containerMetricValue != null) {
                this.containerMetric(containerMetricValue);
            }
            if ((counterEventValue = instance.getCounterEvent()) != null) {
                this.counterEvent(counterEventValue);
            }
            if ((deploymentValue = instance.getDeployment()) != null) {
                this.deployment(deploymentValue);
            }
            if ((errorValue = instance.getError()) != null) {
                this.error(errorValue);
            }
            this.eventType(instance.getEventType());
            HttpStartStop httpStartStopValue = instance.getHttpStartStop();
            if (httpStartStopValue != null) {
                this.httpStartStop(httpStartStopValue);
            }
            if ((indexValue = instance.getIndex()) != null) {
                this.index(indexValue);
            }
            if ((ipValue = instance.getIp()) != null) {
                this.ip(ipValue);
            }
            if ((jobValue = instance.getJob()) != null) {
                this.job(jobValue);
            }
            if ((logMessageValue = instance.getLogMessage()) != null) {
                this.logMessage(logMessageValue);
            }
            this.origin(instance.getOrigin());
            this.putAllTags(instance.getTags());
            Long timestampValue = instance.getTimestamp();
            if (timestampValue != null) {
                this.timestamp(timestampValue);
            }
            if ((valueMetricValue = instance.getValueMetric()) != null) {
                this.valueMetric(valueMetricValue);
            }
            return this;
        }

        public final Builder containerMetric(@Nullable ContainerMetric containerMetric) {
            this.containerMetric = containerMetric;
            return this;
        }

        public final Builder counterEvent(@Nullable CounterEvent counterEvent) {
            this.counterEvent = counterEvent;
            return this;
        }

        public final Builder deployment(@Nullable String deployment) {
            this.deployment = deployment;
            return this;
        }

        public final Builder error(@Nullable Error error) {
            this.error = error;
            return this;
        }

        public final Builder eventType(EventType eventType) {
            this.eventType = Objects.requireNonNull(eventType, "eventType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder httpStartStop(@Nullable HttpStartStop httpStartStop) {
            this.httpStartStop = httpStartStop;
            return this;
        }

        public final Builder index(@Nullable String index) {
            this.index = index;
            return this;
        }

        public final Builder ip(@Nullable String ip) {
            this.ip = ip;
            return this;
        }

        public final Builder job(@Nullable String job) {
            this.job = job;
            return this;
        }

        public final Builder logMessage(@Nullable LogMessage logMessage) {
            this.logMessage = logMessage;
            return this;
        }

        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder tag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public final Builder tag(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.tags.put(k, v);
            return this;
        }

        public final Builder tags(Map<String, ? extends String> entries) {
            this.tags.clear();
            return this.putAllTags(entries);
        }

        public final Builder putAllTags(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.tags.put(k, v);
            }
            return this;
        }

        public final Builder timestamp(@Nullable Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final Builder valueMetric(@Nullable ValueMetric valueMetric) {
            this.valueMetric = valueMetric;
            return this;
        }

        public Envelope build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Envelope(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("eventType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("origin");
            }
            return "Cannot build Envelope, some of required attributes are not set " + attributes;
        }
    }
}

