/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.groups.MemberSummary;
import org.cloudfoundry.uaa.groups._CreateGroupRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateGroupRequest", generator="Immutables")
public final class CreateGroupRequest
extends _CreateGroupRequest {
    @Nullable
    private final String description;
    private final String displayName;
    @Nullable
    private final List<MemberSummary> members;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private CreateGroupRequest(Builder builder) {
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.members = builder.members == null ? null : CreateGroupRequest.createUnmodifiableList(true, builder.members);
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="members")
    @Nullable
    public List<MemberSummary> getMembers() {
        return this.members;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateGroupRequest && this.equalTo((CreateGroupRequest)another);
    }

    private boolean equalTo(CreateGroupRequest another) {
        return Objects.equals(this.description, another.description) && this.displayName.equals(another.displayName) && Objects.equals(this.members, another.members) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + Objects.hashCode(this.members);
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "CreateGroupRequest{description=" + this.description + ", displayName=" + this.displayName + ", members=" + this.members + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateGroupRequest fromJson(Json json) {
        Builder builder = CreateGroupRequest.builder();
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.displayName != null) {
            builder.displayName(json.displayName);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_CreateGroupRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DISPLAY_NAME = 1L;
        private long initBits = 1L;
        private String description;
        private String displayName;
        private List<MemberSummary> members = null;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CreateGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_CreateGroupRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _CreateGroupRequest) {
                instance = (_CreateGroupRequest)object;
                String descriptionValue = ((_CreateGroupRequest)instance).getDescription();
                if (descriptionValue != null) {
                    this.description(descriptionValue);
                }
                this.displayName(((_CreateGroupRequest)instance).getDisplayName());
                List<MemberSummary> membersValue = ((_CreateGroupRequest)instance).getMembers();
                if (membersValue != null) {
                    this.addAllMembers(membersValue);
                }
            }
        }

        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder member(MemberSummary element) {
            if (this.members == null) {
                this.members = new ArrayList<MemberSummary>();
            }
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder members(MemberSummary ... elements) {
            if (this.members == null) {
                this.members = new ArrayList<MemberSummary>();
            }
            for (MemberSummary element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        public final Builder members(@Nullable Iterable<? extends MemberSummary> elements) {
            if (elements == null) {
                this.members = null;
                return this;
            }
            this.members = new ArrayList<MemberSummary>();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends MemberSummary> elements) {
            Objects.requireNonNull(elements, "members element");
            if (this.members == null) {
                this.members = new ArrayList<MemberSummary>();
            }
            for (MemberSummary memberSummary : elements) {
                this.members.add(Objects.requireNonNull(memberSummary, "members element"));
            }
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public CreateGroupRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateGroupRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("displayName");
            }
            return "Cannot build CreateGroupRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateGroupRequest", generator="Immutables")
    static final class Json
    extends _CreateGroupRequest {
        String description;
        String displayName;
        List<MemberSummary> members = null;
        String identityZoneId;
        String identityZoneSubdomain;

        Json() {
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="displayName")
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty(value="members")
        public void setMembers(@Nullable List<MemberSummary> members) {
            this.members = members;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<MemberSummary> getMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }
    }
}

