/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.uaa.groups.AbstractMember;
import org.cloudfoundry.uaa.groups.Entity;
import org.cloudfoundry.uaa.groups.MemberType;
import org.cloudfoundry.uaa.groups._Member;
import org.immutables.value.Generated;

@Generated(from="_Member", generator="Immutables")
public final class Member
extends _Member {
    private final Entity entity;
    private final String memberId;
    private final String origin;
    private final MemberType type;

    private Member(Builder builder) {
        this.entity = builder.entity;
        this.memberId = builder.memberId;
        this.origin = builder.origin;
        this.type = builder.type;
    }

    @Override
    @JsonProperty(value="entity")
    public Optional<Entity> getEntity() {
        return Optional.ofNullable(this.entity);
    }

    @Override
    @JsonProperty(value="value")
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    @JsonProperty(value="origin")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Optional<String> getOrigin() {
        return Optional.ofNullable(this.origin);
    }

    @Override
    @JsonProperty(value="type")
    public Optional<MemberType> getType() {
        return Optional.ofNullable(this.type);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Member && this.equalTo((Member)another);
    }

    private boolean equalTo(Member another) {
        return Objects.equals(this.entity, another.entity) && this.memberId.equals(another.memberId) && Objects.equals(this.origin, another.origin) && Objects.equals((Object)this.type, (Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.entity);
        h += (h << 5) + this.memberId.hashCode();
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + Objects.hashCode((Object)this.type);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Member{");
        if (this.entity != null) {
            builder.append("entity=").append(this.entity);
        }
        if (builder.length() > 7) {
            builder.append(", ");
        }
        builder.append("memberId=").append(this.memberId);
        if (this.origin != null) {
            builder.append(", ");
            builder.append("origin=").append(this.origin);
        }
        if (this.type != null) {
            builder.append(", ");
            builder.append("type=").append((Object)this.type);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Member fromJson(Json json) {
        Builder builder = Member.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.memberId != null) {
            builder.memberId(json.memberId);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_Member", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MEMBER_ID = 1L;
        private long initBits = 1L;
        private Entity entity;
        private String memberId;
        private String origin;
        private MemberType type;

        private Builder() {
        }

        public final Builder from(Member instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_Member instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractMember instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractMember instance;
            Optional<Entity> entityOptional;
            if (object instanceof _Member && (entityOptional = ((_Member)(instance = (_Member)object)).getEntity()).isPresent()) {
                this.entity(entityOptional);
            }
            if (object instanceof AbstractMember) {
                Optional<String> originOptional;
                instance = (AbstractMember)object;
                Optional<MemberType> typeOptional = instance.getType();
                if (typeOptional.isPresent()) {
                    this.type(typeOptional);
                }
                if ((originOptional = instance.getOrigin()).isPresent()) {
                    this.origin(originOptional);
                }
                this.memberId(instance.getMemberId());
            }
        }

        public final Builder entity(Entity entity) {
            this.entity = Objects.requireNonNull(entity, "entity");
            return this;
        }

        @JsonProperty(value="entity")
        public final Builder entity(Optional<? extends Entity> entity) {
            this.entity = entity.orElse(null);
            return this;
        }

        @JsonProperty(value="value")
        public final Builder memberId(String memberId) {
            this.memberId = Objects.requireNonNull(memberId, "memberId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            return this;
        }

        @JsonProperty(value="origin")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder origin(Optional<String> origin) {
            this.origin = origin.orElse(null);
            return this;
        }

        public final Builder type(MemberType type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(Optional<? extends MemberType> type) {
            this.type = type.orElse(null);
            return this;
        }

        public Member build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Member(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("memberId");
            }
            return "Cannot build Member, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_Member", generator="Immutables")
    static final class Json
    extends _Member {
        Optional<Entity> entity = Optional.empty();
        String memberId;
        Optional<String> origin = Optional.empty();
        Optional<MemberType> type = Optional.empty();

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(Optional<Entity> entity) {
            this.entity = entity;
        }

        @JsonProperty(value="value")
        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @JsonProperty(value="origin")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setOrigin(Optional<String> origin) {
            this.origin = origin;
        }

        @JsonProperty(value="type")
        public void setType(Optional<MemberType> type) {
            this.type = type;
        }

        @Override
        public Optional<Entity> getEntity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMemberId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<MemberType> getType() {
            throw new UnsupportedOperationException();
        }
    }
}

