/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.users.Email;
import org.cloudfoundry.uaa.users.Name;
import org.cloudfoundry.uaa.users.PhoneNumber;
import org.cloudfoundry.uaa.users._CreateUserRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateUserRequest", generator="Immutables")
public final class CreateUserRequest
extends _CreateUserRequest {
    @Nullable
    private final Boolean active;
    private final List<Email> email;
    @Nullable
    private final String externalId;
    @Nullable
    private final Name name;
    @Nullable
    private final String origin;
    @Nullable
    private final String password;
    @Nullable
    private final List<PhoneNumber> phoneNumbers;
    private final String userName;
    @Nullable
    private final Boolean verified;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private CreateUserRequest(Builder builder) {
        this.active = builder.active;
        this.email = CreateUserRequest.createUnmodifiableList(true, builder.email);
        this.externalId = builder.externalId;
        this.name = builder.name;
        this.origin = builder.origin;
        this.password = builder.password;
        this.phoneNumbers = builder.phoneNumbers == null ? null : CreateUserRequest.createUnmodifiableList(true, builder.phoneNumbers);
        this.userName = builder.userName;
        this.verified = builder.verified;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="active")
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @Override
    @JsonProperty(value="emails")
    public List<Email> getEmail() {
        return this.email;
    }

    @Override
    @JsonProperty(value="externalId")
    @Nullable
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public Name getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="origin")
    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @JsonProperty(value="password")
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @Override
    @JsonProperty(value="phoneNumbers")
    @Nullable
    public List<PhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @Override
    @JsonProperty(value="userName")
    public String getUserName() {
        return this.userName;
    }

    @Override
    @JsonProperty(value="verified")
    @Nullable
    public Boolean getVerified() {
        return this.verified;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateUserRequest && this.equalTo((CreateUserRequest)another);
    }

    private boolean equalTo(CreateUserRequest another) {
        return Objects.equals(this.active, another.active) && this.email.equals(another.email) && Objects.equals(this.externalId, another.externalId) && Objects.equals(this.name, another.name) && Objects.equals(this.origin, another.origin) && Objects.equals(this.password, another.password) && Objects.equals(this.phoneNumbers, another.phoneNumbers) && this.userName.equals(another.userName) && Objects.equals(this.verified, another.verified) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.active);
        h += (h << 5) + this.email.hashCode();
        h += (h << 5) + Objects.hashCode(this.externalId);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.origin);
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + Objects.hashCode(this.phoneNumbers);
        h += (h << 5) + this.userName.hashCode();
        h += (h << 5) + Objects.hashCode(this.verified);
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "CreateUserRequest{active=" + this.active + ", email=" + this.email + ", externalId=" + this.externalId + ", name=" + this.name + ", origin=" + this.origin + ", password=" + this.password + ", phoneNumbers=" + this.phoneNumbers + ", userName=" + this.userName + ", verified=" + this.verified + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateUserRequest fromJson(Json json) {
        Builder builder = CreateUserRequest.builder();
        if (json.active != null) {
            builder.active(json.active);
        }
        if (json.email != null) {
            builder.addAllEmail(json.email);
        }
        if (json.externalId != null) {
            builder.externalId(json.externalId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        if (json.phoneNumbers != null) {
            builder.addAllPhoneNumbers(json.phoneNumbers);
        }
        if (json.userName != null) {
            builder.userName(json.userName);
        }
        if (json.verified != null) {
            builder.verified(json.verified);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        return builder.build();
    }

    private static CreateUserRequest validate(CreateUserRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_CreateUserRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_USER_NAME = 1L;
        private long initBits = 1L;
        private Boolean active;
        private List<Email> email = new ArrayList<Email>();
        private String externalId;
        private Name name;
        private String origin;
        private String password;
        private List<PhoneNumber> phoneNumbers = null;
        private String userName;
        private Boolean verified;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CreateUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_CreateUserRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _CreateUserRequest) {
                String externalIdValue;
                Boolean activeValue;
                Boolean verifiedValue;
                Name nameValue;
                String originValue;
                instance = (_CreateUserRequest)object;
                String passwordValue = ((_CreateUserRequest)instance).getPassword();
                if (passwordValue != null) {
                    this.password(passwordValue);
                }
                if ((originValue = ((_CreateUserRequest)instance).getOrigin()) != null) {
                    this.origin(originValue);
                }
                if ((nameValue = ((_CreateUserRequest)instance).getName()) != null) {
                    this.name(nameValue);
                }
                if ((verifiedValue = ((_CreateUserRequest)instance).getVerified()) != null) {
                    this.verified(verifiedValue);
                }
                if ((activeValue = ((_CreateUserRequest)instance).getActive()) != null) {
                    this.active(activeValue);
                }
                if ((externalIdValue = ((_CreateUserRequest)instance).getExternalId()) != null) {
                    this.externalId(externalIdValue);
                }
                this.userName(((_CreateUserRequest)instance).getUserName());
                this.addAllEmail(((_CreateUserRequest)instance).getEmail());
                List<PhoneNumber> phoneNumbersValue = ((_CreateUserRequest)instance).getPhoneNumbers();
                if (phoneNumbersValue != null) {
                    this.addAllPhoneNumbers(phoneNumbersValue);
                }
            }
        }

        public final Builder active(@Nullable Boolean active) {
            this.active = active;
            return this;
        }

        public final Builder email(Email element) {
            this.email.add(Objects.requireNonNull(element, "email element"));
            return this;
        }

        public final Builder email(Email ... elements) {
            for (Email element : elements) {
                this.email.add(Objects.requireNonNull(element, "email element"));
            }
            return this;
        }

        public final Builder email(Iterable<? extends Email> elements) {
            this.email.clear();
            return this.addAllEmail(elements);
        }

        public final Builder addAllEmail(Iterable<? extends Email> elements) {
            for (Email email : elements) {
                this.email.add(Objects.requireNonNull(email, "email element"));
            }
            return this;
        }

        public final Builder externalId(@Nullable String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Builder name(@Nullable Name name) {
            this.name = name;
            return this;
        }

        public final Builder origin(@Nullable String origin) {
            this.origin = origin;
            return this;
        }

        public final Builder password(@Nullable String password) {
            this.password = password;
            return this;
        }

        public final Builder phoneNumber(PhoneNumber element) {
            if (this.phoneNumbers == null) {
                this.phoneNumbers = new ArrayList<PhoneNumber>();
            }
            this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
            return this;
        }

        public final Builder phoneNumbers(PhoneNumber ... elements) {
            if (this.phoneNumbers == null) {
                this.phoneNumbers = new ArrayList<PhoneNumber>();
            }
            for (PhoneNumber element : elements) {
                this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
            }
            return this;
        }

        public final Builder phoneNumbers(@Nullable Iterable<? extends PhoneNumber> elements) {
            if (elements == null) {
                this.phoneNumbers = null;
                return this;
            }
            this.phoneNumbers = new ArrayList<PhoneNumber>();
            return this.addAllPhoneNumbers(elements);
        }

        public final Builder addAllPhoneNumbers(Iterable<? extends PhoneNumber> elements) {
            Objects.requireNonNull(elements, "phoneNumbers element");
            if (this.phoneNumbers == null) {
                this.phoneNumbers = new ArrayList<PhoneNumber>();
            }
            for (PhoneNumber phoneNumber : elements) {
                this.phoneNumbers.add(Objects.requireNonNull(phoneNumber, "phoneNumbers element"));
            }
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder verified(@Nullable Boolean verified) {
            this.verified = verified;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public CreateUserRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return CreateUserRequest.validate(new CreateUserRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userName");
            }
            return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateUserRequest", generator="Immutables")
    static final class Json
    extends _CreateUserRequest {
        Boolean active;
        List<Email> email = Collections.emptyList();
        String externalId;
        Name name;
        String origin;
        String password;
        List<PhoneNumber> phoneNumbers = null;
        String userName;
        Boolean verified;
        String identityZoneId;
        String identityZoneSubdomain;

        Json() {
        }

        @JsonProperty(value="active")
        public void setActive(@Nullable Boolean active) {
            this.active = active;
        }

        @JsonProperty(value="emails")
        public void setEmail(List<Email> email) {
            this.email = email;
        }

        @JsonProperty(value="externalId")
        public void setExternalId(@Nullable String externalId) {
            this.externalId = externalId;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable Name name) {
            this.name = name;
        }

        @JsonProperty(value="origin")
        public void setOrigin(@Nullable String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="password")
        public void setPassword(@Nullable String password) {
            this.password = password;
        }

        @JsonProperty(value="phoneNumbers")
        public void setPhoneNumbers(@Nullable List<PhoneNumber> phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
        }

        @JsonProperty(value="userName")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @JsonProperty(value="verified")
        public void setVerified(@Nullable Boolean verified) {
            this.verified = verified;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @Override
        public Boolean getActive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Email> getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Name getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPassword() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<PhoneNumber> getPhoneNumbers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getVerified() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }
    }
}

