package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The response payload for the Get Application Permissions operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_GetApplicationPermissionsResponse"})
public final class GetApplicationPermissionsResponse
    extends org.cloudfoundry.client.v2.applications._GetApplicationPermissionsResponse {
  private final Boolean readBasicData;
  private final Boolean readSensitiveData;

  private GetApplicationPermissionsResponse(GetApplicationPermissionsResponse.Builder builder) {
    this.readBasicData = builder.readBasicData;
    this.readSensitiveData = builder.readSensitiveData;
  }

  /**
   * The application id
   */
  @JsonProperty("read_basic_data")
  @Override
  public Boolean getReadBasicData() {
    return readBasicData;
  }

  /**
   * The application id
   */
  @JsonProperty("read_sensitive_data")
  @Override
  public Boolean getReadSensitiveData() {
    return readSensitiveData;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationPermissionsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationPermissionsResponse
        && equalTo((GetApplicationPermissionsResponse) another);
  }

  private boolean equalTo(GetApplicationPermissionsResponse another) {
    return readBasicData.equals(another.readBasicData)
        && readSensitiveData.equals(another.readSensitiveData);
  }

  /**
   * Computes a hash code from attributes: {@code readBasicData}, {@code readSensitiveData}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + readBasicData.hashCode();
    h += (h << 5) + readSensitiveData.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationPermissionsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationPermissionsResponse{"
        + "readBasicData=" + readBasicData
        + ", readSensitiveData=" + readSensitiveData
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.applications._GetApplicationPermissionsResponse {
    Boolean readBasicData;
    Boolean readSensitiveData;
    @JsonProperty("read_basic_data")
    public void setReadBasicData(Boolean readBasicData) {
      this.readBasicData = readBasicData;
    }
    @JsonProperty("read_sensitive_data")
    public void setReadSensitiveData(Boolean readSensitiveData) {
      this.readSensitiveData = readSensitiveData;
    }
    @Override
    public Boolean getReadBasicData() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getReadSensitiveData() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetApplicationPermissionsResponse fromJson(Json json) {
    GetApplicationPermissionsResponse.Builder builder = GetApplicationPermissionsResponse.builder();
    if (json.readBasicData != null) {
      builder.readBasicData(json.readBasicData);
    }
    if (json.readSensitiveData != null) {
      builder.readSensitiveData(json.readSensitiveData);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetApplicationPermissionsResponse GetApplicationPermissionsResponse}.
   * @return A new GetApplicationPermissionsResponse builder
   */
  public static GetApplicationPermissionsResponse.Builder builder() {
    return new GetApplicationPermissionsResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationPermissionsResponse GetApplicationPermissionsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_READ_BASIC_DATA = 0x1L;
    private static final long INIT_BIT_READ_SENSITIVE_DATA = 0x2L;
    private long initBits = 0x3L;

    private Boolean readBasicData;
    private Boolean readSensitiveData;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationPermissionsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationPermissionsResponse instance) {
      return from((_GetApplicationPermissionsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationPermissionsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationPermissionsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      readBasicData(instance.getReadBasicData());
      readSensitiveData(instance.getReadSensitiveData());
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationPermissionsResponse#getReadBasicData() readBasicData} attribute.
     * @param readBasicData The value for readBasicData 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("read_basic_data")
    public final Builder readBasicData(Boolean readBasicData) {
      this.readBasicData = Objects.requireNonNull(readBasicData, "readBasicData");
      initBits &= ~INIT_BIT_READ_BASIC_DATA;
      return this;
    }

    /**
     * Initializes the value for the {@link _GetApplicationPermissionsResponse#getReadSensitiveData() readSensitiveData} attribute.
     * @param readSensitiveData The value for readSensitiveData 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("read_sensitive_data")
    public final Builder readSensitiveData(Boolean readSensitiveData) {
      this.readSensitiveData = Objects.requireNonNull(readSensitiveData, "readSensitiveData");
      initBits &= ~INIT_BIT_READ_SENSITIVE_DATA;
      return this;
    }

    /**
     * Builds a new {@link GetApplicationPermissionsResponse GetApplicationPermissionsResponse}.
     * @return An immutable instance of GetApplicationPermissionsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationPermissionsResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetApplicationPermissionsResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_READ_BASIC_DATA) != 0) attributes.add("readBasicData");
      if ((initBits & INIT_BIT_READ_SENSITIVE_DATA) != 0) attributes.add("readSensitiveData");
      return "Cannot build GetApplicationPermissionsResponse, some of required attributes are not set " + attributes;
    }
  }
}
