package org.cloudfoundry.client.v2.organizations;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Associate Manager with the Organization operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_AssociateOrganizationManagerRequest"})
public final class AssociateOrganizationManagerRequest
    extends org.cloudfoundry.client.v2.organizations._AssociateOrganizationManagerRequest {
  private final String managerId;
  private final String organizationId;

  private AssociateOrganizationManagerRequest(AssociateOrganizationManagerRequest.Builder builder) {
    this.managerId = builder.managerId;
    this.organizationId = builder.organizationId;
  }

  /**
   * The manager id
   */
  @Override
  public String getManagerId() {
    return managerId;
  }

  /**
   * The organization id
   */
  @Override
  public String getOrganizationId() {
    return organizationId;
  }

  /**
   * This instance is equal to all instances of {@code AssociateOrganizationManagerRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof AssociateOrganizationManagerRequest
        && equalTo((AssociateOrganizationManagerRequest) another);
  }

  private boolean equalTo(AssociateOrganizationManagerRequest another) {
    return managerId.equals(another.managerId)
        && organizationId.equals(another.organizationId);
  }

  /**
   * Computes a hash code from attributes: {@code managerId}, {@code organizationId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + managerId.hashCode();
    h += (h << 5) + organizationId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AssociateOrganizationManagerRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AssociateOrganizationManagerRequest{"
        + "managerId=" + managerId
        + ", organizationId=" + organizationId
        + "}";
  }

  /**
   * Creates a builder for {@link AssociateOrganizationManagerRequest AssociateOrganizationManagerRequest}.
   * @return A new AssociateOrganizationManagerRequest builder
   */
  public static AssociateOrganizationManagerRequest.Builder builder() {
    return new AssociateOrganizationManagerRequest.Builder();
  }

  /**
   * Builds instances of type {@link AssociateOrganizationManagerRequest AssociateOrganizationManagerRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_MANAGER_ID = 0x1L;
    private static final long INIT_BIT_ORGANIZATION_ID = 0x2L;
    private long initBits = 0x3L;

    private String managerId;
    private String organizationId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AssociateOrganizationManagerRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AssociateOrganizationManagerRequest instance) {
      return from((_AssociateOrganizationManagerRequest) instance);
    }

    /**
     * Copy abstract value type {@code _AssociateOrganizationManagerRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_AssociateOrganizationManagerRequest instance) {
      Objects.requireNonNull(instance, "instance");
      managerId(instance.getManagerId());
      organizationId(instance.getOrganizationId());
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateOrganizationManagerRequest#getManagerId() managerId} attribute.
     * @param managerId The value for managerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(String managerId) {
      this.managerId = Objects.requireNonNull(managerId, "managerId");
      initBits &= ~INIT_BIT_MANAGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _AssociateOrganizationManagerRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String organizationId) {
      this.organizationId = Objects.requireNonNull(organizationId, "organizationId");
      initBits &= ~INIT_BIT_ORGANIZATION_ID;
      return this;
    }

    /**
     * Builds a new {@link AssociateOrganizationManagerRequest AssociateOrganizationManagerRequest}.
     * @return An immutable instance of AssociateOrganizationManagerRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AssociateOrganizationManagerRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AssociateOrganizationManagerRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_MANAGER_ID) != 0) attributes.add("managerId");
      if ((initBits & INIT_BIT_ORGANIZATION_ID) != 0) attributes.add("organizationId");
      return "Cannot build AssociateOrganizationManagerRequest, some of required attributes are not set " + attributes;
    }
  }
}
