package org.cloudfoundry.client.v2.stacks;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the Create Stack operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CreateStackRequest"})
public final class CreateStackRequest extends org.cloudfoundry.client.v2.stacks._CreateStackRequest {
  private final @Nullable String description;
  private final String name;

  private CreateStackRequest(CreateStackRequest.Builder builder) {
    this.description = builder.description;
    this.name = builder.name;
  }

  /**
   * The stack description
   */
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The stack name
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * This instance is equal to all instances of {@code CreateStackRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateStackRequest
        && equalTo((CreateStackRequest) another);
  }

  private boolean equalTo(CreateStackRequest another) {
    return Objects.equals(description, another.description)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code description}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateStackRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateStackRequest{"
        + "description=" + description
        + ", name=" + name
        + "}";
  }

  /**
   * Creates a builder for {@link CreateStackRequest CreateStackRequest}.
   * @return A new CreateStackRequest builder
   */
  public static CreateStackRequest.Builder builder() {
    return new CreateStackRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateStackRequest CreateStackRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private String description;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateStackRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateStackRequest instance) {
      return from((_CreateStackRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateStackRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateStackRequest instance) {
      Objects.requireNonNull(instance, "instance");
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateStackRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link _CreateStackRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link CreateStackRequest CreateStackRequest}.
     * @return An immutable instance of CreateStackRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateStackRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateStackRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CreateStackRequest, some of required attributes are not set " + attributes;
    }
  }
}
