package org.cloudfoundry.client.v2.users;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the List all Audited Spaces for the User operation
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_ListUserAuditedSpacesRequest"})
public final class ListUserAuditedSpacesRequest
    extends org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest {
  private final @Nullable String applicationId;
  private final @Nullable String developerId;
  private final @Nullable String name;
  private final @Nullable String organizationId;
  private final String userId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListUserAuditedSpacesRequest(ListUserAuditedSpacesRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.developerId = builder.developerId;
    this.name = builder.name;
    this.organizationId = builder.organizationId;
    this.userId = builder.userId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The application id
   */
  @Override
  public @Nullable String getApplicationId() {
    return applicationId;
  }

  /**
   * The developer id
   */
  @Override
  public @Nullable String getDeveloperId() {
    return developerId;
  }

  /**
   * The name
   */
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * The organization id
   */
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The id of the user
   */
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListUserAuditedSpacesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListUserAuditedSpacesRequest
        && equalTo((ListUserAuditedSpacesRequest) another);
  }

  private boolean equalTo(ListUserAuditedSpacesRequest another) {
    return Objects.equals(applicationId, another.applicationId)
        && Objects.equals(developerId, another.developerId)
        && Objects.equals(name, another.name)
        && Objects.equals(organizationId, another.organizationId)
        && userId.equals(another.userId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code developerId}, {@code name}, {@code organizationId}, {@code userId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationId);
    h += (h << 5) + Objects.hashCode(developerId);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListUserAuditedSpacesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListUserAuditedSpacesRequest{"
        + "applicationId=" + applicationId
        + ", developerId=" + developerId
        + ", name=" + name
        + ", organizationId=" + organizationId
        + ", userId=" + userId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListUserAuditedSpacesRequest ListUserAuditedSpacesRequest}.
   * @return A new ListUserAuditedSpacesRequest builder
   */
  public static ListUserAuditedSpacesRequest.Builder builder() {
    return new ListUserAuditedSpacesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListUserAuditedSpacesRequest ListUserAuditedSpacesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private String developerId;
    private String name;
    private String organizationId;
    private String userId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListUserAuditedSpacesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListUserAuditedSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListUserAuditedSpacesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListUserAuditedSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest) {
        org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest instance = (org.cloudfoundry.client.v2.users._ListUserAuditedSpacesRequest) object;
        String organizationIdValue = instance.getOrganizationId();
        if (organizationIdValue != null) {
          organizationId(organizationIdValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String developerIdValue = instance.getDeveloperId();
        if (developerIdValue != null) {
          developerId(developerIdValue);
        }
        String applicationIdValue = instance.getApplicationId();
        if (applicationIdValue != null) {
          applicationId(applicationIdValue);
        }
        userId(instance.getUserId());
      }
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getDeveloperId() developerId} attribute.
     * @param developerId The value for developerId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(@Nullable String developerId) {
      this.developerId = developerId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link _ListUserAuditedSpacesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListUserAuditedSpacesRequest ListUserAuditedSpacesRequest}.
     * @return An immutable instance of ListUserAuditedSpacesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListUserAuditedSpacesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListUserAuditedSpacesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      return "Cannot build ListUserAuditedSpacesRequest, some of required attributes are not set " + attributes;
    }
  }
}
