package org.cloudfoundry.doppler;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * Represents the increment of a counter. It contains only the change in the value; it is the responsibility of downstream consumers to maintain the value of the counter.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "_CounterEvent"})
public final class CounterEvent extends org.cloudfoundry.doppler._CounterEvent {
  private final Long delta;
  private final String name;
  private final @Nullable Long total;

  private CounterEvent(CounterEvent.Builder builder) {
    this.delta = builder.delta;
    this.name = builder.name;
    this.total = builder.total;
  }

  /**
   * The amount by which to increment the counter
   */
  @Override
  public Long getDelta() {
    return delta;
  }

  /**
   * The name of the counter. Must be consistent for downstream consumers to associate events semantically.
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * The total value of the counter. This will be overridden by Metron, which internally tracks the total of each named Counter it receives.
   */
  @Override
  public @Nullable Long getTotal() {
    return total;
  }

  /**
   * This instance is equal to all instances of {@code CounterEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CounterEvent
        && equalTo((CounterEvent) another);
  }

  private boolean equalTo(CounterEvent another) {
    return delta.equals(another.delta)
        && name.equals(another.name)
        && Objects.equals(total, another.total);
  }

  /**
   * Computes a hash code from attributes: {@code delta}, {@code name}, {@code total}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + delta.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(total);
    return h;
  }

  /**
   * Prints the immutable value {@code CounterEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CounterEvent{"
        + "delta=" + delta
        + ", name=" + name
        + ", total=" + total
        + "}";
  }

  /**
   * Creates a builder for {@link CounterEvent CounterEvent}.
   * @return A new CounterEvent builder
   */
  public static CounterEvent.Builder builder() {
    return new CounterEvent.Builder();
  }

  /**
   * Builds instances of type {@link CounterEvent CounterEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_DELTA = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private long initBits = 0x3L;

    private Long delta;
    private String name;
    private Long total;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CounterEvent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CounterEvent instance) {
      return from((_CounterEvent) instance);
    }

    /**
     * Copy abstract value type {@code _CounterEvent} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CounterEvent instance) {
      Objects.requireNonNull(instance, "instance");
      delta(instance.getDelta());
      name(instance.getName());
      Long totalValue = instance.getTotal();
      if (totalValue != null) {
        total(totalValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link _CounterEvent#getDelta() delta} attribute.
     * @param delta The value for delta 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder delta(Long delta) {
      this.delta = Objects.requireNonNull(delta, "delta");
      initBits &= ~INIT_BIT_DELTA;
      return this;
    }

    /**
     * Initializes the value for the {@link _CounterEvent#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link _CounterEvent#getTotal() total} attribute.
     * @param total The value for total (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder total(@Nullable Long total) {
      this.total = total;
      return this;
    }

    /**
     * Builds a new {@link CounterEvent CounterEvent}.
     * @return An immutable instance of CounterEvent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CounterEvent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CounterEvent(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_DELTA) != 0) attributes.add("delta");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build CounterEvent, some of required attributes are not set " + attributes;
    }
  }
}
